package PDF::API2::Util;

use vars qw($VERSION @ISA @EXPORT %colors %winfonts);
use Math::Trig;
use POSIX qw( HUGE_VAL floor );

( $VERSION ) = '$Revisioning: 20020418.102156 $ ' =~ /\$Revisioning:\s+([^\s]+)/;

use Exporter;
@ISA = qw(Exporter);
@EXPORT = qw( 
	pdfkey digest digestx digest16 digest32 
	float floats floats5 intg intgs 
	mMin mMax 
	cRGB cRGB8 RGBasCMYK HSVtoRGB
	namecolor
	opts_from_ttf
	opts_from_pfm
);            

BEGIN {
#	if($^O eq 'MSWin32') {
#		eval q|
#			use Win32;
#			use Win32::TieRegistry;
#			$Registry->Delimiter("/");
#		|;
#	}

        %colors=(
		aliceblue 		=> [0.941176470588235, 0.972549019607843, 1],
		antiquewhite 		=> [0.980392156862745, 0.92156862745098, 0.843137254901961],
		antiquewhite1 		=> [1, 0.937254901960784, 0.858823529411765],
		antiquewhite2 		=> [0.933333333333333, 0.874509803921569, 0.8],
		antiquewhite3 		=> [0.803921568627451, 0.752941176470588, 0.690196078431373],
		antiquewhite4 		=> [0.545098039215686, 0.513725490196078, 0.470588235294118],
		aqua 			=> [0,1,1],
		aquamarine 		=> [0.498039215686275, 1, 0.831372549019608],
		aquamarine1 		=> [0.498039215686275, 1, 0.831372549019608],
		aquamarine2 		=> [0.462745098039216, 0.933333333333333, 0.776470588235294],
		aquamarine3 		=> [0.4, 0.803921568627451, 0.666666666666667],
		aquamarine4 		=> [0.270588235294118, 0.545098039215686, 0.454901960784314],
		azure 			=> [0.941176470588235, 1, 1],
		azure1 			=> [0.941176470588235, 1, 1],
		azure2 			=> [0.87843137254902, 0.933333333333333, 0.933333333333333],
		azure3 			=> [0.756862745098039, 0.803921568627451, 0.803921568627451],
		azure4 			=> [0.513725490196078, 0.545098039215686, 0.545098039215686],
		beige 			=> [0.96078431372549,0.96078431372549,0.862745098039216],
		bisque 			=> [1,0.894117647058824,0.768627450980392],
		bisque1 		=> [1, 0.894117647058824, 0.768627450980392],
		bisque2 		=> [0.933333333333333, 0.835294117647059, 0.717647058823529],
		bisque3 		=> [0.803921568627451, 0.717647058823529, 0.619607843137255],
		bisque4 		=> [0.545098039215686, 0.490196078431373, 0.419607843137255],
		black 			=> [0, 0, 0],
		blanchedalmond 		=> [1, 0.92156862745098, 0.803921568627451],
		blue 			=> [0, 0, 1],
		blue1 			=> [0, 0, 1],
		blue2 			=> [0, 0, 0.933333333333333],
		blue3 			=> [0, 0, 0.803921568627451],
		blue4 			=> [0, 0, 0.545098039215686],
		blueviolet 		=> [0.623529411764706, 0.372549019607843, 0.623529411764706],
		brass 			=> [0.709803921568627, 0.650980392156863, 0.258823529411765],
		brightgold 		=> [0.850980392156863, 0.850980392156863, 0.0980392156862745],
		bronze 			=> [0.549019607843137, 0.470588235294118, 0.325490196078431],
		bronzeii 		=> [0.650980392156863, 0.490196078431373, 0.23921568627451],
		brown 			=> [0.647058823529412, 0.164705882352941, 0.164705882352941],
		brown1 			=> [1, 0.250980392156863, 0.250980392156863],
		brown2 			=> [0.933333333333333, 0.231372549019608, 0.231372549019608],
		brown3 			=> [0.803921568627451, 0.2, 0.2],
		brown4 			=> [0.545098039215686, 0.137254901960784, 0.137254901960784],
		burlywood 		=> [0.870588235294118, 0.72156862745098, 0.529411764705882],
		burlywood1 		=> [1, 0.827450980392157, 0.607843137254902],
		burlywood2 		=> [0.933333333333333, 0.772549019607843, 0.568627450980392],
		burlywood3 		=> [0.803921568627451, 0.666666666666667, 0.490196078431373],
		burlywood4 		=> [0.545098039215686, 0.450980392156863, 0.333333333333333],
		cadetblue 		=> [0.372549019607843,0.619607843137255,0.627450980392157],
		cadetblue1 		=> [0.596078431372549, 0.96078431372549, 1],
		cadetblue2 		=> [0.556862745098039, 0.898039215686275, 0.933333333333333],
		cadetblue3 		=> [0.47843137254902, 0.772549019607843, 0.803921568627451],
		cadetblue4 		=> [0.325490196078431, 0.525490196078431, 0.545098039215686],
		chartreuse 		=> [0.498039215686275,1,0],
		chartreuse1 		=> [0.498039215686275, 1, 0],
		chartreuse2 		=> [0.462745098039216, 0.933333333333333, 0],
		chartreuse3 		=> [0.4, 0.803921568627451, 0],
		chartreuse4 		=> [0.270588235294118, 0.545098039215686, 0],
		chocolate 		=> [0.823529411764706, 0.411764705882353, 0.117647058823529],
		chocolate1 		=> [1, 0.498039215686275, 0.141176470588235],
		chocolate2 		=> [0.933333333333333, 0.462745098039216, 0.129411764705882],
		chocolate3 		=> [0.803921568627451, 0.4, 0.113725490196078],
		chocolate4 		=> [0.545098039215686, 0.270588235294118, 0.0745098039215686],
		coolcopper 		=> [0.850980392156863, 0.529411764705882, 0.0980392156862745],
		coral 			=> [1, 0.498039215686275, 0.313725490196078],
		coral1 			=> [1, 0.447058823529412, 0.337254901960784],
		coral2 			=> [0.933333333333333, 0.415686274509804, 0.313725490196078],
		coral3 			=> [0.803921568627451, 0.356862745098039, 0.270588235294118],
		coral4 			=> [0.545098039215686, 0.243137254901961, 0.184313725490196],
		cornflowerblue 		=> [0.392156862745098, 0.584313725490196, 0.929411764705882],
		cornsilk 		=> [1, 0.972549019607843, 0.862745098039216],
		cornsilk1 		=> [1, 0.972549019607843, 0.862745098039216],
		cornsilk2 		=> [0.933333333333333, 0.909803921568627, 0.803921568627451],
		cornsilk3 		=> [0.803921568627451, 0.784313725490196, 0.694117647058824],
		cornsilk4 		=> [0.545098039215686, 0.533333333333333, 0.470588235294118],
		crimson 		=> [0.862745098039216,0.0784313725490196,0.235294117647059],
		cyan 			=> [0,1,1],
		cyan1 			=> [0, 1, 1],
		cyan2 			=> [0, 0.933333333333333, 0.933333333333333],
		cyan3 			=> [0, 0.803921568627451, 0.803921568627451],
		cyan4 			=> [0, 0.545098039215686, 0.545098039215686],
		darkblue 		=> [0, 0, 0.545098039215686],
		darkcyan 		=> [0, 0.545098039215686, 0.545098039215686],
		darkgoldenrod 		=> [0.72156862745098, 0.525490196078431, 0.0431372549019608],
		darkgoldenrod1 		=> [1, 0.725490196078431, 0.0588235294117647],
		darkgoldenrod2 		=> [0.933333333333333, 0.67843137254902, 0.0549019607843137],
		darkgoldenrod3 		=> [0.803921568627451, 0.584313725490196, 0.0470588235294118],
		darkgoldenrod4 		=> [0.545098039215686, 0.396078431372549, 0.0313725490196078],
		darkgray 		=> [0.662745098039216,0.662745098039216,0.662745098039216],
		darkgreen 		=> [0, 0.392156862745098, 0],
		darkgrey 		=> [0.662745098039216,0.662745098039216,0.662745098039216],
		darkkhaki 		=> [0.741176470588235, 0.717647058823529, 0.419607843137255],
		darkmagenta 		=> [0.545098039215686,0,0.545098039215686],
		darkolivegreen 		=> [0.333333333333333, 0.419607843137255, 0.184313725490196],
		darkolivegreen1 	=> [0.792156862745098, 1, 0.43921568627451],
		darkolivegreen2 	=> [0.737254901960784, 0.933333333333333, 0.407843137254902],
		darkolivegreen3 	=> [0.635294117647059, 0.803921568627451, 0.352941176470588],
		darkolivegreen4 	=> [0.431372549019608, 0.545098039215686, 0.23921568627451],
		darkorange 		=> [1,0.549019607843137,0],
		darkorange1 		=> [1, 0.498039215686275, 0],
		darkorange2 		=> [0.933333333333333, 0.462745098039216, 0],
		darkorange3 		=> [0.803921568627451, 0.4, 0],
		darkorange4 		=> [0.545098039215686, 0.270588235294118, 0],
		darkorchid 		=> [0.6, 0.196078431372549, 0.8],
		darkorchid1 		=> [0.749019607843137, 0.243137254901961, 1],
		darkorchid2 		=> [0.698039215686274, 0.227450980392157, 0.933333333333333],
		darkorchid3 		=> [0.603921568627451, 0.196078431372549, 0.803921568627451],
		darkorchid4 		=> [0.407843137254902, 0.133333333333333, 0.545098039215686],
		darkred 		=> [0.545098039215686, 0, 0],
		darksalmon 		=> [0.913725490196078, 0.588235294117647, 0.47843137254902],
		darkseagreen 		=> [0.56078431372549, 0.737254901960784, 0.56078431372549],
		darkseagreen1 		=> [0.756862745098039, 1, 0.756862745098039],
		darkseagreen2 		=> [0.705882352941177, 0.933333333333333, 0.705882352941177],
		darkseagreen3 		=> [0.607843137254902, 0.803921568627451, 0.607843137254902],
		darkseagreen4 		=> [0.411764705882353, 0.545098039215686, 0.411764705882353],
		darkslateblue 		=> [0.282352941176471, 0.23921568627451, 0.545098039215686],
		darkslategray 		=> [0.184313725490196, 0.309803921568627, 0.309803921568627],
		darkslategray1 		=> [0.592156862745098, 1, 1],
		darkslategray2 		=> [0.552941176470588, 0.933333333333333, 0.933333333333333],
		darkslategray3 		=> [0.474509803921569, 0.803921568627451, 0.803921568627451],
		darkslategray4 		=> [0.32156862745098, 0.545098039215686, 0.545098039215686],
		darkslategrey 		=> [0.184313725490196, 0.309803921568627, 0.309803921568627],
		darkturquoise 		=> [0, 0.807843137254902, 0.819607843137255],
		darkviolet 		=> [0.580392156862745, 0, 0.827450980392157],
		darkwood 		=> [0.52156862745098, 0.368627450980392, 0.258823529411765],
		deeppink 		=> [1, 0.0784313725490196, 0.576470588235294],
		deeppink1 		=> [1, 0.0784313725490196, 0.576470588235294],
		deeppink2 		=> [0.933333333333333, 0.0705882352941176, 0.537254901960784],
		deeppink3 		=> [0.803921568627451, 0.0627450980392157, 0.462745098039216],
		deeppink4 		=> [0.545098039215686, 0.0392156862745098, 0.313725490196078],
		deepskyblue 		=> [0, 0.749019607843137, 1],
		deepskyblue1 		=> [0, 0.749019607843137, 1],
		deepskyblue2 		=> [0, 0.698039215686274, 0.933333333333333],
		deepskyblue3 		=> [0, 0.603921568627451, 0.803921568627451],
		deepskyblue4 		=> [0, 0.407843137254902, 0.545098039215686],
		dimgray 		=> [0.411764705882353, 0.411764705882353, 0.411764705882353],
		dimgrey 		=> [0.411764705882353,0.411764705882353,0.411764705882353],
		dodgerblue 		=> [0.117647058823529, 0.564705882352941, 1],
		dodgerblue1 		=> [0.117647058823529, 0.564705882352941, 1],
		dodgerblue2 		=> [0.109803921568627, 0.525490196078431, 0.933333333333333],
		dodgerblue3 		=> [0.0941176470588235, 0.454901960784314, 0.803921568627451],
		dodgerblue4 		=> [0.0627450980392157, 0.305882352941176, 0.545098039215686],
		dustyrose 		=> [0.52156862745098, 0.388235294117647, 0.388235294117647],
		feldspar 		=> [0.819607843137255, 0.572549019607843, 0.458823529411765],
		firebrick 		=> [0.556862745098039, 0.137254901960784, 0.137254901960784],
		firebrick 		=> [0.698039215686274, 0.133333333333333, 0.133333333333333],
		firebrick1 		=> [1, 0.188235294117647, 0.188235294117647],
		firebrick2 		=> [0.933333333333333, 0.172549019607843, 0.172549019607843],
		firebrick3 		=> [0.803921568627451, 0.149019607843137, 0.149019607843137],
		firebrick4 		=> [0.545098039215686, 0.101960784313725, 0.101960784313725],
		flesh 			=> [0.96078431372549, 0.8, 0.690196078431373],
		floralwhite 		=> [1, 0.980392156862745, 0.941176470588235],
		forestgreen 		=> [0.133333333333333, 0.545098039215686, 0.133333333333333],
		fuchsia 		=> [1,0,1],
		gainsboro 		=> [0.862745098039216, 0.862745098039216, 0.862745098039216],
		ghostwhite 		=> [0.972549019607843, 0.972549019607843, 1],
		gold 			=> [1, 0.843137254901961, 0],
		gold1 			=> [1, 0.843137254901961, 0],
		gold2 			=> [0.933333333333333, 0.788235294117647, 0],
		gold3 			=> [0.803921568627451, 0.67843137254902, 0],
		gold4 			=> [0.545098039215686, 0.458823529411765, 0],
		goldenrod 		=> [0.854901960784314, 0.647058823529412, 0.125490196078431],
		goldenrod1 		=> [1, 0.756862745098039, 0.145098039215686],
		goldenrod2 		=> [0.933333333333333, 0.705882352941177, 0.133333333333333],
		goldenrod3 		=> [0.803921568627451, 0.607843137254902, 0.113725490196078],
		goldenrod4 		=> [0.545098039215686, 0.411764705882353, 0.0784313725490196],
		gray 			=> [0.501960784313725,0.501960784313725,0.501960784313725],
		gray0 			=> [0, 0, 0],
		gray1 			=> [0.0117647058823529, 0.0117647058823529, 0.0117647058823529],
		gray10 			=> [0.101960784313725, 0.101960784313725, 0.101960784313725],
		gray100 		=> [1, 1, 1],
		gray11 			=> [0.109803921568627, 0.109803921568627, 0.109803921568627],
		gray12 			=> [0.12156862745098, 0.12156862745098, 0.12156862745098],
		gray13 			=> [0.129411764705882, 0.129411764705882, 0.129411764705882],
		gray14 			=> [0.141176470588235, 0.141176470588235, 0.141176470588235],
		gray15 			=> [0.149019607843137, 0.149019607843137, 0.149019607843137],
		gray16 			=> [0.16078431372549, 0.16078431372549, 0.16078431372549],
		gray17 			=> [0.168627450980392, 0.168627450980392, 0.168627450980392],
		gray18 			=> [0.180392156862745, 0.180392156862745, 0.180392156862745],
		gray19 			=> [0.188235294117647, 0.188235294117647, 0.188235294117647],
		gray2 			=> [0.0196078431372549, 0.0196078431372549, 0.0196078431372549],
		gray20 			=> [0.2, 0.2, 0.2],
		gray21 			=> [0.211764705882353, 0.211764705882353, 0.211764705882353],
		gray22 			=> [0.219607843137255, 0.219607843137255, 0.219607843137255],
		gray23 			=> [0.231372549019608, 0.231372549019608, 0.231372549019608],
		gray24 			=> [0.23921568627451, 0.23921568627451, 0.23921568627451],
		gray25 			=> [0.250980392156863, 0.250980392156863, 0.250980392156863],
		gray26 			=> [0.258823529411765, 0.258823529411765, 0.258823529411765],
		gray27 			=> [0.270588235294118, 0.270588235294118, 0.270588235294118],
		gray28 			=> [0.27843137254902, 0.27843137254902, 0.27843137254902],
		gray29 			=> [0.290196078431373, 0.290196078431373, 0.290196078431373],
		gray3 			=> [0.0313725490196078, 0.0313725490196078, 0.0313725490196078],
		gray30 			=> [0.301960784313725, 0.301960784313725, 0.301960784313725],
		gray31 			=> [0.309803921568627, 0.309803921568627, 0.309803921568627],
		gray32 			=> [0.32156862745098, 0.32156862745098, 0.32156862745098],
		gray33 			=> [0.329411764705882, 0.329411764705882, 0.329411764705882],
		gray34 			=> [0.341176470588235, 0.341176470588235, 0.341176470588235],
		gray35 			=> [0.349019607843137, 0.349019607843137, 0.349019607843137],
		gray36 			=> [0.36078431372549, 0.36078431372549, 0.36078431372549],
		gray37 			=> [0.368627450980392, 0.368627450980392, 0.368627450980392],
		gray38 			=> [0.380392156862745, 0.380392156862745, 0.380392156862745],
		gray39 			=> [0.388235294117647, 0.388235294117647, 0.388235294117647],
		gray4 			=> [0.0392156862745098, 0.0392156862745098, 0.0392156862745098],
		gray40 			=> [0.4, 0.4, 0.4],
		gray41 			=> [0.411764705882353, 0.411764705882353, 0.411764705882353],
		gray42 			=> [0.419607843137255, 0.419607843137255, 0.419607843137255],
		gray43 			=> [0.431372549019608, 0.431372549019608, 0.431372549019608],
		gray44 			=> [0.43921568627451, 0.43921568627451, 0.43921568627451],
		gray45 			=> [0.450980392156863, 0.450980392156863, 0.450980392156863],
		gray46 			=> [0.458823529411765, 0.458823529411765, 0.458823529411765],
		gray47 			=> [0.470588235294118, 0.470588235294118, 0.470588235294118],
		gray48 			=> [0.47843137254902, 0.47843137254902, 0.47843137254902],
		gray49 			=> [0.490196078431373, 0.490196078431373, 0.490196078431373],
		gray5 			=> [0.0509803921568627, 0.0509803921568627, 0.0509803921568627],
		gray50 			=> [0.498039215686275, 0.498039215686275, 0.498039215686275],
		gray51 			=> [0.509803921568627, 0.509803921568627, 0.509803921568627],
		gray52 			=> [0.52156862745098, 0.52156862745098, 0.52156862745098],
		gray53 			=> [0.529411764705882, 0.529411764705882, 0.529411764705882],
		gray54 			=> [0.541176470588235, 0.541176470588235, 0.541176470588235],
		gray55 			=> [0.549019607843137, 0.549019607843137, 0.549019607843137],
		gray56 			=> [0.56078431372549, 0.56078431372549, 0.56078431372549],
		gray57 			=> [0.568627450980392, 0.568627450980392, 0.568627450980392],
		gray58 			=> [0.580392156862745, 0.580392156862745, 0.580392156862745],
		gray59 			=> [0.588235294117647, 0.588235294117647, 0.588235294117647],
		gray6 			=> [0.0588235294117647, 0.0588235294117647, 0.0588235294117647],
		gray60 			=> [0.6, 0.6, 0.6],
		gray61 			=> [0.611764705882353, 0.611764705882353, 0.611764705882353],
		gray62 			=> [0.619607843137255, 0.619607843137255, 0.619607843137255],
		gray63 			=> [0.631372549019608, 0.631372549019608, 0.631372549019608],
		gray64 			=> [0.63921568627451, 0.63921568627451, 0.63921568627451],
		gray65 			=> [0.650980392156863, 0.650980392156863, 0.650980392156863],
		gray66 			=> [0.658823529411765, 0.658823529411765, 0.658823529411765],
		gray67 			=> [0.670588235294118, 0.670588235294118, 0.670588235294118],
		gray68 			=> [0.67843137254902, 0.67843137254902, 0.67843137254902],
		gray69 			=> [0.690196078431373, 0.690196078431373, 0.690196078431373],
		gray7 			=> [0.0705882352941176, 0.0705882352941176, 0.0705882352941176],
		gray70 			=> [0.701960784313725, 0.701960784313725, 0.701960784313725],
		gray71 			=> [0.709803921568627, 0.709803921568627, 0.709803921568627],
		gray72 			=> [0.72156862745098, 0.72156862745098, 0.72156862745098],
		gray73 			=> [0.729411764705882, 0.729411764705882, 0.729411764705882],
		gray74 			=> [0.741176470588235, 0.741176470588235, 0.741176470588235],
		gray75 			=> [0.749019607843137, 0.749019607843137, 0.749019607843137],
		gray76 			=> [0.76078431372549, 0.76078431372549, 0.76078431372549],
		gray77 			=> [0.768627450980392, 0.768627450980392, 0.768627450980392],
		gray78 			=> [0.780392156862745, 0.780392156862745, 0.780392156862745],
		gray79 			=> [0.788235294117647, 0.788235294117647, 0.788235294117647],
		gray8 			=> [0.0784313725490196, 0.0784313725490196, 0.0784313725490196],
		gray80 			=> [0.8, 0.8, 0.8],
		gray81 			=> [0.811764705882353, 0.811764705882353, 0.811764705882353],
		gray82 			=> [0.819607843137255, 0.819607843137255, 0.819607843137255],
		gray83 			=> [0.831372549019608, 0.831372549019608, 0.831372549019608],
		gray84 			=> [0.83921568627451, 0.83921568627451, 0.83921568627451],
		gray85 			=> [0.850980392156863, 0.850980392156863, 0.850980392156863],
		gray86 			=> [0.858823529411765, 0.858823529411765, 0.858823529411765],
		gray87 			=> [0.870588235294118, 0.870588235294118, 0.870588235294118],
		gray88 			=> [0.87843137254902, 0.87843137254902, 0.87843137254902],
		gray89 			=> [0.890196078431372, 0.890196078431372, 0.890196078431372],
		gray9 			=> [0.0901960784313725, 0.0901960784313725, 0.0901960784313725],
		gray90 			=> [0.898039215686275, 0.898039215686275, 0.898039215686275],
		gray91 			=> [0.909803921568627, 0.909803921568627, 0.909803921568627],
		gray92 			=> [0.92156862745098, 0.92156862745098, 0.92156862745098],
		gray93 			=> [0.929411764705882, 0.929411764705882, 0.929411764705882],
		gray94 			=> [0.941176470588235, 0.941176470588235, 0.941176470588235],
		gray95 			=> [0.949019607843137, 0.949019607843137, 0.949019607843137],
		gray96 			=> [0.96078431372549, 0.96078431372549, 0.96078431372549],
		gray97 			=> [0.968627450980392, 0.968627450980392, 0.968627450980392],
		gray98 			=> [0.980392156862745, 0.980392156862745, 0.980392156862745],
		gray99 			=> [0.988235294117647, 0.988235294117647, 0.988235294117647],
		green 			=> [0,0.501960784313725,0],
		green1 			=> [0, 1, 0],
		green2 			=> [0, 0.933333333333333, 0],
		green3 			=> [0, 0.803921568627451, 0],
		green4 			=> [0, 0.545098039215686, 0],
		greencopper 		=> [0.52156862745098, 0.388235294117647, 0.388235294117647],
		greenyellow 		=> [0.819607843137255, 0.572549019607843, 0.458823529411765],
		grey 			=> [0.745098039215686, 0.745098039215686, 0.745098039215686],
		grey0 			=> [0, 0, 0],
		grey1 			=> [0.0117647058823529, 0.0117647058823529, 0.0117647058823529],
		grey10 			=> [0.101960784313725, 0.101960784313725, 0.101960784313725],
		grey100 		=> [1, 1, 1],
		grey11 			=> [0.109803921568627, 0.109803921568627, 0.109803921568627],
		grey12 			=> [0.12156862745098, 0.12156862745098, 0.12156862745098],
		grey13 			=> [0.129411764705882, 0.129411764705882, 0.129411764705882],
		grey14 			=> [0.141176470588235, 0.141176470588235, 0.141176470588235],
		grey15 			=> [0.149019607843137, 0.149019607843137, 0.149019607843137],
		grey16 			=> [0.16078431372549, 0.16078431372549, 0.16078431372549],
		grey17 			=> [0.168627450980392, 0.168627450980392, 0.168627450980392],
		grey18 			=> [0.180392156862745, 0.180392156862745, 0.180392156862745],
		grey19 			=> [0.188235294117647, 0.188235294117647, 0.188235294117647],
		grey2 			=> [0.0196078431372549, 0.0196078431372549, 0.0196078431372549],
		grey20 			=> [0.2, 0.2, 0.2],
		grey21 			=> [0.211764705882353, 0.211764705882353, 0.211764705882353],
		grey22 			=> [0.219607843137255, 0.219607843137255, 0.219607843137255],
		grey23 			=> [0.231372549019608, 0.231372549019608, 0.231372549019608],
		grey24 			=> [0.23921568627451, 0.23921568627451, 0.23921568627451],
		grey25 			=> [0.250980392156863, 0.250980392156863, 0.250980392156863],
		grey26 			=> [0.258823529411765, 0.258823529411765, 0.258823529411765],
		grey27 			=> [0.270588235294118, 0.270588235294118, 0.270588235294118],
		grey28 			=> [0.27843137254902, 0.27843137254902, 0.27843137254902],
		grey29 			=> [0.290196078431373, 0.290196078431373, 0.290196078431373],
		grey3 			=> [0.0313725490196078, 0.0313725490196078, 0.0313725490196078],
		grey30 			=> [0.301960784313725, 0.301960784313725, 0.301960784313725],
		grey31 			=> [0.309803921568627, 0.309803921568627, 0.309803921568627],
		grey32 			=> [0.32156862745098, 0.32156862745098, 0.32156862745098],
		grey33 			=> [0.329411764705882, 0.329411764705882, 0.329411764705882],
		grey34 			=> [0.341176470588235, 0.341176470588235, 0.341176470588235],
		grey35 			=> [0.349019607843137, 0.349019607843137, 0.349019607843137],
		grey36 			=> [0.36078431372549, 0.36078431372549, 0.36078431372549],
		grey37 			=> [0.368627450980392, 0.368627450980392, 0.368627450980392],
		grey38 			=> [0.380392156862745, 0.380392156862745, 0.380392156862745],
		grey39 			=> [0.388235294117647, 0.388235294117647, 0.388235294117647],
		grey4 			=> [0.0392156862745098, 0.0392156862745098, 0.0392156862745098],
		grey40 			=> [0.4, 0.4, 0.4],
		grey41 			=> [0.411764705882353, 0.411764705882353, 0.411764705882353],
		grey42 			=> [0.419607843137255, 0.419607843137255, 0.419607843137255],
		grey43 			=> [0.431372549019608, 0.431372549019608, 0.431372549019608],
		grey44 			=> [0.43921568627451, 0.43921568627451, 0.43921568627451],
		grey45 			=> [0.450980392156863, 0.450980392156863, 0.450980392156863],
		grey46 			=> [0.458823529411765, 0.458823529411765, 0.458823529411765],
		grey47 			=> [0.470588235294118, 0.470588235294118, 0.470588235294118],
		grey48 			=> [0.47843137254902, 0.47843137254902, 0.47843137254902],
		grey49 			=> [0.490196078431373, 0.490196078431373, 0.490196078431373],
		grey5 			=> [0.0509803921568627, 0.0509803921568627, 0.0509803921568627],
		grey50 			=> [0.498039215686275, 0.498039215686275, 0.498039215686275],
		grey51 			=> [0.509803921568627, 0.509803921568627, 0.509803921568627],
		grey52 			=> [0.52156862745098, 0.52156862745098, 0.52156862745098],
		grey53 			=> [0.529411764705882, 0.529411764705882, 0.529411764705882],
		grey54 			=> [0.541176470588235, 0.541176470588235, 0.541176470588235],
		grey55 			=> [0.549019607843137, 0.549019607843137, 0.549019607843137],
		grey56 			=> [0.56078431372549, 0.56078431372549, 0.56078431372549],
		grey57 			=> [0.568627450980392, 0.568627450980392, 0.568627450980392],
		grey58 			=> [0.580392156862745, 0.580392156862745, 0.580392156862745],
		grey59 			=> [0.588235294117647, 0.588235294117647, 0.588235294117647],
		grey6 			=> [0.0588235294117647, 0.0588235294117647, 0.0588235294117647],
		grey60 			=> [0.6, 0.6, 0.6],
		grey61 			=> [0.611764705882353, 0.611764705882353, 0.611764705882353],
		grey62 			=> [0.619607843137255, 0.619607843137255, 0.619607843137255],
		grey63 			=> [0.631372549019608, 0.631372549019608, 0.631372549019608],
		grey64 			=> [0.63921568627451, 0.63921568627451, 0.63921568627451],
		grey65 			=> [0.650980392156863, 0.650980392156863, 0.650980392156863],
		grey66 			=> [0.658823529411765, 0.658823529411765, 0.658823529411765],
		grey67 			=> [0.670588235294118, 0.670588235294118, 0.670588235294118],
		grey68 			=> [0.67843137254902, 0.67843137254902, 0.67843137254902],
		grey69 			=> [0.690196078431373, 0.690196078431373, 0.690196078431373],
		grey7 			=> [0.0705882352941176, 0.0705882352941176, 0.0705882352941176],
		grey70 			=> [0.701960784313725, 0.701960784313725, 0.701960784313725],
		grey71 			=> [0.709803921568627, 0.709803921568627, 0.709803921568627],
		grey72 			=> [0.72156862745098, 0.72156862745098, 0.72156862745098],
		grey73 			=> [0.729411764705882, 0.729411764705882, 0.729411764705882],
		grey74 			=> [0.741176470588235, 0.741176470588235, 0.741176470588235],
		grey75 			=> [0.749019607843137, 0.749019607843137, 0.749019607843137],
		grey76 			=> [0.76078431372549, 0.76078431372549, 0.76078431372549],
		grey77 			=> [0.768627450980392, 0.768627450980392, 0.768627450980392],
		grey78 			=> [0.780392156862745, 0.780392156862745, 0.780392156862745],
		grey79 			=> [0.788235294117647, 0.788235294117647, 0.788235294117647],
		grey8 			=> [0.0784313725490196, 0.0784313725490196, 0.0784313725490196],
		grey80 			=> [0.8, 0.8, 0.8],
		grey81 			=> [0.811764705882353, 0.811764705882353, 0.811764705882353],
		grey82 			=> [0.819607843137255, 0.819607843137255, 0.819607843137255],
		grey83 			=> [0.831372549019608, 0.831372549019608, 0.831372549019608],
		grey84 			=> [0.83921568627451, 0.83921568627451, 0.83921568627451],
		grey85 			=> [0.850980392156863, 0.850980392156863, 0.850980392156863],
		grey86 			=> [0.858823529411765, 0.858823529411765, 0.858823529411765],
		grey87 			=> [0.870588235294118, 0.870588235294118, 0.870588235294118],
		grey88 			=> [0.87843137254902, 0.87843137254902, 0.87843137254902],
		grey89 			=> [0.890196078431372, 0.890196078431372, 0.890196078431372],
		grey9 			=> [0.0901960784313725, 0.0901960784313725, 0.0901960784313725],
		grey90 			=> [0.898039215686275, 0.898039215686275, 0.898039215686275],
		grey91 			=> [0.909803921568627, 0.909803921568627, 0.909803921568627],
		grey92 			=> [0.92156862745098, 0.92156862745098, 0.92156862745098],
		grey93 			=> [0.929411764705882, 0.929411764705882, 0.929411764705882],
		grey94 			=> [0.941176470588235, 0.941176470588235, 0.941176470588235],
		grey95 			=> [0.949019607843137, 0.949019607843137, 0.949019607843137],
		grey96 			=> [0.96078431372549, 0.96078431372549, 0.96078431372549],
		grey97 			=> [0.968627450980392, 0.968627450980392, 0.968627450980392],
		grey98 			=> [0.980392156862745, 0.980392156862745, 0.980392156862745],
		grey99 			=> [0.988235294117647, 0.988235294117647, 0.988235294117647],
		honeydew 		=> [0.941176470588235,1,0.941176470588235],
		honeydew1 		=> [0.941176470588235, 1, 0.941176470588235],
		honeydew2 		=> [0.87843137254902, 0.933333333333333, 0.87843137254902],
		honeydew3 		=> [0.756862745098039, 0.803921568627451, 0.756862745098039],
		honeydew4 		=> [0.513725490196078, 0.545098039215686, 0.513725490196078],
		hotpink 		=> [1,0.411764705882353,0.705882352941177],
		hotpink1 		=> [1, 0.431372549019608, 0.705882352941177],
		hotpink2 		=> [0.933333333333333, 0.415686274509804, 0.654901960784314],
		hotpink3 		=> [0.803921568627451, 0.376470588235294, 0.564705882352941],
		hotpink4 		=> [0.545098039215686, 0.227450980392157, 0.384313725490196],
		indianred 		=> [0.96078431372549, 0.8, 0.690196078431373],
		indianred1 		=> [1, 0.415686274509804, 0.415686274509804],
		indianred2 		=> [0.933333333333333, 0.388235294117647, 0.388235294117647],
		indianred3 		=> [0.803921568627451, 0.333333333333333, 0.333333333333333],
		indianred4 		=> [0.545098039215686, 0.227450980392157, 0.227450980392157],
		indigo 			=> [0.294117647058824,0,0.509803921568627],
		ivory 			=> [1,1,0.941176470588235],
		ivory1 			=> [1, 1, 0.941176470588235],
		ivory2 			=> [0.933333333333333, 0.933333333333333, 0.87843137254902],
		ivory3 			=> [0.803921568627451, 0.803921568627451, 0.756862745098039],
		ivory4 			=> [0.545098039215686, 0.545098039215686, 0.513725490196078],
		khaki 			=> [0.941176470588235,0.901960784313726,0.549019607843137],
		khaki1 			=> [1, 0.964705882352941, 0.56078431372549],
		khaki2 			=> [0.933333333333333, 0.901960784313726, 0.52156862745098],
		khaki3 			=> [0.803921568627451, 0.776470588235294, 0.450980392156863],
		khaki4 			=> [0.545098039215686, 0.525490196078431, 0.305882352941176],
		lavender 		=> [0.901960784313726,0.901960784313726,0.980392156862745],
		lavenderblush 		=> [1, 0.941176470588235, 0.96078431372549],
		lavenderblush1 		=> [1, 0.941176470588235, 0.96078431372549],
		lavenderblush2 		=> [0.933333333333333, 0.87843137254902, 0.898039215686275],
		lavenderblush3 		=> [0.803921568627451, 0.756862745098039, 0.772549019607843],
		lavenderblush4 		=> [0.545098039215686, 0.513725490196078, 0.525490196078431],
		lawngreen 		=> [0.486274509803922, 0.988235294117647, 0],
		lemonchiffon 		=> [1, 0.980392156862745, 0.803921568627451],
		lemonchiffon1 		=> [1, 0.980392156862745, 0.803921568627451],
		lemonchiffon2 		=> [0.933333333333333, 0.913725490196078, 0.749019607843137],
		lemonchiffon3 		=> [0.803921568627451, 0.788235294117647, 0.647058823529412],
		lemonchiffon4 		=> [0.545098039215686, 0.537254901960784, 0.43921568627451],
		lightblue 		=> [0.67843137254902,0.847058823529412,0.901960784313726],
		lightblue1 		=> [0.749019607843137, 0.937254901960784, 1],
		lightblue2 		=> [0.698039215686274, 0.874509803921569, 0.933333333333333],
		lightblue3 		=> [0.603921568627451, 0.752941176470588, 0.803921568627451],
		lightblue4 		=> [0.407843137254902, 0.513725490196078, 0.545098039215686],
		lightcoral 		=> [0.941176470588235, 0.501960784313725, 0.501960784313725],
		lightcyan 		=> [0.87843137254902,1,1],
		lightcyan1 		=> [0.87843137254902, 1, 1],
		lightcyan2 		=> [0.819607843137255, 0.933333333333333, 0.933333333333333],
		lightcyan3 		=> [0.705882352941177, 0.803921568627451, 0.803921568627451],
		lightcyan4 		=> [0.47843137254902, 0.545098039215686, 0.545098039215686],
		lightgoldenrod 		=> [0.933333333333333, 0.866666666666667, 0.509803921568627],
		lightgoldenrod1 	=> [1, 0.925490196078431, 0.545098039215686],
		lightgoldenrod2 	=> [0.933333333333333, 0.862745098039216, 0.509803921568627],
		lightgoldenrod3 	=> [0.803921568627451, 0.745098039215686, 0.43921568627451],
		lightgoldenrod4 	=> [0.545098039215686, 0.505882352941176, 0.298039215686275],
		lightgoldenrodyellow 	=> [0.980392156862745, 0.980392156862745, 0.823529411764706],
		lightgray 		=> [0.827450980392157, 0.827450980392157, 0.827450980392157],
		lightgreen 		=> [0.564705882352941, 0.933333333333333, 0.564705882352941],
		lightgrey 		=> [0.827450980392157,0.827450980392157,0.827450980392157],
		lightpink 		=> [1, 0.713725490196078, 0.756862745098039],
		lightpink1 		=> [1, 0.682352941176471, 0.725490196078431],
		lightpink2 		=> [0.933333333333333, 0.635294117647059, 0.67843137254902],
		lightpink3 		=> [0.803921568627451, 0.549019607843137, 0.584313725490196],
		lightpink4 		=> [0.545098039215686, 0.372549019607843, 0.396078431372549],
		lightsalmon 		=> [1, 0.627450980392157, 0.47843137254902],
		lightsalmon1 		=> [1, 0.627450980392157, 0.47843137254902],
		lightsalmon2 		=> [0.933333333333333, 0.584313725490196, 0.447058823529412],
		lightsalmon3 		=> [0.803921568627451, 0.505882352941176, 0.384313725490196],
		lightsalmon4 		=> [0.545098039215686, 0.341176470588235, 0.258823529411765],
		lightseagreen 		=> [0.125490196078431, 0.698039215686274, 0.666666666666667],
		lightskyblue 		=> [0.529411764705882,0.807843137254902,0.980392156862745],
		lightskyblue1 		=> [0.690196078431373, 0.886274509803922, 1],
		lightskyblue2 		=> [0.643137254901961, 0.827450980392157, 0.933333333333333],
		lightskyblue3 		=> [0.552941176470588, 0.713725490196078, 0.803921568627451],
		lightskyblue4 		=> [0.376470588235294, 0.482352941176471, 0.545098039215686],
		lightslateblue 		=> [0.517647058823529, 0.43921568627451, 1],
		lightslategray 		=> [0.466666666666667, 0.533333333333333, 0.6],
		lightslategrey 		=> [0.466666666666667,0.533333333333333,0.6],
		lightsteelblue 		=> [0.690196078431373, 0.768627450980392, 0.870588235294118],
		lightsteelblue1 	=> [0.792156862745098, 0.882352941176471, 1],
		lightsteelblue2 	=> [0.737254901960784, 0.823529411764706, 0.933333333333333],
		lightsteelblue3 	=> [0.635294117647059, 0.709803921568627, 0.803921568627451],
		lightsteelblue4 	=> [0.431372549019608, 0.482352941176471, 0.545098039215686],
		lightyellow 		=> [1, 1, 0.87843137254902],
		lightyellow1 		=> [1, 1, 0.87843137254902],
		lightyellow2 		=> [0.933333333333333, 0.933333333333333, 0.819607843137255],
		lightyellow3 		=> [0.803921568627451, 0.803921568627451, 0.705882352941177],
		lightyellow4 		=> [0.545098039215686, 0.545098039215686, 0.47843137254902],
		lime 			=> [0,1,0],
		limegreen 		=> [0.196078431372549, 0.803921568627451, 0.196078431372549],
		linen 			=> [0.980392156862745, 0.941176470588235, 0.901960784313726],
		magenta 		=> [1,0,1],
		magenta1 		=> [1, 0, 1],
		magenta2 		=> [0.933333333333333, 0, 0.933333333333333],
		magenta3 		=> [0.803921568627451, 0, 0.803921568627451],
		magenta4 		=> [0.545098039215686, 0, 0.545098039215686],
		mandarianorange 	=> [0.556862745098039, 0.137254901960784, 0.137254901960784],
		maroon 			=> [0.501960784313725,0,0],
		maroon1 		=> [1, 0.203921568627451, 0.701960784313725],
		maroon2 		=> [0.933333333333333, 0.188235294117647, 0.654901960784314],
		maroon3 		=> [0.803921568627451, 0.16078431372549, 0.564705882352941],
		maroon4 		=> [0.545098039215686, 0.109803921568627, 0.384313725490196],
		mediumaquamarine 	=> [0.4, 0.803921568627451, 0.666666666666667],
		mediumblue 		=> [0, 0, 0.803921568627451],
		mediumorchid 		=> [0.729411764705882, 0.333333333333333, 0.827450980392157],
		mediumorchid1 		=> [0.87843137254902, 0.4, 1],
		mediumorchid2 		=> [0.819607843137255, 0.372549019607843, 0.933333333333333],
		mediumorchid3 		=> [0.705882352941177, 0.32156862745098, 0.803921568627451],
		mediumorchid4 		=> [0.47843137254902, 0.215686274509804, 0.545098039215686],
		mediumpurple 		=> [0.576470588235294,0.43921568627451,0.858823529411765],
		mediumpurple1 		=> [0.670588235294118, 0.509803921568627, 1],
		mediumpurple2 		=> [0.623529411764706, 0.474509803921569, 0.933333333333333],
		mediumpurple3 		=> [0.537254901960784, 0.407843137254902, 0.803921568627451],
		mediumpurple4 		=> [0.364705882352941, 0.27843137254902, 0.545098039215686],
		mediumseagreen 		=> [0.235294117647059, 0.701960784313725, 0.443137254901961],
		mediumslateblue 	=> [0.482352941176471, 0.407843137254902, 0.933333333333333],
		mediumspringgreen 	=> [0, 0.980392156862745, 0.603921568627451],
		mediumturquoise 	=> [0.282352941176471, 0.819607843137255, 0.8],
		mediumvioletred 	=> [0.780392156862745, 0.0823529411764706, 0.52156862745098],
		midnightblue 		=> [0.184313725490196, 0.184313725490196, 0.309803921568627],
		mintcream 		=> [0.96078431372549, 1, 0.980392156862745],
		mistyrose 		=> [1,0.894117647058824,0.882352941176471],
		mistyrose1 		=> [1, 0.894117647058824, 0.882352941176471],
		mistyrose2 		=> [0.933333333333333, 0.835294117647059, 0.823529411764706],
		mistyrose3 		=> [0.803921568627451, 0.717647058823529, 0.709803921568627],
		mistyrose4 		=> [0.545098039215686, 0.490196078431373, 0.482352941176471],
		moccasin 		=> [1,0.894117647058824,0.709803921568627],
		navajowhite 		=> [1, 0.870588235294118, 0.67843137254902],
		navajowhite1 		=> [1, 0.870588235294118, 0.67843137254902],
		navajowhite2 		=> [0.933333333333333, 0.811764705882353, 0.631372549019608],
		navajowhite3 		=> [0.803921568627451, 0.701960784313725, 0.545098039215686],
		navajowhite4 		=> [0.545098039215686, 0.474509803921569, 0.368627450980392],
		navy 			=> [0, 0, 0.501960784313725],
		navyblue 		=> [0, 0, 0.501960784313725],
		neonblue 		=> [0.301960784313725, 0.301960784313725, 1],
		neonpink 		=> [1, 0.431372549019608, 0.780392156862745],
		none 			=> [0,0,0],
		oldlace 		=> [0.992156862745098,0.96078431372549,0.901960784313726],
		olive 			=> [0.501960784313725,0.501960784313725,0],
		olivedrab 		=> [0.419607843137255, 0.556862745098039, 0.137254901960784],
		olivedrab1 		=> [0.752941176470588, 1, 0.243137254901961],
		olivedrab2 		=> [0.701960784313725, 0.933333333333333, 0.227450980392157],
		olivedrab3 		=> [0.603921568627451, 0.803921568627451, 0.196078431372549],
		olivedrab4 		=> [0.411764705882353, 0.545098039215686, 0.133333333333333],
		orange 			=> [1, 0.647058823529412, 0],
		orange1 		=> [1, 0.647058823529412, 0],
		orange2 		=> [0.933333333333333, 0.603921568627451, 0],
		orange3 		=> [0.803921568627451, 0.52156862745098, 0],
		orange4 		=> [0.545098039215686, 0.352941176470588, 0],
		orangered 		=> [1, 0.270588235294118, 0],
		orangered1 		=> [1, 0.270588235294118, 0],
		orangered2 		=> [0.933333333333333, 0.250980392156863, 0],
		orangered3 		=> [0.803921568627451, 0.215686274509804, 0],
		orangered4 		=> [0.545098039215686, 0.145098039215686, 0],
		orchid 			=> [0.854901960784314, 0.43921568627451, 0.83921568627451],
		orchid1 		=> [1, 0.513725490196078, 0.980392156862745],
		orchid2 		=> [0.933333333333333, 0.47843137254902, 0.913725490196078],
		orchid3 		=> [0.803921568627451, 0.411764705882353, 0.788235294117647],
		orchid4 		=> [0.545098039215686, 0.27843137254902, 0.537254901960784],
		palegoldenrod 		=> [0.933333333333333, 0.909803921568627, 0.666666666666667],
		palegreen 		=> [0.596078431372549,0.984313725490196,0.596078431372549],
		palegreen1 		=> [0.603921568627451, 1, 0.603921568627451],
		palegreen2 		=> [0.564705882352941, 0.933333333333333, 0.564705882352941],
		palegreen3 		=> [0.486274509803922, 0.803921568627451, 0.486274509803922],
		palegreen4 		=> [0.329411764705882, 0.545098039215686, 0.329411764705882],
		paleturquoise 		=> [0.686274509803922,0.933333333333333,0.933333333333333],
		paleturquoise1 		=> [0.733333333333333, 1, 1],
		paleturquoise2 		=> [0.682352941176471, 0.933333333333333, 0.933333333333333],
		paleturquoise3 		=> [0.588235294117647, 0.803921568627451, 0.803921568627451],
		paleturquoise4 		=> [0.4, 0.545098039215686, 0.545098039215686],
		palevioletred 		=> [0.858823529411765,0.43921568627451,0.576470588235294],
		palevioletred1 		=> [1, 0.509803921568627, 0.670588235294118],
		palevioletred2 		=> [0.933333333333333, 0.474509803921569, 0.623529411764706],
		palevioletred3 		=> [0.803921568627451, 0.407843137254902, 0.537254901960784],
		palevioletred4 		=> [0.545098039215686, 0.27843137254902, 0.364705882352941],
		papayawhip 		=> [1, 0.937254901960784, 0.835294117647059],
		peachpuff 		=> [1,0.854901960784314,0.725490196078431],
		peachpuff1 		=> [1, 0.854901960784314, 0.725490196078431],
		peachpuff2 		=> [0.933333333333333, 0.796078431372549, 0.67843137254902],
		peachpuff3 		=> [0.803921568627451, 0.686274509803922, 0.584313725490196],
		peachpuff4 		=> [0.545098039215686, 0.466666666666667, 0.396078431372549],
		peru 			=> [0.803921568627451, 0.52156862745098, 0.247058823529412],
		pink 			=> [1,0.752941176470588,0.796078431372549],
		pink1 			=> [1, 0.709803921568627, 0.772549019607843],
		pink2 			=> [0.933333333333333, 0.662745098039216, 0.72156862745098],
		pink3 			=> [0.803921568627451, 0.568627450980392, 0.619607843137255],
		pink4 			=> [0.545098039215686, 0.388235294117647, 0.423529411764706],
		plum 			=> [0.866666666666667,0.627450980392157,0.866666666666667],
		plum1 			=> [1, 0.733333333333333, 1],
		plum2 			=> [0.933333333333333, 0.682352941176471, 0.933333333333333],
		plum3 			=> [0.803921568627451, 0.588235294117647, 0.803921568627451],
		plum4 			=> [0.545098039215686, 0.4, 0.545098039215686],
		powderblue 		=> [0.690196078431373, 0.87843137254902, 0.901960784313726],
		purple 			=> [0.501960784313725,0,0.501960784313725],
		purple1 		=> [0.607843137254902, 0.188235294117647, 1],
		purple2 		=> [0.568627450980392, 0.172549019607843, 0.933333333333333],
		purple3 		=> [0.490196078431373, 0.149019607843137, 0.803921568627451],
		purple4 		=> [0.333333333333333, 0.101960784313725, 0.545098039215686],
		quartz 			=> [0.850980392156863, 0.850980392156863, 0.952941176470588],
		red 			=> [1, 0, 0],
		red1 			=> [1, 0, 0],
		red2 			=> [0.933333333333333, 0, 0],
		red3 			=> [0.803921568627451, 0, 0],
		red4 			=> [0.545098039215686, 0, 0],
		richblue 		=> [0.349019607843137, 0.349019607843137, 0.670588235294118],
		rosybrown 		=> [0.737254901960784, 0.56078431372549, 0.56078431372549],
		rosybrown 		=> [0.737254901960784,0.56078431372549,0.56078431372549],
		rosybrown1 		=> [1, 0.756862745098039, 0.756862745098039],
		rosybrown2 		=> [0.933333333333333, 0.705882352941177, 0.705882352941177],
		rosybrown3 		=> [0.803921568627451, 0.607843137254902, 0.607843137254902],
		rosybrown4 		=> [0.545098039215686, 0.411764705882353, 0.411764705882353],
		royalblue 		=> [0.254901960784314,0.411764705882353,0.882352941176471],
		royalblue1 		=> [0.282352941176471, 0.462745098039216, 1],
		royalblue2 		=> [0.262745098039216, 0.431372549019608, 0.933333333333333],
		royalblue3 		=> [0.227450980392157, 0.372549019607843, 0.803921568627451],
		royalblue4 		=> [0.152941176470588, 0.250980392156863, 0.545098039215686],
		saddlebrown 		=> [0.545098039215686, 0.270588235294118, 0.0745098039215686],
		salmon 			=> [0.980392156862745,0.501960784313725,0.447058823529412],
		salmon1 		=> [1, 0.549019607843137, 0.411764705882353],
		salmon2 		=> [0.933333333333333, 0.509803921568627, 0.384313725490196],
		salmon3 		=> [0.803921568627451, 0.43921568627451, 0.329411764705882],
		salmon4 		=> [0.545098039215686, 0.298039215686275, 0.223529411764706],
		sandybrown 		=> [0.956862745098039, 0.643137254901961, 0.376470588235294],
		seagreen 		=> [0.180392156862745, 0.545098039215686, 0.341176470588235],
		seagreen1 		=> [0.329411764705882, 1, 0.623529411764706],
		seagreen2 		=> [0.305882352941176, 0.933333333333333, 0.580392156862745],
		seagreen3 		=> [0.262745098039216, 0.803921568627451, 0.501960784313725],
		seagreen4 		=> [0.180392156862745, 0.545098039215686, 0.341176470588235],
		seashell 		=> [1, 0.96078431372549, 0.933333333333333],
		seashell1 		=> [1, 0.96078431372549, 0.933333333333333],
		seashell2 		=> [0.933333333333333, 0.898039215686275, 0.870588235294118],
		seashell3 		=> [0.803921568627451, 0.772549019607843, 0.749019607843137],
		seashell4 		=> [0.545098039215686, 0.525490196078431, 0.509803921568627],
		sienna 			=> [0.627450980392157, 0.32156862745098, 0.176470588235294],
		sienna1 		=> [1, 0.509803921568627, 0.27843137254902],
		sienna2 		=> [0.933333333333333, 0.474509803921569, 0.258823529411765],
		sienna3 		=> [0.803921568627451, 0.407843137254902, 0.223529411764706],
		sienna4 		=> [0.545098039215686, 0.27843137254902, 0.149019607843137],
		silver 			=> [0.752941176470588,0.752941176470588,0.752941176470588],
		skyblue 		=> [0.529411764705882, 0.807843137254902, 0.92156862745098],
		skyblue1 		=> [0.529411764705882, 0.807843137254902, 1],
		skyblue2 		=> [0.494117647058824, 0.752941176470588, 0.933333333333333],
		skyblue3 		=> [0.423529411764706, 0.650980392156863, 0.803921568627451],
		skyblue4 		=> [0.290196078431373, 0.43921568627451, 0.545098039215686],
		slateblue 		=> [0.415686274509804, 0.352941176470588, 0.803921568627451],
		slateblue1 		=> [0.513725490196078, 0.435294117647059, 1],
		slateblue2 		=> [0.47843137254902, 0.403921568627451, 0.933333333333333],
		slateblue3 		=> [0.411764705882353, 0.349019607843137, 0.803921568627451],
		slateblue4 		=> [0.27843137254902, 0.235294117647059, 0.545098039215686],
		slategray 		=> [0.43921568627451, 0.501960784313725, 0.564705882352941],
		slategray1 		=> [0.776470588235294, 0.886274509803922, 1],
		slategray2 		=> [0.725490196078431, 0.827450980392157, 0.933333333333333],
		slategray3 		=> [0.623529411764706, 0.713725490196078, 0.803921568627451],
		slategray4 		=> [0.423529411764706, 0.482352941176471, 0.545098039215686],
		slategrey 		=> [0.43921568627451, 0.501960784313725, 0.564705882352941],
		snow 			=> [1, 0.980392156862745, 0.980392156862745],
		snow1 			=> [1, 0.980392156862745, 0.980392156862745],
		snow2			=> [0.933333333333333, 0.913725490196078, 0.913725490196078],
		snow3			=> [0.803921568627451, 0.788235294117647, 0.788235294117647],
		snow4			=> [0.545098039215686, 0.537254901960784, 0.537254901960784],
		springgreen		=> [0, 1, 0.498039215686275],
		springgreen1		=> [0, 1, 0.498039215686275],
		springgreen2		=> [0, 0.933333333333333, 0.462745098039216],
		springgreen3		=> [0, 0.803921568627451, 0.4],
		springgreen4		=> [0, 0.545098039215686, 0.270588235294118],
		steelblue		=> [0.274509803921569, 0.509803921568627, 0.705882352941177],
		steelblue1		=> [0.388235294117647, 0.72156862745098, 1],
		steelblue2		=> [0.36078431372549, 0.674509803921569, 0.933333333333333],
		steelblue3		=> [0.309803921568627, 0.580392156862745, 0.803921568627451],
		steelblue4		=> [0.211764705882353, 0.392156862745098, 0.545098039215686],
		summersky		=> [0.219607843137255, 0.690196078431373, 0.870588235294118],
		tan			=> [0.823529411764706, 0.705882352941177, 0.549019607843137],
		tan1			=> [1, 0.647058823529412, 0.309803921568627],
		tan2			=> [0.933333333333333, 0.603921568627451, 0.286274509803922],
		tan3			=> [0.803921568627451, 0.52156862745098, 0.247058823529412],
		tan4			=> [0.545098039215686, 0.352941176470588, 0.168627450980392],
		teal			=> [0,0.501960784313725,0.501960784313725],
		thistle			=> [0.847058823529412, 0.749019607843137, 0.847058823529412],
		thistle1		=> [1, 0.882352941176471, 1],
		thistle2		=> [0.933333333333333, 0.823529411764706, 0.933333333333333],
		thistle3		=> [0.803921568627451, 0.709803921568627, 0.803921568627451],
		thistle4		=> [0.545098039215686, 0.482352941176471, 0.545098039215686],
		tomato			=> [1, 0.388235294117647, 0.27843137254902],
		tomato1			=> [1, 0.388235294117647, 0.27843137254902],
		tomato2			=> [0.933333333333333, 0.36078431372549, 0.258823529411765],
		tomato3			=> [0.803921568627451, 0.309803921568627, 0.223529411764706],
		tomato4			=> [0.545098039215686, 0.211764705882353, 0.149019607843137],
		turquoise		=> [0.250980392156863,0.87843137254902,0.815686274509804],
		turquoise1		=> [0, 0.96078431372549, 1],
		turquoise2		=> [0, 0.898039215686275, 0.933333333333333],
		turquoise3		=> [0, 0.772549019607843, 0.803921568627451],
		turquoise4		=> [0, 0.525490196078431, 0.545098039215686],
		violet			=> [0.933333333333333, 0.509803921568627, 0.933333333333333],
		violetred		=> [0.815686274509804, 0.125490196078431, 0.564705882352941],
		violetred1		=> [1, 0.243137254901961, 0.588235294117647],
		violetred2		=> [0.933333333333333, 0.227450980392157, 0.549019607843137],
		violetred3		=> [0.803921568627451, 0.196078431372549, 0.470588235294118],
		violetred4		=> [0.545098039215686, 0.133333333333333, 0.32156862745098],
		wheat			=> [0.96078431372549,0.870588235294118,0.701960784313725],
		wheat1			=> [1, 0.905882352941176, 0.729411764705882],
		wheat2			=> [0.933333333333333, 0.847058823529412, 0.682352941176471],
		wheat3			=> [0.803921568627451, 0.729411764705882, 0.588235294117647],
		wheat4			=> [0.545098039215686, 0.494117647058824, 0.4],
		white			=> [1, 1, 1],
		whitesmoke		=> [0.96078431372549, 0.96078431372549, 0.96078431372549],
		yellow			=> [1, 1, 0],
		yellow1			=> [1, 1, 0],
		yellow2			=> [0.933333333333333, 0.933333333333333, 0],
		yellow3			=> [0.803921568627451, 0.803921568627451, 0],
		yellow4			=> [0.545098039215686, 0.545098039215686, 0],
		yellowgreen		=> [0.6, 0.8, 0.196078431372549],
        );

}

sub mMin {
	my $n=HUGE_VAL;
	map { $n=($n>$_) ? $_ : $n } @_;
	return($n);	
}

sub mMax {
	my $n=-(HUGE_VAL);
	map { $n=($n<$_) ? $_ : $n } @_;
	return($n);	
}

sub cRGB {
	my @cmy=(map { 1-$_ } @_);
	my $k=mMin(@cmy);
	return((map { $_-$k } @cmy),$k);
}

sub cRGB8 {
	return cRGB(map { $_/255 } @_);
}

sub RGBasCMYK {
	my @rgb=@_;
	my @cmy=(map { 1-$_ } @rgb);
	my $k=mMin(@cmy);
	return((map { $_-$k } @cmy),$k);
}

sub HSVtoRGB ($$$) {
	my ($h,$s,$v)=@_;
	my ($r,$g,$b,$i,$f,$p,$q,$t);

        if( $s == 0 ) {
                ## achromatic (grey)
                return ($v,$v,$v);
        }

        $h %= 360;                      
        $h /= 60;                       ## sector 0 to 5
        $i = POSIX::floor( $h );
        $f = $h - $i;                   ## factorial part of h
        $p = $v * ( 1 - $s );
        $q = $v * ( 1 - $s * $f );
        $t = $v * ( 1 - $s * ( 1 - $f ) );

	if($i<1) {
		$r = $v;
                $g = $t;
                $b = $p;
	} elsif($i<2){
		$r = $q;
                $g = $v;
                $b = $p;
	} elsif($i<3){
		$r = $p;
                $g = $v;
                $b = $t;
	} elsif($i<4){
		$r = $p;
                $g = $q;
                $b = $v;
	} elsif($i<5){
		$r = $t;
                $g = $p;
                $b = $v;
	} else {
		$r = $v;
                $g = $p;
                $b = $q;
	}
	return ($r,$g,$b);
}

sub namecolor {
	my $name=lc(shift @_);
	$name=~s/[^\#!%a-z0-9]//cg;
	my $col;
	if($name=~/^#/) {
		my ($r,$g,$b,$h);
		if(length($name)<5) {		# zb. #fa4,          #cf0
			$r=hex(substr($name,1,1))/0xf;
			$g=hex(substr($name,2,1))/0xf;
			$b=hex(substr($name,3,1))/0xf;
		} elsif(length($name)<8) {	# zb. #ffaa44,       #ccff00
			$r=hex(substr($name,1,2))/0xff;
			$g=hex(substr($name,3,2))/0xff;
			$b=hex(substr($name,5,2))/0xff;
		} elsif(length($name)<11) {	# zb. #fffaaa444,    #cccfff000
			$r=hex(substr($name,1,3))/0xfff;
			$g=hex(substr($name,4,3))/0xfff;
			$b=hex(substr($name,7,3))/0xfff;
		} else {			# zb. #ffffaaaa4444, #ccccffff0000
			$r=hex(substr($name,1,4))/0xffff;
			$g=hex(substr($name,5,4))/0xffff;
			$b=hex(substr($name,9,4))/0xffff;
		}
		$col=[$r,$g,$b];
	} elsif($name=~/^%/) {
		my ($r,$g,$b,$c,$y,$m,$k);
		if(length($name)<6) {		# zb. %cmyk
			$c=hex(substr($name,1,1))/0xf;
			$m=hex(substr($name,2,1))/0xf;
			$y=hex(substr($name,3,1))/0xf;
			$k=hex(substr($name,4,1))/0xf;
		} elsif(length($name)<10) {	# zb. %ccmmyykk
			$c=hex(substr($name,1,2))/0xff;
			$m=hex(substr($name,3,2))/0xff;
			$y=hex(substr($name,5,2))/0xff;
			$k=hex(substr($name,7,2))/0xff;
		} elsif(length($name)<14) {	# zb. %cccmmmyyykkk
			$c=hex(substr($name,1,3))/0xfff;
			$m=hex(substr($name,4,3))/0xfff;
			$y=hex(substr($name,7,3))/0xfff;
			$k=hex(substr($name,10,3))/0xfff;
		} else {			# zb. %ccccmmmmyyyykkkk
			$c=hex(substr($name,1,4))/0xffff;
			$m=hex(substr($name,5,4))/0xffff;
			$y=hex(substr($name,9,4))/0xffff;
			$k=hex(substr($name,13,4))/0xffff;
		}
		$r=1-$c-$k;
		$g=1-$m-$k;
		$b=1-$y-$k;
		$col=[$r,$g,$b];
	} elsif($name=~/^!/) {
		my ($r,$g,$b,$h,$s,$v);
		if(length($name)<5) {		
			$h=360*hex(substr($name,1,1))/0xf;
			$s=hex(substr($name,2,1))/0xf;
			$v=hex(substr($name,3,1))/0xf;
		} elsif(length($name)<8) {
			$h=360*hex(substr($name,1,2))/0xff;
			$s=hex(substr($name,3,2))/0xff;
			$v=hex(substr($name,5,2))/0xff;
		} elsif(length($name)<11) {	
			$h=360*hex(substr($name,1,3))/0xfff;
			$s=hex(substr($name,4,3))/0xfff;
			$v=hex(substr($name,7,3))/0xfff;
		} else {		
			$h=360*hex(substr($name,1,4))/0xffff;
			$s=hex(substr($name,5,4))/0xffff;
			$v=hex(substr($name,9,4))/0xffff;
		}
		($r,$g,$b)=HSVtoRGB($h,$s,$v);
		$col=[$r,$g,$b];
	} else {
		$col = $colors{$name} || [0,0,0];
	}
	return(@{$col});
}

sub pdfkey {
	my $ddata=join('',@_);
	my $mdkey='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789gT';
	my $xdata="0" x 8;
	my $off=0;
	foreach my $set (0..(length($ddata)<<1)) {
		$off+=vec($ddata,$set,4);
		$off+=vec($xdata,($set & 7),8);
		vec($xdata,($set & 7),8)=vec($mdkey,($off & 0x3f),8);
	}
	return($xdata);
}

sub digestx {
	my $len=shift @_;
	my $mask=$len-1;
	my $ddata=join('',@_);
	my $mdkey='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789gT';
	my $xdata="0" x $len;
	my $off=0;
	my $set;
	foreach $set (0..(length($ddata)<<1)) {
		$off+=vec($ddata,$set,4);
		$off+=vec($xdata,($set & $mask),8);
		vec($xdata,($set & ($mask<<1 |1)),4)=vec($mdkey,($off & 0x7f),4);
	}
	
#	foreach $set (0..$mask) {
#		vec($xdata,$set,8)=(vec($xdata,$set,8) & 0x7f) | 0x40;
#	}

#	$off=0;
#	foreach $set (0..$mask) {
#		$off+=vec($xdata,$set,8);
#		vec($xdata,$set,8)=vec($mdkey,($off & 0x3f),8);
#	}

	return($xdata);
}

sub digest {
	return(digestx(32,@_));
}

sub digest16 {
	return(digestx(16,@_));
}

sub digest32 {
	return(digestx(32,@_));
}

sub xlog10 {
	my $n = shift;
	if($n) {
    		return log(abs($n))/log(10);
	} else { return 0; }
}

sub float {
	my $f=shift @_;
	my $mxd=shift @_||4;
	$f=0 if(abs($f)<0.0000000000000001);
	my $ad=floor(xlog10($f)-$mxd);
	if(abs($f-int($f)) < (10**(-$mxd))) {
		# just in case we have an integer
		return sprintf('%i',$f);
	} elsif($ad>0){
		return sprintf('%f',$f);
	} else {
		return sprintf('%.'.abs($ad).'f',$f);
	}
}
sub floats { return map { float($_); } @_; }
sub floats5 { return map { float($_,5); } @_; }


sub intg {
	my $f=shift @_;
	return sprintf('%i',$f);
}
sub intgs { return map { intg($_); } @_; }

my @cp1252 = (1 .. 127,
       0x20AC, 0x0081, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021,
       0x02C6, 0x2030, 0x0160, 0x2039, 0x0152, 0x008D, 0x017D, 0x008F,
       0x0090, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
       0x02DC, 0x2122, 0x0161, 0x203A, 0x0153, 0x009D, 0x017E, 0x0178,
       0xA0 .. 0xFF);

%winfonts=(
	'arialblack' => {
		'-widths' => [ 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 333, 333, 500, 660, 666, 1000, 889, 277, 389, 389, 556, 660, 333, 333, 333, 277, 666, 666, 666, 666, 666, 666, 666, 666, 666, 666, 333, 333, 660, 660, 660, 610, 740, 777, 777, 777, 777, 722, 666, 833, 833, 389, 666, 833, 666, 943, 833, 833, 722, 833, 777, 722, 722, 833, 777, 1000, 777, 777, 722, 389, 277, 389, 660, 500, 333, 666, 666, 666, 666, 666, 389, 666, 666, 333, 333, 666, 333, 1000, 666, 666, 666, 666, 443, 610, 443, 666, 610, 943, 666, 610, 556, 389, 277, 389, 660, 750, 666, 750, 277, 666, 500, 1000, 666, 666, 333, 1000, 722, 333, 1000, 750, 722, 750, 750, 277, 277, 500, 500, 500, 500, 1000, 333, 950, 610, 333, 1000, 750, 556, 777, 333, 333, 666, 666, 660, 666, 277, 666, 333, 799, 399, 666, 660, 333, 799, 500, 399, 660, 399, 399, 333, 666, 850, 333, 333, 399, 399, 666, 1000, 1000, 1000, 610, 777, 777, 777, 777, 777, 777, 1000, 777, 722, 722, 722, 722, 389, 389, 389, 389, 777, 833, 833, 833, 833, 833, 833, 660, 833, 833, 833, 833, 833, 777, 722, 666, 666, 666, 666, 666, 666, 666, 1000, 666, 666, 666, 666, 666, 333, 333, 333, 333, 666, 666, 666, 666, 666, 666, 666, 660, 666, 666, 666, 666, 666, 610, 666, 610 ],
		'-descent' => -309,
		'-firstchar' => 1,
		'-fontname' => 'ArialBlack',
		'-capheight' => 715,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 1100,
		'-xheight' => 518,
		'-fontbbox' => [ -193, -306, 1687, 1083 ],
		'-type' => 'TrueType',
		'-lastchar' => 255
	},
	'arialbolditalic' => {
		'-widths' => [ 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 277, 333, 474, 556, 556, 889, 722, 237, 333, 333, 389, 583, 277, 333, 277, 277, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 583, 583, 583, 610, 975, 722, 722, 722, 722, 666, 610, 777, 722, 277, 556, 722, 610, 833, 722, 777, 666, 777, 722, 666, 610, 722, 666, 943, 666, 666, 610, 333, 277, 333, 583, 556, 333, 556, 610, 556, 610, 556, 333, 610, 610, 277, 277, 556, 277, 889, 610, 610, 610, 610, 389, 556, 333, 610, 556, 777, 556, 556, 500, 389, 279, 389, 583, 750, 556, 750, 277, 556, 500, 1000, 556, 556, 333, 1000, 666, 333, 1000, 750, 610, 750, 750, 277, 277, 500, 500, 350, 556, 1000, 333, 1000, 556, 333, 943, 750, 500, 666, 277, 333, 556, 556, 556, 556, 279, 556, 333, 736, 370, 556, 583, 333, 736, 552, 399, 548, 333, 333, 333, 576, 556, 277, 333, 333, 365, 556, 833, 833, 833, 610, 722, 722, 722, 722, 722, 722, 1000, 722, 666, 666, 666, 666, 277, 277, 277, 277, 722, 722, 777, 777, 777, 777, 777, 583, 777, 722, 722, 722, 722, 666, 666, 610, 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 277, 277, 277, 277, 610, 610, 610, 610, 610, 610, 610, 548, 610, 610, 610, 610, 610, 556, 610, 556 ],
		'-descent' => -211,
		'-firstchar' => 1,
		'-fontname' => 'ArialBoldItalic',
		'-capheight' => 715,
		'-italicangle' => -12,
		'-flags' => 104,
		'-ascent' => 905,
		'-xheight' => 518,
		'-type' => 'TrueType',
		'-fontbbox' => [ -559, -376, 1156, 1030 ],
		'-lastchar' => 255
	},
	'arialbold' => {
		'-widths' => [ 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 277, 333, 474, 556, 556, 889, 722, 237, 333, 333, 389, 583, 277, 333, 277, 277, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 333, 333, 583, 583, 583, 610, 975, 722, 722, 722, 722, 666, 610, 777, 722, 277, 556, 722, 610, 833, 722, 777, 666, 777, 722, 666, 610, 722, 666, 943, 666, 666, 610, 333, 277, 333, 583, 556, 333, 556, 610, 556, 610, 556, 333, 610, 610, 277, 277, 556, 277, 889, 610, 610, 610, 610, 389, 556, 333, 610, 556, 777, 556, 556, 500, 389, 279, 389, 583, 750, 556, 750, 277, 556, 500, 1000, 556, 556, 333, 1000, 666, 333, 1000, 750, 610, 750, 750, 277, 277, 500, 500, 350, 556, 1000, 333, 1000, 556, 333, 943, 750, 500, 666, 277, 333, 556, 556, 556, 556, 279, 556, 333, 736, 370, 556, 583, 333, 736, 552, 399, 548, 333, 333, 333, 576, 556, 277, 333, 333, 365, 556, 833, 833, 833, 610, 722, 722, 722, 722, 722, 722, 1000, 722, 666, 666, 666, 666, 277, 277, 277, 277, 722, 722, 777, 777, 777, 777, 777, 583, 777, 722, 722, 722, 722, 666, 666, 610, 556, 556, 556, 556, 556, 556, 889, 556, 556, 556, 556, 556, 277, 277, 277, 277, 610, 610, 610, 610, 610, 610, 610, 548, 610, 610, 610, 610, 610, 556, 610, 556 ],
		'-descent' => -211,
		'-firstchar' => 1,
		'-fontname' => 'ArialBold',
		'-capheight' => 715,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 905,
		'-xheight' => 518,
		'-type' => 'TrueType',
		'-fontbbox' => [ -627, -376, 2033, 1047 ],
		'-lastchar' => 255
	},
	'arialitalic' => {
		'-widths' => [ 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 277, 277, 354, 556, 556, 889, 666, 190, 333, 333, 389, 583, 277, 333, 277, 277, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 277, 277, 583, 583, 583, 556, 1015, 666, 666, 722, 722, 666, 610, 777, 722, 277, 500, 666, 556, 833, 722, 777, 666, 777, 722, 666, 610, 722, 666, 943, 666, 666, 610, 277, 277, 277, 469, 556, 333, 556, 556, 500, 556, 556, 277, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 277, 556, 500, 722, 500, 500, 500, 333, 259, 333, 583, 750, 556, 750, 222, 556, 333, 1000, 556, 556, 333, 1000, 666, 333, 1000, 750, 610, 750, 750, 222, 222, 333, 333, 350, 556, 1000, 333, 1000, 500, 333, 943, 750, 500, 666, 277, 333, 556, 556, 556, 556, 259, 556, 333, 736, 370, 556, 583, 333, 736, 552, 399, 548, 333, 333, 333, 576, 537, 277, 333, 333, 365, 556, 833, 833, 833, 610, 666, 666, 666, 666, 666, 666, 1000, 722, 666, 666, 666, 666, 277, 277, 277, 277, 722, 722, 777, 777, 777, 777, 777, 583, 777, 722, 722, 722, 722, 666, 666, 610, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 277, 277, 277, 277, 556, 556, 556, 556, 556, 556, 556, 548, 610, 556, 556, 556, 556, 500, 556, 500 ],
		'-descent' => -211,
		'-firstchar' => 1,
		'-fontname' => 'ArialItalic',
		'-capheight' => 715,
		'-italicangle' => -12,
		'-flags' => 104,
		'-ascent' => 905,
		'-xheight' => 518,
		'-type' => 'TrueType',
		'-fontbbox' => [ -517, -324, 1081, 1024 ],
		'-lastchar' => 255
	},
	'arial' => {
		'-widths' => [ 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 277, 277, 354, 556, 556, 889, 666, 190, 333, 333, 389, 583, 277, 333, 277, 277, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 277, 277, 583, 583, 583, 556, 1015, 666, 666, 722, 722, 666, 610, 777, 722, 277, 500, 666, 556, 833, 722, 777, 666, 777, 722, 666, 610, 722, 666, 943, 666, 666, 610, 277, 277, 277, 469, 556, 333, 556, 556, 500, 556, 556, 277, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 277, 556, 500, 722, 500, 500, 500, 333, 259, 333, 583, 750, 556, 750, 222, 556, 333, 1000, 556, 556, 333, 1000, 666, 333, 1000, 750, 610, 750, 750, 222, 222, 333, 333, 350, 556, 1000, 333, 1000, 500, 333, 943, 750, 500, 666, 277, 333, 556, 556, 556, 556, 259, 556, 333, 736, 370, 556, 583, 333, 736, 552, 399, 548, 333, 333, 333, 576, 537, 277, 333, 333, 365, 556, 833, 833, 833, 610, 666, 666, 666, 666, 666, 666, 1000, 722, 666, 666, 666, 666, 277, 277, 277, 277, 722, 722, 777, 777, 777, 777, 777, 583, 777, 722, 722, 722, 722, 666, 666, 610, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 277, 277, 277, 277, 556, 556, 556, 556, 556, 556, 556, 548, 610, 556, 556, 556, 556, 500, 556, 500 ],
		'-descent' => -211,
		'-firstchar' => 1,
		'-fontname' => 'Arial',
		'-capheight' => 715,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 905,
		'-xheight' => 518,
		'-type' => 'TrueType',
		'-fontbbox' => [ -664, -324, 2028, 1037 ],
		'-lastchar' => 255
	},
	'comicsansmsbold' => {
		'-widths' => [ 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 433, 237, 437, 842, 693, 820, 654, 433, 366, 366, 529, 610, 433, 610, 433, 511, 610, 610, 610, 610, 610, 610, 610, 610, 610, 610, 433, 433, 610, 610, 610, 565, 931, 731, 630, 618, 721, 624, 606, 679, 768, 546, 665, 610, 550, 882, 812, 798, 532, 876, 640, 693, 695, 736, 674, 1039, 723, 635, 693, 376, 549, 376, 610, 626, 556, 555, 593, 513, 587, 559, 508, 530, 577, 280, 403, 540, 273, 776, 523, 525, 534, 520, 480, 486, 471, 520, 486, 684, 590, 552, 538, 366, 421, 366, 610, 500, 618, 500, 433, 588, 429, 675, 610, 596, 556, 1241, 693, 610, 1193, 500, 693, 500, 500, 226, 226, 433, 433, 610, 441, 882, 556, 882, 507, 610, 896, 500, 538, 635, 476, 237, 610, 793, 610, 610, 421, 634, 556, 795, 610, 638, 610, 610, 795, 626, 610, 610, 610, 610, 556, 610, 760, 610, 556, 610, 610, 638, 610, 610, 610, 565, 731, 731, 731, 731, 731, 731, 1086, 618, 624, 624, 624, 624, 546, 546, 546, 546, 721, 812, 798, 798, 798, 798, 798, 610, 798, 736, 736, 736, 736, 635, 520, 533, 555, 555, 555, 555, 555, 555, 911, 513, 559, 559, 559, 559, 280, 280, 280, 280, 508, 523, 525, 525, 525, 525, 525, 610, 533, 520, 520, 520, 520, 552, 534, 552 ],
		'-descent' => -291,
		'-firstchar' => 1,
		'-fontname' => 'ComicSansMSBold',
		'-capheight' => 758,
		'-italicangle' => '0',
		'-flags' => 34,
		'-ascent' => 1102,
		'-xheight' => 539,
		'-type' => 'TrueType',
		'-fontbbox' => [ -111, -291, 1229, 1102 ],
		'-lastchar' => 255
	},
	'comicsansms' => {
		'-widths' => [ 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 298, 237, 424, 842, 693, 820, 654, 388, 366, 366, 529, 480, 276, 416, 249, 511, 610, 450, 610, 610, 610, 610, 610, 610, 610, 610, 298, 298, 381, 510, 381, 523, 931, 731, 630, 602, 721, 624, 606, 679, 768, 546, 665, 610, 550, 882, 796, 798, 520, 876, 628, 693, 679, 736, 649, 1039, 723, 635, 693, 376, 549, 376, 581, 626, 556, 511, 593, 513, 587, 547, 508, 530, 577, 280, 403, 540, 273, 776, 523, 525, 534, 520, 480, 486, 471, 520, 486, 684, 590, 520, 538, 366, 421, 366, 597, 500, 610, 500, 298, 426, 411, 675, 596, 596, 556, 1241, 693, 381, 1193, 500, 693, 500, 500, 180, 180, 393, 393, 387, 441, 882, 556, 882, 403, 381, 896, 500, 538, 635, 298, 237, 623, 793, 611, 635, 404, 634, 556, 795, 526, 577, 480, 416, 795, 626, 409, 480, 650, 650, 556, 520, 693, 249, 556, 650, 449, 577, 650, 650, 650, 523, 731, 731, 731, 731, 731, 731, 1086, 602, 624, 624, 624, 624, 546, 546, 546, 546, 721, 796, 798, 798, 798, 798, 798, 480, 798, 736, 736, 736, 736, 635, 520, 443, 511, 511, 511, 511, 511, 511, 911, 513, 547, 547, 547, 547, 280, 280, 280, 280, 508, 523, 525, 525, 525, 525, 525, 480, 525, 520, 520, 520, 520, 520, 534, 431 ],
		'-descent' => -291,
		'-firstchar' => 1,
		'-fontname' => 'ComicSansMS',
		'-capheight' => 758,
		'-italicangle' => '0',
		'-flags' => 34,
		'-ascent' => 1102,
		'-xheight' => 539,
		'-type' => 'TrueType',
		'-fontbbox' => [ -92, -312, 1186, 1102 ],
		'-lastchar' => 255
	},
	'couriernewbolditalic' => {
		'-widths' => [ 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600 ],
		'-descent' => -300,
		'-firstchar' => 1,
		'-fontname' => 'CourierNewBoldItalic',
		'-capheight' => 592,
		'-italicangle' => -12,
		'-flags' => 107,
		'-ascent' => 832,
		'-xheight' => 443,
		'-type' => 'TrueType',
		'-fontbbox' => [ -102, -376, 836, 1003 ],
		'-lastchar' => 255
	},
	'couriernewbold' => {
		'-widths' => [ 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600 ],
		'-descent' => -300,
		'-firstchar' => 1,
		'-fontname' => 'CourierNewBold',
		'-capheight' => 592,
		'-italicangle' => '0',
		'-flags' => 43,
		'-ascent' => 832,
		'-xheight' => 443,
		'-type' => 'TrueType',
		'-fontbbox' => [ -46, -710, 701, 1221 ],
		'-lastchar' => 255
	},
	'couriernewitalic' => {
		'-widths' => [ 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600 ],
		'-descent' => -300,
		'-firstchar' => 1,
		'-fontname' => 'CourierNewItalic',
		'-capheight' => 571,
		'-italicangle' => -12,
		'-flags' => 107,
		'-ascent' => 832,
		'-xheight' => 422,
		'-type' => 'TrueType',
		'-fontbbox' => [ -67, -273, 800, 1000 ],
		'-lastchar' => 255
	},
	'couriernew' => {
		'-widths' => [ 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600, 600 ],
		'-descent' => -300,
		'-firstchar' => 1,
		'-fontname' => 'CourierNew',
		'-capheight' => 571,
		'-italicangle' => '0',
		'-flags' => 43,
		'-ascent' => 832,
		'-xheight' => 422,
		'-type' => 'TrueType',
		'-fontbbox' => [ -21, -679, 637, 1020 ],
		'-lastchar' => 255
	},
	'tahomabold' => {
		'-widths' => [ 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 292, 342, 489, 818, 636, 1198, 781, 275, 454, 454, 636, 818, 312, 431, 312, 577, 636, 636, 636, 636, 636, 636, 636, 636, 636, 636, 363, 363, 818, 818, 818, 566, 919, 684, 686, 667, 757, 615, 581, 745, 764, 483, 500, 696, 572, 893, 770, 770, 657, 770, 726, 633, 612, 738, 674, 1027, 684, 670, 622, 454, 577, 454, 818, 636, 545, 598, 631, 527, 629, 593, 382, 629, 640, 301, 362, 602, 301, 953, 640, 617, 629, 629, 433, 514, 415, 640, 578, 889, 604, 575, 525, 623, 636, 623, 818, 1000, 636, 1000, 275, 636, 489, 1000, 636, 636, 545, 1675, 633, 424, 1036, 1000, 622, 1000, 1000, 275, 275, 489, 489, 636, 636, 909, 545, 860, 514, 424, 985, 1000, 525, 670, 292, 342, 636, 636, 636, 636, 636, 636, 545, 928, 507, 703, 818, 431, 928, 636, 519, 818, 539, 539, 545, 650, 636, 363, 545, 539, 539, 703, 1127, 1127, 1127, 566, 684, 684, 684, 684, 684, 684, 988, 667, 615, 615, 615, 615, 483, 483, 483, 483, 773, 770, 770, 770, 770, 770, 770, 818, 770, 738, 738, 738, 738, 670, 659, 645, 598, 598, 598, 598, 598, 598, 937, 527, 593, 593, 593, 593, 301, 301, 301, 301, 619, 640, 617, 617, 617, 617, 617, 818, 617, 640, 640, 640, 640, 575, 629, 575 ],
		'-descent' => -206,
		'-firstchar' => 1,
		'-fontname' => 'TahomaBold',
		'-capheight' => 727,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 1000,
		'-xheight' => 548,
		'-type' => 'TrueType',
		'-fontbbox' => [ -670, -207, 1625, 1065 ],
		'-lastchar' => 255
	},
	'tahoma' => {
		'-widths' => [ 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 312, 332, 401, 727, 545, 976, 673, 210, 382, 382, 545, 727, 302, 363, 302, 382, 545, 545, 545, 545, 545, 545, 545, 545, 545, 545, 353, 353, 727, 727, 727, 473, 909, 599, 589, 600, 678, 561, 521, 667, 675, 373, 416, 587, 497, 770, 667, 707, 551, 707, 620, 557, 583, 655, 596, 901, 580, 576, 559, 382, 382, 382, 727, 545, 545, 524, 552, 461, 552, 526, 318, 552, 557, 228, 281, 498, 228, 839, 557, 542, 552, 552, 360, 446, 334, 557, 498, 742, 495, 498, 444, 480, 382, 480, 727, 1000, 545, 1000, 210, 545, 397, 817, 545, 545, 545, 1390, 557, 382, 976, 1000, 559, 1000, 1000, 210, 210, 401, 401, 454, 545, 909, 545, 875, 446, 382, 908, 1000, 444, 576, 312, 332, 545, 545, 545, 545, 382, 545, 545, 928, 493, 573, 727, 363, 928, 545, 470, 727, 493, 493, 545, 567, 545, 353, 545, 493, 493, 573, 1000, 1000, 1000, 473, 599, 599, 599, 599, 599, 599, 913, 600, 561, 561, 561, 561, 373, 373, 373, 373, 698, 667, 707, 707, 707, 707, 707, 727, 707, 655, 655, 655, 655, 576, 565, 548, 524, 524, 524, 524, 524, 524, 879, 461, 526, 526, 526, 526, 228, 228, 228, 228, 545, 557, 542, 542, 542, 542, 542, 727, 542, 557, 557, 557, 557, 498, 552, 498 ],
		'-descent' => -206,
		'-firstchar' => 1,
		'-fontname' => 'Tahoma',
		'-capheight' => 727,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 1000,
		'-xheight' => 545,
		'-type' => 'TrueType',
		'-fontbbox' => [ -609, -207, 1338, 1034 ],
		'-lastchar' => 255
	},
	'timesnewromanbolditalic' => {
		'-widths' => [ 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 250, 389, 555, 500, 500, 833, 777, 277, 333, 333, 500, 569, 250, 333, 250, 277, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 333, 333, 569, 569, 569, 500, 832, 666, 666, 666, 722, 666, 666, 722, 777, 389, 500, 666, 610, 889, 722, 722, 610, 722, 666, 556, 610, 722, 666, 889, 666, 610, 610, 333, 277, 333, 569, 500, 333, 500, 500, 443, 500, 443, 333, 500, 556, 277, 277, 500, 277, 777, 556, 500, 500, 500, 389, 389, 277, 556, 443, 666, 500, 443, 389, 348, 220, 348, 569, 777, 500, 777, 333, 500, 500, 1000, 500, 500, 333, 1000, 556, 333, 943, 777, 610, 777, 777, 333, 333, 500, 500, 350, 500, 1000, 333, 1000, 389, 333, 722, 777, 389, 610, 250, 389, 500, 500, 500, 500, 220, 500, 333, 747, 266, 500, 605, 333, 747, 500, 399, 548, 299, 299, 333, 576, 500, 250, 333, 299, 299, 500, 750, 750, 750, 500, 666, 666, 666, 666, 666, 666, 943, 666, 666, 666, 666, 666, 389, 389, 389, 389, 722, 722, 722, 722, 722, 722, 722, 569, 722, 722, 722, 722, 722, 610, 610, 500, 500, 500, 500, 500, 500, 500, 722, 443, 443, 443, 443, 443, 277, 277, 277, 277, 500, 556, 500, 500, 500, 500, 500, 548, 500, 556, 556, 556, 556, 443, 500, 443 ],
		'-descent' => -216,
		'-firstchar' => 1,
		'-fontname' => 'TimesNewRomanBoldItalic',
		'-capheight' => 662,
		'-italicangle' => -16,
		'-flags' => 106,
		'-ascent' => 891,
		'-xheight' => 452,
		'-type' => 'TrueType',
		'-fontbbox' => [ -547, -306, 1206, 1032 ],
		'-lastchar' => 255
	},
	'timesnewromanbold' => {
		'-widths' => [ 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 250, 333, 555, 500, 500, 1000, 833, 277, 333, 333, 500, 569, 250, 333, 250, 277, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 333, 333, 569, 569, 569, 500, 930, 722, 666, 722, 722, 666, 610, 777, 777, 389, 500, 777, 666, 943, 722, 777, 610, 777, 722, 556, 666, 722, 722, 1000, 722, 722, 666, 333, 277, 333, 581, 500, 333, 500, 556, 443, 556, 443, 333, 500, 556, 277, 333, 556, 277, 833, 556, 500, 556, 556, 443, 389, 333, 556, 500, 722, 500, 500, 443, 394, 220, 394, 520, 777, 500, 777, 333, 500, 500, 1000, 500, 500, 333, 1000, 556, 333, 1000, 777, 666, 777, 777, 333, 333, 500, 500, 350, 500, 1000, 333, 1000, 389, 333, 722, 777, 443, 722, 250, 333, 500, 500, 500, 500, 220, 500, 333, 747, 299, 500, 569, 333, 747, 500, 399, 548, 299, 299, 333, 576, 540, 250, 333, 299, 330, 500, 750, 750, 750, 500, 722, 722, 722, 722, 722, 722, 1000, 722, 666, 666, 666, 666, 389, 389, 389, 389, 722, 722, 777, 777, 777, 777, 777, 569, 777, 722, 722, 722, 722, 722, 610, 556, 500, 500, 500, 500, 500, 500, 722, 443, 443, 443, 443, 443, 277, 277, 277, 277, 500, 556, 500, 500, 500, 500, 500, 548, 500, 556, 556, 556, 556, 500, 556, 500 ],
		'-descent' => -216,
		'-firstchar' => 1,
		'-fontname' => 'TimesNewRomanBold',
		'-capheight' => 662,
		'-italicangle' => '0',
		'-flags' => 42,
		'-ascent' => 891,
		'-xheight' => 456,
		'-type' => 'TrueType',
		'-fontbbox' => [ -558, -306, 2033, 1025 ],
		'-lastchar' => 255
	},
	'timesnewromanitalic' => {
		'-widths' => [ 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 250, 333, 419, 500, 500, 833, 777, 213, 333, 333, 500, 674, 250, 333, 250, 277, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 333, 333, 674, 674, 674, 500, 919, 610, 610, 666, 722, 610, 610, 722, 722, 333, 443, 666, 556, 833, 666, 722, 610, 722, 610, 500, 556, 722, 610, 833, 610, 556, 556, 389, 277, 389, 421, 500, 333, 500, 500, 443, 500, 443, 277, 500, 500, 277, 277, 443, 277, 722, 500, 500, 500, 500, 389, 389, 277, 500, 443, 666, 443, 443, 389, 399, 274, 399, 541, 777, 500, 777, 333, 500, 556, 889, 500, 500, 333, 1000, 500, 333, 943, 777, 556, 777, 777, 333, 333, 556, 556, 350, 500, 889, 333, 979, 389, 333, 666, 777, 389, 556, 250, 389, 500, 500, 500, 500, 274, 500, 333, 759, 275, 500, 674, 333, 759, 500, 399, 548, 299, 299, 333, 576, 522, 250, 333, 299, 310, 500, 750, 750, 750, 500, 610, 610, 610, 610, 610, 610, 889, 666, 610, 610, 610, 610, 333, 333, 333, 333, 722, 666, 722, 722, 722, 722, 722, 674, 722, 722, 722, 722, 722, 556, 610, 500, 500, 500, 500, 500, 500, 500, 666, 443, 443, 443, 443, 443, 277, 277, 277, 277, 500, 500, 500, 500, 500, 500, 500, 548, 500, 500, 500, 500, 500, 443, 500, 443 ],
		'-descent' => -216,
		'-firstchar' => 1,
		'-fontname' => 'TimesNewRomanItalic',
		'-capheight' => 662,
		'-italicangle' => -16,
		'-flags' => 106,
		'-ascent' => 891,
		'-xheight' => 441,
		'-type' => 'TrueType',
		'-fontbbox' => [ -497, -306, 1120, 1023 ],
		'-lastchar' => 255
	},
	'timesnewroman' => {
		'-widths' => [ 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 777, 250, 333, 408, 500, 500, 833, 777, 180, 333, 333, 500, 563, 250, 333, 250, 277, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 277, 277, 563, 563, 563, 443, 920, 722, 666, 666, 722, 610, 556, 722, 722, 333, 389, 722, 610, 889, 722, 722, 556, 722, 666, 556, 610, 722, 722, 943, 722, 722, 610, 333, 277, 333, 469, 500, 333, 443, 500, 443, 500, 443, 333, 500, 500, 277, 277, 500, 277, 777, 500, 500, 500, 500, 333, 389, 277, 500, 500, 722, 500, 500, 443, 479, 200, 479, 541, 777, 500, 777, 333, 500, 443, 1000, 500, 500, 333, 1000, 556, 333, 889, 777, 610, 777, 777, 333, 333, 443, 443, 350, 500, 1000, 333, 979, 389, 333, 722, 777, 443, 722, 250, 333, 500, 500, 500, 500, 200, 500, 333, 759, 275, 500, 563, 333, 759, 500, 399, 548, 299, 299, 333, 576, 453, 250, 333, 299, 310, 500, 750, 750, 750, 443, 722, 722, 722, 722, 722, 722, 889, 666, 610, 610, 610, 610, 333, 333, 333, 333, 722, 722, 722, 722, 722, 722, 722, 563, 722, 722, 722, 722, 722, 722, 556, 500, 443, 443, 443, 443, 443, 443, 666, 443, 443, 443, 443, 443, 277, 277, 277, 277, 500, 500, 500, 500, 500, 500, 500, 548, 500, 500, 500, 500, 500, 500, 500, 500 ],
		'-descent' => -216,
		'-firstchar' => 1,
		'-fontname' => 'TimesNewRoman',
		'-capheight' => 662,
		'-italicangle' => '0',
		'-flags' => 42,
		'-ascent' => 891,
		'-xheight' => 447,
		'-type' => 'TrueType',
		'-fontbbox' => [ -568, -306, 2028, 1006 ],
		'-lastchar' => 255
	},
	'verdanabolditalic' => {
		'-widths' => [ 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 341, 402, 587, 867, 710, 1271, 862, 332, 543, 543, 710, 867, 361, 479, 361, 689, 710, 710, 710, 710, 710, 710, 710, 710, 710, 710, 402, 402, 867, 867, 867, 616, 963, 776, 761, 723, 830, 683, 650, 811, 837, 545, 555, 770, 637, 947, 846, 850, 732, 850, 782, 710, 681, 812, 763, 1128, 763, 736, 691, 543, 689, 543, 867, 710, 710, 667, 699, 588, 699, 664, 422, 699, 712, 341, 402, 670, 341, 1058, 712, 685, 699, 699, 497, 593, 455, 712, 648, 979, 668, 650, 596, 710, 543, 710, 867, 1000, 710, 1000, 332, 710, 587, 1048, 710, 710, 710, 1777, 710, 543, 1135, 1000, 691, 1000, 1000, 332, 332, 587, 587, 710, 710, 1000, 710, 963, 593, 543, 1067, 1000, 596, 736, 341, 402, 710, 710, 710, 710, 543, 710, 710, 963, 597, 849, 867, 479, 963, 710, 587, 867, 597, 597, 710, 721, 710, 361, 710, 597, 597, 849, 1181, 1181, 1181, 616, 776, 776, 776, 776, 776, 776, 1093, 723, 683, 683, 683, 683, 545, 545, 545, 545, 830, 846, 850, 850, 850, 850, 850, 867, 850, 812, 812, 812, 812, 736, 734, 712, 667, 667, 667, 667, 667, 667, 1018, 588, 664, 664, 664, 664, 341, 341, 341, 341, 679, 712, 685, 685, 685, 685, 685, 867, 685, 712, 712, 712, 712, 650, 699, 650 ],
		'-descent' => -209,
		'-firstchar' => 1,
		'-fontname' => 'VerdanaBoldItalic',
		'-capheight' => 727,
		'-italicangle' => -13,
		'-flags' => 104,
		'-ascent' => 1005,
		'-xheight' => 548,
		'-type' => 'TrueType',
		'-fontbbox' => [ -166, -207, 1704, 1000 ],
		'-lastchar' => 255
	},
	'verdanabold' => {
		'-widths' => [ 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 341, 402, 587, 867, 710, 1271, 862, 332, 543, 543, 710, 867, 361, 479, 361, 689, 710, 710, 710, 710, 710, 710, 710, 710, 710, 710, 402, 402, 867, 867, 867, 616, 963, 776, 761, 723, 830, 683, 650, 811, 837, 545, 555, 770, 637, 947, 846, 850, 732, 850, 782, 710, 681, 812, 763, 1128, 763, 736, 691, 543, 689, 543, 867, 710, 710, 667, 699, 588, 699, 664, 422, 699, 712, 341, 402, 670, 341, 1058, 712, 686, 699, 699, 497, 593, 455, 712, 649, 979, 668, 650, 596, 710, 543, 710, 867, 1000, 710, 1000, 332, 710, 587, 1048, 710, 710, 710, 1777, 710, 543, 1135, 1000, 691, 1000, 1000, 332, 332, 587, 587, 710, 710, 1000, 710, 963, 593, 543, 1067, 1000, 596, 736, 341, 402, 710, 710, 710, 710, 543, 710, 710, 963, 597, 849, 867, 479, 963, 710, 587, 867, 597, 597, 710, 721, 710, 361, 710, 597, 597, 849, 1181, 1181, 1181, 616, 776, 776, 776, 776, 776, 776, 1093, 723, 683, 683, 683, 683, 545, 545, 545, 545, 830, 846, 850, 850, 850, 850, 850, 867, 850, 812, 812, 812, 812, 736, 734, 712, 667, 667, 667, 667, 667, 667, 1018, 588, 664, 664, 664, 664, 341, 341, 341, 341, 679, 712, 686, 686, 686, 686, 686, 867, 686, 712, 712, 712, 712, 650, 699, 650 ],
		'-descent' => -209,
		'-firstchar' => 1,
		'-fontname' => 'VerdanaBold',
		'-capheight' => 727,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 1005,
		'-xheight' => 548,
		'-type' => 'TrueType',
		'-fontbbox' => [ -73, -207, 1707, 1000 ],
		'-lastchar' => 255
	},
	'verdanaitalic' => {
		'-widths' => [ 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 351, 393, 458, 818, 635, 1076, 726, 268, 454, 454, 635, 818, 363, 454, 363, 454, 635, 635, 635, 635, 635, 635, 635, 635, 635, 635, 454, 454, 818, 818, 818, 545, 1000, 682, 685, 698, 765, 632, 574, 775, 751, 420, 454, 692, 556, 842, 748, 787, 603, 787, 695, 683, 616, 731, 682, 990, 685, 615, 685, 454, 454, 454, 818, 635, 635, 600, 623, 520, 623, 595, 351, 621, 632, 274, 344, 586, 274, 973, 632, 606, 623, 623, 426, 520, 394, 632, 590, 818, 591, 590, 525, 634, 454, 634, 818, 1000, 635, 1000, 268, 635, 458, 818, 635, 635, 635, 1518, 683, 454, 1069, 1000, 685, 1000, 1000, 268, 268, 458, 458, 545, 635, 1000, 635, 976, 520, 454, 980, 1000, 525, 615, 351, 393, 635, 635, 635, 635, 454, 635, 635, 1000, 545, 644, 818, 454, 1000, 635, 541, 818, 541, 541, 635, 641, 635, 363, 635, 541, 545, 644, 1000, 1000, 1000, 545, 682, 682, 682, 682, 682, 682, 989, 698, 632, 632, 632, 632, 420, 420, 420, 420, 765, 748, 787, 787, 787, 787, 787, 818, 787, 731, 731, 731, 731, 615, 605, 620, 600, 600, 600, 600, 600, 600, 954, 520, 595, 595, 595, 595, 274, 274, 274, 274, 611, 632, 606, 606, 606, 606, 606, 818, 606, 632, 632, 632, 632, 590, 623, 590 ],
		'-descent' => -209,
		'-firstchar' => 1,
		'-fontname' => 'VerdanaItalic',
		'-capheight' => 727,
		'-italicangle' => -13,
		'-flags' => 104,
		'-ascent' => 1005,
		'-xheight' => 545,
		'-type' => 'TrueType',
		'-fontbbox' => [ -131, -206, 1460, 1000 ],
		'-lastchar' => 255
	},
	'verdana' => {
		'-widths' => [ 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 351, 393, 458, 818, 635, 1076, 726, 268, 454, 454, 635, 818, 363, 454, 363, 454, 635, 635, 635, 635, 635, 635, 635, 635, 635, 635, 454, 454, 818, 818, 818, 545, 1000, 683, 685, 698, 770, 632, 574, 775, 751, 420, 454, 692, 556, 842, 748, 787, 603, 787, 695, 683, 616, 731, 683, 988, 685, 615, 685, 454, 454, 454, 818, 635, 635, 600, 623, 520, 623, 595, 351, 623, 632, 274, 344, 591, 274, 972, 632, 606, 623, 623, 426, 520, 394, 632, 591, 818, 591, 591, 525, 634, 454, 634, 818, 1000, 635, 1000, 268, 635, 458, 818, 635, 635, 635, 1521, 683, 454, 1069, 1000, 685, 1000, 1000, 268, 268, 458, 458, 545, 635, 1000, 635, 976, 520, 454, 981, 1000, 525, 615, 351, 393, 635, 635, 635, 635, 454, 635, 635, 1000, 545, 644, 818, 454, 1000, 635, 541, 818, 541, 541, 635, 641, 635, 363, 635, 541, 545, 644, 1000, 1000, 1000, 545, 683, 683, 683, 683, 683, 683, 984, 698, 632, 632, 632, 632, 420, 420, 420, 420, 775, 748, 787, 787, 787, 787, 787, 818, 787, 731, 731, 731, 731, 615, 605, 620, 600, 600, 600, 600, 600, 600, 955, 520, 595, 595, 595, 595, 274, 274, 274, 274, 611, 632, 606, 606, 606, 606, 606, 818, 606, 632, 632, 632, 632, 591, 623, 591 ],
		'-descent' => -209,
		'-firstchar' => 1,
		'-fontname' => 'Verdana',
		'-capheight' => 727,
		'-italicangle' => '0',
		'-flags' => 40,
		'-ascent' => 1005,
		'-xheight' => 545,
		'-type' => 'TrueType',
		'-fontbbox' => [ -49, -206, 1446, 1000 ],
		'-lastchar' => 255
	},
	'webdings' => {
		'-widths' => [ 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 1000, 1000, 1000, 1000, 990, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 537, 537, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 558, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 500, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1220, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 672, 672, 1000, 842, 516, 1000, 1000, 1000, 1000, 428, 605, 1000, 1000, 1000, 1000, 662, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1291, 1000, 1000, 1000, 1000 ],
		'-descent' => -200,
		'-firstchar' => 1,
		'-fontname' => 'Webdings',
		'-capheight' => 604,
		'-italicangle' => '0',
		'-flags' => 34,
		'-ascent' => 799,
		'-xheight' => 604,
		'-type' => 'TrueType',
		'-fontbbox' => [ -1, -200, 4000, 799 ],
		'-lastchar' => 255
	},
	'wingdings' => {
		'-widths' => [ 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 500, 1000, 1030, 1144, 1301, 1343, 893, 1216, 458, 1083, 891, 1132, 1132, 1171, 1171, 1440, 1443, 1096, 1343, 698, 698, 891, 554, 602, 1072, 947, 1078, 939, 891, 891, 891, 891, 909, 909, 587, 792, 674, 674, 941, 941, 548, 548, 891, 843, 843, 843, 1110, 660, 849, 1088, 888, 880, 650, 812, 746, 746, 722, 693, 794, 885, 891, 895, 891, 1156, 1054, 963, 1090, 940, 933, 945, 1024, 928, 1096, 1064, 779, 1049, 1270, 746, 952, 746, 891, 891, 891, 891, 457, 746, 986, 891, 577, 1060, 1060, 891, 891, 891, 530, 530, 500, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 312, 457, 312, 891, 891, 891, 891, 891, 952, 457, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 1047, 1047, 1047, 1047, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1252, 1252, 794, 794, 891, 891, 891, 891, 891, 891, 979, 979, 891, 891, 775, 775, 775, 775, 1067, 1067, 891, 891, 872, 872, 872, 872, 891, 891, 810, 810, 1060, 810, 781, 781, 781, 781, 481, 385, 635, 785, 891, 891, 1034 ],
		'-descent' => -210,
		'-firstchar' => 1,
		'-fontname' => 'Wingdings',
		'-capheight' => 722,
		'-italicangle' => '0',
		'-flags' => 34,
		'-ascent' => 898,
		'-xheight' => 722,
		'-type' => 'TrueType',
		'-fontbbox' => [ 0, -210, 1358, 898 ],
		'-lastchar' => 255
	},
);

my $winfontsloaded=0;
my $psffontsloaded=0;

sub opts_from_ttf {
	my ($file,%opt) = @_;

#	if($winfontsloaded==0){
#		$winfontsloaded=1;
#
#		if($^O eq 'MSWin32') {
#			 
#			my $osname= Win32::IsWinNT() ? 'Windows NT' : 'Windows';
#
#			my $subKey= $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/$osname/CurrentVersion/Fonts/"};
#			my $fontDir=$Registry->{"HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/Explorer/Shell Folders"}->{Fonts};
#			foreach my $k (keys %{$subKey}) {
#				next unless($k=~/\(TrueType\)/);
#				my $kk=lc($k);
#				$kk=~s|^/||;
#				$kk=~s|\s+\(truetype\).*$||g;
#				$kk=~s/\s+//g;
#
#				my $f=$subKey->{$k}=~/[\\\/]/ ? $subKey->{$k} : "$fontDir/$subKey->{$k}";
#				if(-f $f) {
#					my %ff=opts_from_ttf($f);
#			#	#	print STDERR " $k :: $kk\n";
#					$winfonts{$kk}={%ff} if(%ff);
#				}
#			}	
#		} else {
#		##	print STDERR " FFF \n";
#		}
#	}



	my $alias=lc($file);
	$alias=~s/[\s]+//g;
	 
	if(defined $winfonts{$alias}){
		my %wf=%{$winfonts{$alias}};
		my $subf;
		if((($opt{-ttopts}||0)&0x07) == 2) {
			$subf=',Bold';
		} elsif((($opt{-ttopts}||0)&0x07) == 3) {
			$subf=',Italic';
		} elsif((($opt{-ttopts}||0)&0x07) == 4) {
			$subf=',BoldItalic';
		} else {
			$subf='';
		}
		$wf{-fontname}.=$subf;
		return %wf;
	} elsif($opt{-lookup}==1) {
		return undef;
	}

	my $font = Font::TTF::Font->open($file) || return undef; 

	$Font::TTF::Name::utf8 = 1;
    
	$font->{'post'}->read;
    
    	$opt{-ttfile}=$file;
	$opt{-type}="TrueType";
	my $altname = $font->{'name'}->read->find_name(1) || return undef;
	my $subf = $font->{'name'}->find_name(2);
    	$altname =~ s/\s//og;
    	$subf =~ s/\s//og;
    	$altname .= ",$subf" unless($subf =~ m/^Regular$/o);
	my $name = $font->{'name'}->read->find_name(4) || return undef;
    	$name =~ s/\s//og;
    	$subf='';
    	if($opt{-ttopts}&0x07 == 2) {
		$subf=',Bold';
    	} elsif($opt{-ttopts}&0x07 == 3) {
		$subf=',Italic';
    	} elsif($opt{-ttopts}&0x07 == 4) {
		$subf=',BoldItalic';
    	} else {
		$subf='';
    	}
	$opt{-fontname}="$name$subf";
	$opt{-altname}=$altname;
	my $upem = $font->{'head'}->read->{'unitsPerEm'};
	$opt{-ascent}=int($font->{'hhea'}->read->{'Ascender'} * 1000 / $upem);
	$opt{-descent}=int($font->{'hhea'}{'Descender'} * 1000 / $upem);

eval {
	$opt{-capheight}=int(
		$font->{'loca'}->read->{'glyphs'}[
			$font->{'post'}{'STRINGS'}{"H"}
		]->read->{'yMax'}
		* 1000 / $upem
	)||0;
};	
eval {
	$opt{-xheight}=int(
		$font->{'loca'}->read->{'glyphs'}[
			$font->{'post'}{'STRINGS'}{"x"}
		]->read->{'yMax'}
		* 1000 / $upem
	)||0;
};	

	$opt{-italicangle} = $font->{'post'}->read->{'italicAngle'}||0;

	$opt{-fontbbox} = [
		int($font->{'head'}{'xMin'} * 1000 / $upem),
        	int($font->{'head'}{'yMin'} * 1000 / $upem),
        	int($font->{'head'}{'xMax'} * 1000 / $upem),
        	int($font->{'head'}{'yMax'} * 1000 / $upem)
        ];

    my $flags = 4;
    $flags = 0;
    $flags |= 1 if ($font->{'OS/2'}->read->{'bProportion'} == 9);
    $flags |= 2 unless ($font->{'OS/2'}{'bSerifStyle'} > 10 && $font->{'OS/2'}{'bSerifStyle'} < 14);
    $flags |= 32; # if ($font->{'OS/2'}{'bFamilyType'} > 3);
    $flags |= 8 if ($font->{'OS/2'}{'bFamilyType'} == 2);
    $flags |= 64 if ($font->{'OS/2'}{'bLetterform'} > 8);
    $opt{-flags} = $flags;
    
    $font->{'cmap'}->read->find_ms;

    my $issymbol = (($font->{'cmap'}{' mstable'}{'Platform'} == 3) && ($font->{'cmap'}{' mstable'}{'Encoding'} == 0));
    
    $font->{'hmtx'}->read;
    $opt{-widths}= [
    	map { 
    		int(
    			$font->{'hmtx'}{'advance'}[$font->{'cmap'}->ms_lookup($_)] / $upem * 1000)
    	}
                ($issymbol ? (0xf001 .. 0xf0ff) : @cp1252) 
    ];
    $opt{-firstchar} = 1;
    $opt{-lastchar} = 255;

	return(%opt);
}

sub opts_from_pfm {
	my ($file,%opt) = @_;

#	if($psffontsloaded==0){
#		$psffontsloaded=1;
#
#		if(($^O eq 'MSWin32') && !$@) {
#
#			my $osname= Win32::IsWinNT() ? 'Windows NT' : 'Windows';
#
#			my $subKey= $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/$osname/CurrentVersion/Type 1 Installer/Type 1 Fonts/"};
#			my $fontDir=$Registry->{"HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/Explorer/Shell Folders"}->{Fonts};
#			foreach my $k (keys %{$subKey}) {
#				my $kk=lc($k);
#				$kk=~s|^/||;
#				$kk=~s/\s+//g;
#				my ($t,$pfm,$pfb)=split(/\0/,$subKey->{$k});
#				$pfb= $pfb=~/[\\\/]/ ? $pfb : "$fontDir/$pfb";
#				$pfm= $pfm=~/[\\\/]/ ? $pfm : "$fontDir/$pfm";
#				my %ff=opts_from_pfm($pfm,-pfbfile=>$pfb,-pfmfile=>$pfm);
#				$winfonts{$kk}={%ff};
#			#	print STDERR " $kk :: $pfb\n";
#			#	print STDERR " $kk :: $pfm\n";
#			}	
#		} else {
#		##	print STDERR " FFF \n";
#		}
#	}

	my $alias=lc($file);
	$alias=~s/[\s]+//g;
	 
	if(defined $winfonts{$alias}){
		my %wf=%{$winfonts{$alias}};
		my $subf;
		if((($opt{-ttopts}||0)&0x07) == 2) {
			$subf=',Bold';
		} elsif((($opt{-ttopts}||0)&0x07) == 3) {
			$subf=',Italic';
		} elsif((($opt{-ttopts}||0)&0x07) == 4) {
			$subf=',BoldItalic';
		} else {
			$subf='';
		}
		$wf{-fontname}.=$subf;
		return %wf;
	} elsif($opt{-lookup}==1) {
		return undef;
	}
	my %df;
	open(INF,$file) || return undef; 
	binmode(INF);
	read(INF,$buf,117);

	# Packing structure for PFM Header
	(	$df{Version}, 
		$df{Size}, 
		$df{Copyright}, 
		$df{Type}, 
		$df{Point}, 
		$df{VertRes}, 
		$df{HorizRes},
		$df{Ascent}, 
		$df{InternalLeading}, 
		$df{ExternalLeading}, 
		$df{Italic}, 
		$df{Underline}, 
		$df{StrikeOut},
		$df{Weight}, 
		$df{CharSet}, 
		$df{PixWidth}, 
		$df{PixHeight}, 
		$df{PitchAndFamily}, 
		$df{AvgWidth}, 
		$df{MaxWidth}, 
		$df{FirstChar}, 
		$df{LastChar}, 
		$df{DefaultChar}, 
		$df{BreakChar}, 
		$df{WidthBytes}, 
		$df{Device}, 
		$df{Face}, 
		$df{BitsPointer}, 
		$df{BitsOffset}
	) = unpack("vVa60vvvvvvvCCCvCvvCvvCCCCvVVVV",$buf); # PFM Header

	read(INF,$buf,30);

	(	$df{SizeFields}, 
		$df{ExtMetricsOffset}, 
		$df{ExtentTable},
		$df{OriginTable}, 
		$df{PairKernTable}, 
		$df{TrackKernTable},
		$df{DriverInfo},
		$df{Reserved}
	) = unpack("vVVVVVVV",$buf); # PFM Extension

	seek(INF,$df{ExtMetricsOffset},0);
	read(INF,$buf,52);
	my %etm;
	(	$etm{Size}, 
		$etm{PointSize}, 
		$etm{Orientation},
		$etm{MasterHeight}, 
		$etm{MinScale}, 
		$etm{MaxScale}, 
		$etm{CapHeight}, 
		$etm{xHeight}, 
		$etm{LowerCaseAscent}, 
		$etm{LowerCaseDescent},
		$etm{Slant}, 
		$etm{SuperScript}, 
		$etm{SubScript},
		$etm{SuperScriptSize}, 
		$etm{SubScriptSize},
		$etm{UnderlineOffset}, 
		$etm{UnderlineWidth},
		$etm{DoubleUpperUnderlineOffset},
		$etm{DoubleLowerUnderlineOffset},
		$etm{DoubleUpperUnderlineWidth},
		$etm{DoubleLowerUnderlineWidth}, 
		$etm{StrikeOutOffset}, 
		$etm{StrikeOutWidth},
		$etm{KernPairs}, 
		$etm{KernTracks}
	) = unpack("vvvvvvvvvvvvvvvvvvvvvvvvvv",$buf); # PFM Extended Text Metrics

	seek(INF,$df{Device},0);
	read(INF,$buf,250);

	($df{postScript}) = unpack("Z*",$buf);
	$buf=substr($buf,length($df{postScript})+1,250);
	($df{windowsName}) = unpack("Z*",$buf); 
	$buf=substr($buf,length($df{windowsName})+1,250);
	($df{psName}) = unpack("Z*",$buf); 

	seek(INF,$df{ExtentTable},0);

	$opt{-widths}= [];

	foreach ( $df{FirstChar} .. $df{LastChar} ) {
		read(INF,$buf,2);
		push(@{$opt{-widths}},unpack('v',$buf));
	}

	close(INF);

#foreach my $k (sort keys %df) {
#	print STDERR " $k :: $df{$k} \n";
#}
#foreach my $k (sort keys %etm) {
#	print STDERR " $k :: $etm{$k} \n";
#}
    
    	
	$opt{-type}="Type1";
	my $altname = $df{windowsName};
    	$altname =~ s/\s//og;
	my $name = $df{psName};
    	$name =~ s/[\s]+//og;
	my $subf='';
    	if($opt{-ttopts}&0x07 == 2) {
		$subf=',Bold';
    	} elsif($opt{-ttopts}&0x07 == 3) {
		$subf=',Italic';
    	} elsif($opt{-ttopts}&0x07 == 4) {
		$subf=',BoldItalic';
    	} else {
		$subf='';
    	}
	$opt{-fontname}="$name$subf";
	$opt{-altname}=$altname;
	$opt{-ascent}=$df{Ascent};
	$opt{-descent}=-200;

	$opt{-capheight}=$etm{CapHeight}||0;
	$opt{-xheight}=$etm{xHeight}||0;
	$opt{-italicangle} = $df{Italic}||0;

	$opt{-fontbbox} = [0,-200,$df{MaxWidth},$df{Ascent}];

	my $flags = 2 +32;
#	$flags |= 1 if ($font->{'OS/2'}->read->{'bProportion'} == 9);
#	$flags |= 2 unless ($font->{'OS/2'}{'bSerifStyle'} > 10 && $font->{'OS/2'}{'bSerifStyle'} < 14);
#	$flags |= 8 if ($font->{'OS/2'}{'bFamilyType'} == 2);
#	$flags |= 32; # if ($font->{'OS/2'}{'bFamilyType'} > 3);
	$flags |= 64 if ($df{Italic} != 0);
	$opt{-flags} = $flags;

	$opt{-firstchar} = $df{FirstChar};
	$opt{-lastchar} = $df{LastChar};

	return(%opt);
}


1;


__END__
