#!/usr/bin/env perl

my @roles = (
    "Array",
    "Code",
    "Float",
    "Hash",
    "Integer",
    "Number",
    "Scalar",
    "String",
    "Undef",
    "Universal",
);

sub print_pod {
    my ($fh, @roles) = @_;
    print $fh "=head1 ROLES\n\n";
    print $fh "=over 4\n\n";

    for my $role (@roles) {
        print $fh "=item *\n\n";
        print $fh "L<$role>\n\n";
    }

    print $fh "=back\n\n";
    print $fh "=cut\n\n";
}

for my $role (@roles) {
    open(my $fh, ">$0.\L$role.txt");
    require "lib/Data/Object/Role/$role.pm";
    print_pod $fh, sort @{"Data::Object::Role::$role\::ROLES"};
}

