#ifndef GABA_DEFINE
struct proxy_userauth_success
{
  struct packet_handler super;
  struct lsh_string *name;
  struct command_continuation *c;
};
extern struct lsh_class proxy_userauth_success_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_userauth_success_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_userauth_success *i = (struct proxy_userauth_success *) o;
  mark((struct lsh_object *) i->c);
}

static void do_proxy_userauth_success_free(struct lsh_object *o)
{
  struct proxy_userauth_success *i = (struct proxy_userauth_success *) o;
  lsh_string_free(i->name);
}

struct lsh_class proxy_userauth_success_class =
{ STATIC_HEADER,
  &packet_handler_class, "proxy_userauth_success", sizeof(struct proxy_userauth_success),
  do_proxy_userauth_success_mark,
  do_proxy_userauth_success_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_userauth_failure
{
  struct packet_handler super;
  struct exception_handler *e;
};
extern struct lsh_class proxy_userauth_failure_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_userauth_failure_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_userauth_failure *i = (struct proxy_userauth_failure *) o;
  mark((struct lsh_object *) i->e);
}

struct lsh_class proxy_userauth_failure_class =
{ STATIC_HEADER,
  &packet_handler_class, "proxy_userauth_failure", sizeof(struct proxy_userauth_failure),
  do_proxy_userauth_failure_mark,
  NULL
};
#endif /* !GABA_DECLARE */

