/* resource.h
 *
 * External resources associated with a connection, for instance
 * processes and ports. Used to kill or release the resource in
 * question when the connection dies.
 *
 * $Id: resource.h,v 1.8 1999/10/02 20:06:41 nisse Exp $ */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1998 Niels Mller
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LSH_RESOURCE_H_INCLUDED
#define LSH_RESOURCE_H_INCLUDED

#include "lsh.h"

#define GABA_DECLARE
#include "resource.h.x"
#undef GABA_DECLARE

/* GABA:
   (class
     (name resource)
     (vars
       ; Hack to check liveness before the resource gets gc:ed.
       ; Live resources should never be forgotten.
       (alive special int #f dont_free_live_resource)
       
       (kill method void)))
*/

#define KILL_RESOURCE(r) ((r)->kill((r)))

/* For the resource list. */

/* GABA:
   (class
     (name resource_list)
     (super resource)
     (vars
       (remember method void "struct resource *r")))
*/

#define REMEMBER_RESOURCE(l, r) ((l)->remember((l), (r)))
#define KILL_RESOURCE_LIST(l) KILL_RESOURCE(&(l)->super)


#if 0
/* ;;GABA:
   (class
     (name resource_list)
     (vars
       ;; (q struct object_queue)
       ;;(q special-struct "struct lsh_queue"
       ;;                  do_mark_resources do_free_resources)

       (q special "struct resource_node *"
                  do_mark_resources do_free_resources)       
       (remember method void "struct resource *r")

       ; Kills the resource and unlinks and deallocates the node.
       ;; (kill_resource method void "struct resource_node *n")
       
       (kill_all method void)))
*/
#endif

/* #define KILL_RESOURCE_NODE(l, n) ((l)->kill_resource((l), (n))) */


/* Allocates an empty list. */
struct resource_list *empty_resource_list(void);

#endif /* LSH_RESOURCE_H_INCLUDED */
