#ifndef CLASS_DEFINE
struct zlib_instance
{
  struct compress_instance super;
  UINT32 max;
  int (*(f))(z_stream *, int);
  z_stream z;
};
extern struct lsh_class zlib_instance_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_zlib_instance_free(struct lsh_object *o)
{
  struct zlib_instance *i = (struct zlib_instance *) o;
  do_free_zstream(&(i->z));
}

struct lsh_class zlib_instance_class =
{ STATIC_HEADER,
  &compress_instance_class, "zlib_instance", sizeof(struct zlib_instance),
  NULL,
  do_zlib_instance_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct zlib_algorithm
{
  struct compress_algorithm super;
  int level;
};
extern struct lsh_class zlib_algorithm_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class zlib_algorithm_class =
{ STATIC_HEADER,
  &compress_algorithm_class, "zlib_algorithm", sizeof(struct zlib_algorithm),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

