#ifndef CLASS_DEFINE
struct write_buffer
{
  struct abstract_write super;
  UINT32 block_size;
  UINT8 (*(buffer));
  int empty;
  UINT32 length;
  int closed;
  struct lsh_queue q;
  UINT32 pos;
  struct lsh_string *partial;
  UINT32 start;
  UINT32 end;
};
extern struct lsh_class write_buffer_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_write_buffer_free(struct lsh_object *o)
{
  struct write_buffer *i = (struct write_buffer *) o;
  lsh_space_free(i->buffer);
  do_free_buffer(&(i->q));
  lsh_string_free(i->partial);
}

struct lsh_class write_buffer_class =
{ STATIC_HEADER,
  &abstract_write_class, "write_buffer", sizeof(struct write_buffer),
  NULL,
  do_write_buffer_free
};
#endif /* !CLASS_DECLARE */

