#include <stdio.h>
#include <string.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include "consume.h"

/* support routines for simple manual parsers */

struct consume_data {
  FILE* f;
  int ln;
  int lastch;
};

typedef struct consume_data *C;

C consume(f)
     FILE* f;
{
  C c = malloc(sizeof(struct consume_data));
  if (!c) return 0;
  c->f = f;
  c->ln = 1;
  c->lastch = 0;
  return c;
}

static int g(c)
     C c;
{
  /* minimal */
  int ch;
  /* support 1 pushback */
  if (c->lastch) {
    ch = c->lastch;
    c->lastch = 0;
/*  printf("{%c}",ch); fflush(stdout); */
    return ch;
  }
  ch = getc(c->f);
  /* support line number reporting */
  if (ch == '\n') c->ln++;
/*  printf("<%c>",ch); fflush(stdout); */
  return ch;
}

error_line(c)
     C c;
{
  return c->ln;
}

skip_ws(c)
     C c;
{
  int ch;
  /* do get chars; while space or nl or !eof */
  while( (ch = g(c)) != EOF ) {
    switch(ch) {
    case ' ':
    case '\n':
    case '\t':
      break;
    default:
      c->lastch = ch;
      return;
    }
  }
}

found_eof(c)
     C c;
{
  /* true of ended */
  return feof(c->f);
}
skip_string(c,s)
     C c;
     char *s;
{
  /* get chars making sure they match this string. 
     return on end of string.
     exception on mismatch or eof.
     */
  int ch;
  char *p = s;
  while ( (ch = g(c)) != EOF ) {
    if (*p && ch == *p) {
      p++;
    } else {
      c->lastch = ch;
      return;
    }
  }
}

char *consume_until(c,s)
     C c;
     char *s;
{
  /* get chars until char in s */
  /* leave pointer at char in s */
  char *r;
  char ch;
  int sz = 32, i = 0;			/* tune this */
  r = malloc(sz);
  if (!r) { /* abort? */ return 0; }

  while ( (ch = g(c)) != EOF ) {
    if (strchr(s, ch)) {
      r[i++] = 0;
      r = realloc(r,i);
      c->lastch = ch;
      return r;
    }
    r[i++] = ch;
    if (i >= sz) {
      sz += sz;
      r = realloc(r,sz);
      if (!r) { /* abort? */ return 0; }
    }
  }
  r[i++] = 0;
  r = realloc(r,i);
  return r;
}
int looking_at(c,s)
     C c;
     char *s;
{
  /* true if current is in s */
  int ch = g(c);		/* get it */
  c->lastch = ch;		/* then put it back */
  return strchr(s, ch) != 0;
}

static char consume_digits[] = "0123456789";

consume_int_decimal(c,s)
     C c;
     char *s;
{
  /* get chars and make an int until we get a char in s */
  int ch;
  int x = 0;
  int sgn = 1;

  while ( (ch = g(c)) != EOF) {
    if (strchr(s,ch)) {
      c->lastch = ch;
      return sgn*x;
    }
    switch (ch) {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      x = 10*x + (strchr(consume_digits,ch)-consume_digits);
      break;
    case '-':
      sgn = (-1);
      break;
    default:
      /* oops. */
      c->lastch = ch;
      return sgn*x;
    }
  }
  return sgn*x;
}

static char consume_octal_digits[] = "01234567";

consume_int_3octal(c)
     C c;
{
  /* grabs 3 digits exactly */
  int ch, x = 0;
  char *p;

  ch = g(c);
  x <<= 3;
  if(p = strchr(consume_octal_digits, ch)) {
    x += p-consume_octal_digits;
  } else {
    /* abort? */ return -1;
  }

  ch = g(c);
  x <<= 3;
  if(p = strchr(consume_octal_digits, ch)) {
    x += p-consume_octal_digits;
  } else {
    /* abort? */ return -1;
  }

  ch = g(c);
  x <<= 3;
  if(p = strchr(consume_octal_digits, ch)) {
    x += p-consume_octal_digits;
  } else {
    /* abort? */ return -1;
  }

  return x;
}

int consume_byte(c)
     C c;
{
  /* grab byte, return as int, skip */
  return g(c);  
}

char *consume_date(c,s)
     C c;
     char *s;
{
  return consume_until(c,s);
}
double consume_float(c,s)
     C c;
     char *s;
{
  /* grab chars until a match, building a float as we go */
  int ch;
  double x = 0;
  double scale = 0;
  int sgn = 1;

  while ( (ch = g(c)) != EOF) {
    if (strchr(s,ch)) {
      c->lastch = ch;
      return sgn*x/scale;
    }
    switch (ch) {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      x = 10*x + (strchr(consume_digits,ch)-consume_digits);
      scale = scale*10;
      break;
    case '-':
      sgn = (-1);
      break;
    case '.':
      scale = 1;
      break;
    default:
      /* oops. */
      c->lastch = ch;
      return sgn*x/scale;
    }
  }
  return sgn*x/scale;
}

