/* 
   based on sources from grand.central.org:/pub/afs-contrib/tools/athena
   krb5 changes by Mark Eichin, Cygnus Support
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <krb5.h>
	
#include <afs/stds.h>
#include <afs/cellconfig.h>
#include <afs/keys.h>

int main(argc, argv)
     int argc;
     char **argv;
{
    struct afsconf_dir *tdir;
    register long code;

    if (argc == 1) {
	printf("asetkey: usage is 'setkey <opcode> options, e.g.\n");
	printf("    asetkey add <kvno> <keyfile> <princ>\n");
	printf("    asetkey delete <kvno>\n");
	printf("    asetkey list\n");
	exit(1);
    }

    tdir = afsconf_Open(AFSCONF_SERVERNAME);
    if (!tdir) {
	printf("asetkey: can't initialize conf dir '%s'\n", AFSCONF_SERVERNAME);
	exit(1);
    }
    if (strcmp(argv[1], "add")==0) {
	char tkey[8];
	int kvno;
	krb5_error_code v5code;
	krb5_context c;
	krb5_principal princ;
	krb5_keyblock *kb;
	char *keyfile = argv[3];

	krb5_init_context(&c);

	if (argc != 5) {
	    printf("asetkey add: usage is 'asetkey add <kvno> <keyfile> <princ>\n");
	    exit(1);
	}
	kvno = atoi(argv[2]);
	memset(tkey, 0, sizeof(tkey));
	v5code = krb5_parse_name(c, argv[4], &princ);
	if (v5code != 0) {
	  com_err (argv[0], v5code, "Invalid kerberos name %s",argv[4]);
	  exit(1);
	}
	v5code =
	  krb5_kt_read_service_key(c, keyfile, princ, kvno, ENCTYPE_DES_CBC_CRC, &kb);
	if (v5code != 0) {
	  com_err (argv[0], v5code, "failed to read service key");
	  exit(1);
	}
	if(kb->length != 8) {
	  fprintf(stderr,"%s: wrong key length (%d != 8)\n",
		  argv[0], kb->length);
	  exit(1);
	}
	memcpy((char *)tkey, (char *)kb->contents, kb->length);

	code = afsconf_AddKey(tdir, kvno, tkey);
	if (code) {
	    printf("asetkey: failed to set key, code %d.\n", code);
	    exit(1);
	}
    }
    else if (strcmp(argv[1], "delete")==0) {
	long kvno;
	if (argc != 3) {
	    printf("asetkey delete: usage is 'asetkey delete <kvno>\n");
	    exit(1);
	}
	kvno = atoi(argv[2]);
	code = afsconf_DeleteKey(tdir, kvno);
	if (code) {
	    printf("asetkey: failed to delete key %d, (code %d)\n", kvno, code);
	    exit(1);
	}
    }
    else if (strcmp(argv[1], "list") == 0) {
	struct afsconf_keys tkeys;
	register int i;
	char tbuffer[9];
	
	code = afsconf_GetKeys(tdir, &tkeys);
	if (code) {
	    printf("asetkey: failed to get keys, code %d\n", code);
	    exit(1);
	}
	for(i=0;i<tkeys.nkeys;i++) {
	    if (tkeys.key[i].kvno != -1) {
		memcpy(tbuffer, tkeys.key[i].key, 8);
		tbuffer[8] = 0;
		printf("kvno %4d: key is '%s'\n", tkeys.key[i].kvno, tbuffer);
	    }
	}
	printf("All done.\n");
    }
    else {
	printf("asetkey: unknown operation '%s', type 'asetkey' for assistance\n");
	exit(1);
    }
    exit(0);
}
