/* copyright 1997 cygnus support */
/* based on code from kinit and gssftp */
/* Mark Eichin */
#include <string.h>
#include <stdio.h>
#include <fcntl.h>		/* for O_RDONLY */
#include <arpa/ftp.h>
#include <arpa/telnet.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <gssapi/gssapi.h>
#include <gssapi/gssapi_generic.h>

#include <krb5.h>
#ifndef KRB5_ENV_CCNAME
#define KRB5_ENV_CCNAME	"KRB5CCNAME"
#endif
#include "ftplib.h"

static gss_ctx_id_t gcontext;
static int do_auth();
int ftpverbose=0, ftpdebug=0;
static int auth_gssapi_succeeded = 0;
#define FTP_BUFSIZ 10240
struct	sockaddr_in hisctladdr;
struct	sockaddr_in hisdataaddr;
struct	sockaddr_in data_addr;
struct	sockaddr_in myctladdr;
static FILE *dout, *din;
static int code;		/* return/reply code for ftp command */

static char *hookup(char *host, int port);
static int login(char *user, char *acct);
static int initconn();
static FILE *dataconn(char *lmode);
static int command(char *fmt, char*arg);
static int getreply(int expecteof);
static int lostpeer();
static int user_gss_error(OM_uint32 maj_stat, OM_uint32 min_stat, char *s);
static int secure_command(char *cmd);
static int radix_encode(unsigned char inbuf[], unsigned char outbuf[],
		 int *len, int decode);
static char *radix_error(int e);


#ifndef __vxworks
int main(int argc, char**argv) {
  struct ftpHandle *f;
  int st;
  printf("usage: ftplib host user passwd acct [r|w] dir fname\n");
  ftpverbose=0; ftpdebug=0;
  f = openFtp(argv[1], argv[2], argv[3], argv[4],
	      (argv[5][0]=='r')?O_RDONLY:O_WRONLY,
	      argv[6], argv[7]);
  if (!f) exit(1);
  if (argv[5][0] == 'r') {
    /* read */
    char buf[1024];
    while((st = readFtp(f,buf,1024)) > 0) {
      write(1, buf, st);
    }
  } else {
    /* write */
    char buf[1024];
    while((st = read(0,buf,1024)) > 0) {
      writeFtp(f, buf, st);
    }
  }
  closeFtp(f);
}
#endif

struct ftpHandle *
openFtp(char *tgtHost,		/* connect to  */
	char *usrName,		/* ftp "user" (also kerberos user) */
	char *passWd,		/* password  */
	char *acct,		/* account name */
	int cmd,		/* O_RDONLY == RETR, O_WRONLY == STOR */
	char *dirName,		/* directory target */
	char *fName		/* file name to store */
	)
{
  struct ftpHandle * fh = (struct ftpHandle*)malloc(sizeof(struct ftpHandle));
  krb5_context kcontext;
  krb5_principal me = NULL;
  krb5_creds my_creds;
  krb5_error_code code;
  krb5_get_init_creds_opt opts;
  krb5_ccache ccache = NULL;
  char *host;
  int st;
  char *lmode;
  char *cmds;
  int comret;

  if (!fh) {
    com_err("openFtp", ENOMEM, "can't allocate ftpHandle");
    return 0;
  }


#define CHECK_FIELD(x) if ( !x || (strlen(x) > FTPNAMESIZE)) return 0;

  CHECK_FIELD(tgtHost);
  CHECK_FIELD(usrName);
  CHECK_FIELD(passWd);
  CHECK_FIELD(acct);
  CHECK_FIELD(dirName);
  CHECK_FIELD(fName);
  switch (cmd) {
  case O_RDONLY: 
    cmds = "RETR %s"; lmode = "r"; break;
  case O_WRONLY: 
    cmds = "STOR %s"; lmode = "w"; break;
  default:
    return 0;
  }

  strcpy (fh->host, tgtHost);
  strcpy (fh->user, usrName);
  strcpy (fh->passWd, passWd);
  strcpy (fh->acct, acct);
  strcpy (fh->dirname, dirName);
  strcpy (fh->filename, fName);

  if (!*acct) acct = 0;

#define CHECKERR(c,m) if(c) { com_err("openFtp", c, m); return 0; }
  /* from client/kinit/kinit.c */
  krb5_init_context(&kcontext);
  krb5_init_ets(kcontext);
  /* Hmm, can opts be left out? */
  krb5_get_init_creds_opt_init(&opts);

  code = krb5_parse_name (kcontext, usrName, &me);
  CHECKERR(code, "when parsing initial user name");

  /* use memory cache, but make it the default for GSS code later */
#ifdef HAVE_SETENV
  setenv(KRB5_ENV_CCNAME, "MEMORY:ftp");
#else
#ifdef HAVE_PUTENV
  putenv(KRB5_ENV_CCNAME "=MEMORY:ftp");
#endif
#endif
  code = krb5_cc_default(kcontext, &ccache);
  CHECKERR(code, "while getting default ccache");

  code = krb5_get_init_creds_password(kcontext,
				      &my_creds,
				      me,		/* client */
				      passWd,		/* password  */
				      NULL, /* prompter */
				      NULL, /* data */
				      0, /* start_time */
				      NULL, /* service name */
				      &opts); /* options */
  if (code) {
    if (code == KRB5KRB_AP_ERR_BAD_INTEGRITY)
      com_err("openFtp", 0, "incorrect password for %s", usrName);
    else
      com_err("openFtp", code, "while getting initial credentials for %s",
	       usrName);
    return 0;
  }
  
/************ intentional duplication to work around library problem *******/

  code = krb5_get_init_creds_password(kcontext,
				      &my_creds,
				      me,		/* client */
				      passWd,		/* password  */
				      NULL, /* prompter */
				      NULL, /* data */
				      0, /* start_time */
				      NULL, /* service name */
				      &opts); /* options */
  if (code) {
    if (code == KRB5KRB_AP_ERR_BAD_INTEGRITY)
      com_err("openFtp", 0, "incorrect password for %s", usrName);
    else
      com_err("openFtp", code, "while getting initial credentials for %s",
	       usrName);
    return 0;
  }
  
  code = krb5_cc_initialize(kcontext, ccache, me);
  CHECKERR(code, "when initializing cache");

  code = krb5_cc_store_cred(kcontext, ccache, &my_creds);
  CHECKERR(code, "while storing credentials");

  krb5_free_principal(kcontext, me);
  krb5_cc_close(kcontext, ccache);
  krb5_free_context(kcontext);
  /* kinit stuff done */
  host = hookup(tgtHost, htons(21));
  if (!host) {
    printf("openFtp: hookup failed\n");
    return 0;
  }
  do_auth(tgtHost);
  login(usrName, acct);
  /* elided SYST test */
  /* commence the protocol here */
  comret = command("TYPE %s", "I");
  if (comret != COMPLETE) {
    printf ("openFtp: TYPE I failed %d\n", comret); return 0;
  }
  if (command("CWD %s", dirName) == ERROR && code == 500) {
    if (ftpverbose)
      printf("CWD command not recognized, trying XCWD\n");
    (void) command("XCWD %s", dirName);
  }
  st = initconn();
  if (st) { printf("openFtp: initconn failed\n"); return 0; }
  st = command(cmds, fName);
  if (st != PRELIM) {
    printf("openFtp: %s failed to negotiate\n", cmd); return 0;
  }
  dout = dataconn(lmode);
  if (!dout) { printf("openFtp: dataconn failed\n"); return 0; }
  
  fh->pDataSock = fileno(dout);
  return fh;
}

/* for parsing replies to the ADAT command */
static char *reply_parse, reply_buf[FTP_BUFSIZ], *reply_ptr;

/* ftp engine stuff from appl/gssftp/ftp.c */
static char* gss_services[] = { "ftp", "host", 0 };

static int do_auth(char *hostname)
{
  int oldverbose, kerror;
  unsigned char out_buf[FTP_BUFSIZ];
  int i;

  if (command("AUTH %s", "GSSAPI") == CONTINUE) {
    OM_uint32 maj_stat, min_stat, req_flags;
    gss_name_t target_name;
    gss_buffer_desc send_tok, recv_tok, *token_ptr;
    char stbuf[FTP_BUFSIZ];
    char **service_name, **end_service_name;
    int comcode;
    int noisyflag = 0;
    struct gss_channel_bindings_struct chan;
    chan.initiator_addrtype = GSS_C_AF_INET; /* OM_uint32  */ 
    chan.initiator_address.length = 4;
    chan.initiator_address.value = &myctladdr.sin_addr.s_addr;
    chan.acceptor_addrtype = GSS_C_AF_INET; /* OM_uint32 */
    chan.acceptor_address.length = 4;
    chan.acceptor_address.value = &hisctladdr.sin_addr.s_addr;
    chan.application_data.length = 0;
    chan.application_data.value = 0;

    req_flags = GSS_C_MUTUAL_FLAG | GSS_C_REPLAY_FLAG;
    /* if (forward) req_flags |= GSS_C_DELEG_FLAG; */

    for (end_service_name = gss_services; *end_service_name; )
      end_service_name++;
    end_service_name--;

    if (ftpverbose)
      printf("%s accepted as authentication type\n", "GSSAPI");
	  
    /* blob from gss-client */
	    
    for (service_name = gss_services; *service_name; service_name++) {
      noisyflag = ftpdebug || (service_name == end_service_name);

      /* ftp@hostname first, the host@hostname */
      /* the V5 GSSAPI binding canonicalizes this for us... */
      sprintf(stbuf, "%s@%s", *service_name, hostname);
      if (ftpdebug)
	fprintf(stderr, "Trying to authenticate to <%s>\n", stbuf);

      send_tok.value = stbuf;
      send_tok.length = strlen(stbuf) + 1;
      maj_stat = gss_import_name(&min_stat, &send_tok,
				 gss_nt_service_name, &target_name);
	    
      if (maj_stat != GSS_S_COMPLETE) {
	user_gss_error(maj_stat, min_stat, "parsing name");
	fprintf(stderr, "do_auth: name parsed <%s>\n", stbuf);
	continue;
      }

      token_ptr = GSS_C_NO_BUFFER;
      gcontext = GSS_C_NO_CONTEXT; /* structure copy */
	    
      do {
	if (ftpdebug)
	  fprintf(stderr, "calling gss_init_sec_context\n");
	maj_stat =
	  gss_init_sec_context(&min_stat,
			       GSS_C_NO_CREDENTIAL,
			       &gcontext,
			       target_name,
			       GSS_C_NULL_OID,
			       req_flags,
			       0,
			       &chan, /* channel bindings */
			       token_ptr,
			       NULL, /* ignore mech type */
			       &send_tok,
			       NULL, /* ignore ret_flags */
			       NULL); /* ignore time_rec */
	      

	if (maj_stat!=GSS_S_COMPLETE && maj_stat!=GSS_S_CONTINUE_NEEDED){
	  if (!(maj_stat == GSS_S_FAILURE
		/* we'd like to check this, but this isn't v5 code */
		/*&& min_stat == KRB5KDC_ERR_S_PRINCIPAL_UNKNOWN*/)
	      || noisyflag)
	    user_gss_error(maj_stat, min_stat, "initializing context");
	  (void) gss_release_name(&min_stat, &target_name);
	  /* could just be that we missed on the service name */
	  goto outer_loop;
	}
	    
	if (send_tok.length != 0) {
	  int len = send_tok.length;
	  reply_parse = "ADAT="; /* for command() later */
	  oldverbose = ftpverbose;
	  ftpverbose = 0;
	  kerror = radix_encode(send_tok.value, out_buf, &len, 0);
	  if (kerror)  {
	    fprintf(stderr, "Base 64 encoding failed: %s\n",
		    radix_error(kerror));
	  } else if ((comcode = command("ADAT %s", out_buf))!=COMPLETE
		     /* && comcode != 3 (335)*/) {
	    fprintf(stderr, "GSSAPI ADAT failed\n");
	    /* force out of loop */
	    maj_stat = GSS_S_FAILURE;
	  } else if (!reply_parse) {
	    fprintf(stderr,
		    "No authentication data received from server\n");
	    if (maj_stat == GSS_S_COMPLETE) {
	      fprintf(stderr, "...but no more was needed\n");
	      goto gss_complete_loop;
	    } else {
	      user_gss_error(maj_stat, min_stat, "no reply, huh?");
	      goto gss_complete_loop;
	    }
	  } else if (kerror = radix_encode(reply_parse,out_buf,&i,1)) {
	    fprintf(stderr, "Base 64 decoding failed: %s\n",
		    radix_error(kerror));
	  } else {
	    /* everything worked */
	    token_ptr = &recv_tok;
	    recv_tok.value = out_buf;
	    recv_tok.length = i;
	    continue;
	  }

	  /* get out of loop clean */
	gss_complete_loop:
	  service_name = end_service_name;
	  gss_release_buffer(&min_stat, &send_tok);
	  gss_release_name(&min_stat, &target_name);
	  goto outer_loop;
	}
      } while (maj_stat == GSS_S_CONTINUE_NEEDED);
    outer_loop:
      if (maj_stat == GSS_S_COMPLETE)
	break;
    }
    ftpverbose = oldverbose;
    if (maj_stat == GSS_S_COMPLETE) {
      if (ftpverbose)
	printf("GSSAPI authentication succeeded\n");
      reply_parse = NULL;
      auth_gssapi_succeeded = 1;
      return(1);
    } else {
      fprintf(stderr, "GSSAPI authentication failed\n");
      ftpverbose = oldverbose;
      reply_parse = NULL;
    }
  }
  return(0);
}

static FILE *cin, *cout;

static char *
hookup(host, port)
     char *host;
     int port;
{
  register struct hostent *hp = 0;
  int s, len, tos;
  static char hostnamebuf[80];

  memset((char *)&hisctladdr, 0, sizeof (hisctladdr));
  hisctladdr.sin_addr.s_addr = inet_addr(host);
  if (hisctladdr.sin_addr.s_addr != -1) {
    hisctladdr.sin_family = AF_INET;
    (void) strncpy(hostnamebuf, host, sizeof(hostnamebuf));
  } else {
    hp = gethostbyname(host);
    if (hp == NULL) {
      fprintf(stderr, "ftp: %s: ", host);
      herror("ftplib");
      code = -1;
      return((char *) 0);
    }
    hisctladdr.sin_family = hp->h_addrtype;
    memcpy((caddr_t)&hisctladdr.sin_addr, hp->h_addr_list[0],
	   hp->h_length);
    (void) strncpy(hostnamebuf, hp->h_name, sizeof(hostnamebuf));
  }
  host = hostnamebuf;
  s = socket(hisctladdr.sin_family, SOCK_STREAM, 0);
  if (s < 0) {
    perror("ftp: socket");
    code = -1;
    return (0);
  }
  hisctladdr.sin_port = port;
  while (connect(s, (struct sockaddr *)&hisctladdr, sizeof (hisctladdr)) < 0) {
    if (hp && hp->h_addr_list[1]) {
      int oerrno = errno;
      extern char *inet_ntoa();

      fprintf(stderr, "ftp: connect to address %s: ",
	      inet_ntoa(hisctladdr.sin_addr));
      errno = oerrno;
      perror((char *) 0);
      hp->h_addr_list++;
      memcpy((caddr_t)&hisctladdr.sin_addr,
	     hp->h_addr_list[0], hp->h_length);
      fprintf(stdout, "Trying %s...\n",
	      inet_ntoa(hisctladdr.sin_addr));
      (void) close(s);
      s = socket(hisctladdr.sin_family, SOCK_STREAM, 0);
      if (s < 0) {
	perror("ftp: socket");
	code = -1;
	return (0);
      }
      continue;
    }
    perror("ftp: connect");
    code = -1;
    goto bad;
  }
  len = sizeof (myctladdr);
  if (getsockname(s, (struct sockaddr *)&myctladdr, &len) < 0) {
    perror("ftp: getsockname");
    code = -1;
    goto bad;
  }
#ifdef IP_TOS
#ifdef IPTOS_LOWDELAY
  tos = IPTOS_LOWDELAY;
  if (setsockopt(s, IPPROTO_IP, IP_TOS, (char *)&tos, sizeof(int)) < 0)
    perror("ftp: setsockopt TOS (ignored)");
#endif
#endif
  cin = fdopen(s, "r");
  cout = fdopen(s, "w");
  if (cin == NULL || cout == NULL) {
    fprintf(stderr, "ftp: fdopen failed.\n");
    if (cin)
      (void) fclose(cin);
    if (cout)
      (void) fclose(cout);
    code = -1;
    goto bad;
  }
  if (ftpverbose)
    printf("Connected to %s.\n", host);
  if (getreply(0) > 2) { 	/* read startup message from server */
    if (cin)
      (void) fclose(cin);
    if (cout)
      (void) fclose(cout);
    code = -1;
    goto bad;
  }
#ifdef SO_OOBINLINE
  {
    int on = 1;

    if (setsockopt(s, SOL_SOCKET, SO_OOBINLINE, (char *)&on, sizeof(on))
	< 0 && ftpdebug) {
      perror("ftp: setsockopt");
    }
  }
#endif /* SO_OOBINLINE */

  return (host);
 bad:
  (void) close(s);
  return ((char *)0);
}

static int
login(char *user, char *acct)
{
  char tmp[80];
  int n;

  n = command("USER %s", user);
  if (n == COMPLETE)
    n = command("PASS %s", "dummy");
  else if (n == CONTINUE) {
    printf("login: failed, password requested for kerberos ftp\n");
    return 0;
  }
  if (acct != NULL)
    (void) command("ACCT %s", acct);
  return (1);
}

/*
 * Need to start a listen on the data channel before we send the command,
 * otherwise the server's connect may fail.
 */
static int	data = -1;
static int	options;	/* used during socket creation */
static char	pasv[64];	/* passive port for proxy data connection */

static int 
initconn()
{
  register char *p, *a;
  int result, len, tmpno = 0;
  int on = 1;

  int a1,a2,a3,a4,p1,p2;

  data = socket(AF_INET, SOCK_STREAM, 0);
  if (data < 0) {
    perror("ftp: socket");
    return(1);
  }
  if (options & SO_DEBUG &&
      setsockopt(data, SOL_SOCKET, SO_DEBUG, (char *)&on, sizeof (on)) < 0)
    perror("ftp: setsockopt (ignored)");
  if (command("PASV%s", "") != COMPLETE) {
    printf("Passive mode refused.  connection FAILED.\n");
    return 1;
  }

  /*
   * What we've got at this point is a string of comma separated
   * one-byte unsigned integer values, separated by commas.
   * The first four are the an IP address. The fifth is the MSB
   * of the port number, the sixth is the LSB. From that we'll
   * prepare a sockaddr_in.
   */

  if (sscanf(pasv,"%d,%d,%d,%d,%d,%d",&a1,&a2,&a3,&a4,&p1,&p2) != 6) {
    printf("Passive mode address scan failure. Shouldn't happen!\n");
    return(1);
  };
  
  data_addr.sin_family = AF_INET;
  data_addr.sin_addr.s_addr = htonl((a1<<24)|(a2<<16)|(a3<<8)|a4);
  data_addr.sin_port = htons((p1<<8)|p2);
  
  if (connect(data, (struct sockaddr *) &data_addr, sizeof(data_addr))<0) {
    perror("ftp: connect");
    return(1);
  }
#ifdef IP_TOS
#ifdef IPTOS_THROUGHPUT
  on = IPTOS_THROUGHPUT;
  if (setsockopt(data, IPPROTO_IP, IP_TOS, (char *)&on, sizeof(int)) < 0)
    perror("ftp: setsockopt TOS (ignored)");
#endif
#endif
  hisdataaddr = data_addr;
  return(0);

}

static FILE *
dataconn(char *lmode)
{
  return (fdopen(data, lmode));
}


static int cpend;		/* flag: if != 0, then pending server reply */
static int level = PROT_C;	/* protection level, default CLEAR */

static int 
command(char *fmt, char*arg)
{
  char in[FTP_BUFSIZ];

  int r;

  if (cout == NULL) {
    perror ("No control connection for command");
    code = -1;
    return (0);
  }
  sprintf(in, fmt, arg);
 again:	if (secure_command(in) == 0)
   return(0);
  cpend = 1;
  r = getreply(!strcmp(in /* fmt */, "QUIT"));

  if (r == 533 && level == PROT_P) {
    fprintf(stderr,
	    "ENC command not supported at server; retrying under MIC...\n");
    level = PROT_S;
    goto again;
  }

  return(r);
}

static int
secure_command(char *cmd)
{
  char in[FTP_BUFSIZ], out[FTP_BUFSIZ];
  int length, kerror;

  if (auth_gssapi_succeeded) {
    /*
     * File protection level also determines whether
     * commands are MIC or ENC.  Should be independent ...
     */
    /* secure_command (based on level) */
    if (auth_gssapi_succeeded) {
      gss_buffer_desc in_buf, out_buf;
      OM_uint32 maj_stat, min_stat;
      int conf_state;
      /* level = PROT_P; */
      in_buf.value = cmd;
      in_buf.length = strlen(cmd) + 1;
      maj_stat = gss_seal(&min_stat, gcontext,
			  (level==PROT_P), /* confidential */
			  GSS_C_QOP_DEFAULT,
			  &in_buf, &conf_state,
			  &out_buf);
      if (maj_stat != GSS_S_COMPLETE) {
	/* generally need to deal */
	user_gss_error(maj_stat, min_stat,
		       (level==PROT_P)?
		       "gss_seal ENC didn't complete":
		       "gss_seal MIC didn't complete");
      } else if ((level == PROT_P) && !conf_state) {
	fprintf(stderr, 
		"GSSAPI didn't encrypt message");
      } else {
	if (ftpdebug)
	  fprintf(stderr, "sealed (%s) %d bytes\n",
		  level==PROT_P?"ENC":"MIC", 
		  out_buf.length);
	memcpy(out, out_buf.value, 
	       length=out_buf.length);
	gss_release_buffer(&min_stat, &out_buf);
      }
    }
    /* Other auth types go here ... */
    if (kerror = radix_encode(out, in, &length, 0)) {
      fprintf(stderr,"Couldn't base 64 encode command (%s)\n",
	      radix_error(kerror));
      return(0);
    }
    fprintf(cout, "%s %s", level == PROT_P ? "ENC" : "MIC", in);
    if(ftpdebug) 
      fprintf(stderr, "secure_command(%s)\nencoding %d bytes %s %s\n",
	      cmd, length, level==PROT_P ? "ENC" : "MIC", in);
  } else	fputs(cmd, cout);
  fprintf(cout, "\r\n");
  (void) fflush(cout);
  return(1);
}

static char reply_string[FTP_BUFSIZ]; /* last line of previous reply */


#include <ctype.h>

static int
getreply(int expecteof)
{
  register int i, c, n;
  register int dig;
  register char *cp;
  int originalcode = 0, continuation = 0;
  int pflag = 0;
  char *pt = pasv;
  int kerror;

  char ibuf[FTP_BUFSIZ], obuf[FTP_BUFSIZ];
  int safe = 0;
  extern char *strpbrk(), *strstr();

  ibuf[0] = '\0';
  if (reply_parse) reply_ptr = reply_buf;

  for (;;) {
    obuf[0] = '\0';
    dig = n = code = i = 0;
    cp = reply_string;
    while ((c = ibuf[0] ? ibuf[i++] : getc(cin)) != '\n') {
      if (c == IAC) {		/* handle telnet commands */
	switch (c = getc(cin)) {
	case WILL:
	case WONT:
	  c = getc(cin);
	  fprintf(cout, "%c%c%c", IAC, DONT, c);
	  (void) fflush(cout);
	  break;
	case DO:
	case DONT:
	  c = getc(cin);
	  fprintf(cout, "%c%c%c", IAC, WONT, c);
	  (void) fflush(cout);
	  break;
	default:
	  break;
	}
	continue;
      }
      dig++;
      if (c == EOF) {
	if (expecteof) {
	  code = 221;
	  return (0);
	}
	lostpeer();
	if (ftpverbose) {
	  printf("421 Service not available, remote server has closed connection\n");
	  (void) fflush(stdout);
	}
	code = 421;
	return(4);
      }
      if (n == 0)
	n = c;
      if (auth_gssapi_succeeded && !ibuf[0] &&
	  (n == '6' || continuation)) {
	if (c != '\r' && dig > 4)
	  obuf[i++] = c;
      } else {
	if (auth_gssapi_succeeded && !ibuf[0] && dig == 1 && ftpverbose)
	  printf("Unauthenticated reply received from server:\n");
	if (reply_parse) *reply_ptr++ = c;
	if (c != '\r' && (ftpverbose > 0 ||
			  (ftpverbose > -1 && n == '5' && dig > 4))) {
	  (void) putchar(c);
	}
      }
      if (auth_gssapi_succeeded && !ibuf[0] && n != '6') continue;
      if (dig < 4 && isdigit(c))
	code = code * 10 + (c - '0');
      if (!pflag && code == 227)
	pflag = 1;
      if (dig > 4 && pflag == 1 && isdigit(c))
	pflag = 2;
      if (pflag == 2) {
	if (c != '\r' && c != ')')
	  *pt++ = c;
	else {
	  *pt = '\0';
	  pflag = 3;
	}
      }
      if (dig == 4 && c == '-' && n != '6') {
	if (continuation)
	  code = 0;
	continuation++;
      }
      if (cp < &reply_string[sizeof(reply_string) - 1])
	*cp++ = c;
    }
    if (auth_gssapi_succeeded && !ibuf[0] && n != '6')
      return(getreply(expecteof));
    ibuf[0] = obuf[i] = '\0';
    if (code && n == '6')
      if (code != 631 && code != 632 && code != 633) {
	printf("Unknown reply: %d %s\n", code, obuf);
	n = '5';
      } else safe = code;
    if (obuf[0])		/* if there is a string to decode */
      if (!auth_gssapi_succeeded) {
	printf("Cannot decode reply:\n%d %s\n", code, obuf);
	n = '5';
      }
      else {
	int len;
	if (kerror = radix_encode(obuf, ibuf, &len, 1)) {
	  printf("Can't base 64 decode reply %d (%s)\n\"%s\"\n",
		 code, radix_error(kerror), obuf);
	  n = '5';
	} else if (auth_gssapi_succeeded) {
	  gss_buffer_desc xmit_buf, msg_buf;
	  OM_uint32 maj_stat, min_stat;
	  int conf_state;
	  xmit_buf.value = ibuf;
	  xmit_buf.length = len;
	  /* decrypt/verify the message */
	  conf_state = safe;
	  maj_stat = gss_unseal(&min_stat, gcontext, 
				&xmit_buf, &msg_buf, 
				&conf_state, NULL);
	  if (maj_stat != GSS_S_COMPLETE) {
	    user_gss_error(maj_stat, min_stat, 
			   "failed unsealing reply");
	    n = '5';
	  } else {
	    memcpy(ibuf, msg_buf.value, 
		   msg_buf.length);
	    strcpy(&ibuf[msg_buf.length], "\r\n");
	    gss_release_buffer(&min_stat,&msg_buf);
	    continue;
	  }
	}
	/* Other auth types go here... */
      }
    else
      if (ftpverbose > 0 || ftpverbose > -1 && n == '5') {
	(void) putchar(c);
	(void) fflush (stdout);
      }
    if (continuation && code != originalcode) {
      if (originalcode == 0)
	originalcode = code;
      continue;
    }
    *cp = '\0';
    if (n != '1')
      cpend = 0;
    if (code == 421 || originalcode == 421)
      lostpeer();
    if (reply_parse) {
      *reply_ptr = '\0';
      if (reply_ptr = strstr(reply_buf, reply_parse)) {
	reply_parse = reply_ptr + strlen(reply_parse);
	if (reply_ptr = strpbrk(reply_parse, " \r"))
	  *reply_ptr = '\0';
      } else reply_parse = reply_ptr;
    }
    return (n - '0');
  }
}

static int connected;		/* connected to server */

static int
lostpeer()
{
  if (connected) {
    if (cout != NULL) {
      (void) shutdown(fileno(cout), 1+1);
      (void) fclose(cout);
      cout = NULL;
    }
    if (data >= 0) {
      (void) shutdown(data, 1+1);
      (void) close(data);
      data = -1;
    }
    connected = 0;
    auth_gssapi_succeeded = 0;
    level = PROT_C;
  }
}

static int
user_gss_error(OM_uint32 maj_stat, OM_uint32 min_stat, char *s)
{
  /* a lot of work just to report the error */
  OM_uint32 gmaj_stat, gmin_stat;
  gss_buffer_desc msg;
  int msg_ctx;
  msg_ctx = 0;
  while (!msg_ctx) {
    gmaj_stat = gss_display_status(&gmin_stat, maj_stat,
				   GSS_C_GSS_CODE,
				   GSS_C_NULL_OID,
				   &msg_ctx, &msg);
    if ((gmaj_stat == GSS_S_COMPLETE)||
	(gmaj_stat == GSS_S_CONTINUE_NEEDED)) {
      fprintf(stderr, "GSSAPI error major: %s\n",
	      (char*)msg.value);
      (void) gss_release_buffer(&gmin_stat, &msg);
    }
    if (gmaj_stat != GSS_S_CONTINUE_NEEDED)
      break;
  }
  msg_ctx = 0;
  while (!msg_ctx) {
    gmaj_stat = gss_display_status(&gmin_stat, min_stat,
				   GSS_C_MECH_CODE,
				   GSS_C_NULL_OID,
				   &msg_ctx, &msg);
    if ((gmaj_stat == GSS_S_COMPLETE)||
	(gmaj_stat == GSS_S_CONTINUE_NEEDED)) {
      fprintf(stderr, "GSSAPI error minor: %s\n",
	      (char*)msg.value);
      (void) gss_release_buffer(&gmin_stat, &msg);
    }
    if (gmaj_stat != GSS_S_CONTINUE_NEEDED)
      break;
  }
  fprintf(stderr, "GSSAPI error: %s\n", s);
}

int writeFtp (struct ftpHandle *handle, char *buffer, size_t nBytes)
{
  int st;
  st = write(handle->pDataSock, buffer, nBytes);
  if (st != nBytes) 
    printf("writeFtp: failed %d\n", st);
  return st;
}

int readFtp(struct ftpHandle* handle, char *buffer, size_t maxbytes)
{
  int st;
  st = read(handle->pDataSock, buffer, maxbytes);
  if (st < 0) {
    perror("readFtp");
    return st;
  } else {
    return st;
  }
}

int closeFtp(struct ftpHandle* f)
{
  OM_uint32 min_stat;
  fclose(dout);
  command("QUIT%s","");
  gss_delete_sec_context(&min_stat, &gcontext, GSS_C_NO_BUFFER);
}

static char *radixN =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static char pad = '=';

static int
radix_encode(unsigned char inbuf[], unsigned char outbuf[], 
	     int *len, int decode)
{
	int i,j,D;
	char *p;
	unsigned char c;

	if (decode) {
		for (i=0,j=0; inbuf[i] && inbuf[i] != pad; i++) {
		    if ((p = strchr(radixN, inbuf[i])) == NULL) return(1);
		    D = p - radixN;
		    switch (i&3) {
			case 0:
			    outbuf[j] = D<<2;
			    break;
			case 1:
			    outbuf[j++] |= D>>4;
			    outbuf[j] = (D&15)<<4;
			    break;
			case 2:
			    outbuf[j++] |= D>>2;
			    outbuf[j] = (D&3)<<6;
			    break;
			case 3:
			    outbuf[j++] |= D;
		    }
		}
		switch (i&3) {
			case 1: return(3);
			case 2: if (D&15) return(3);
				if (strcmp((char *)&inbuf[i], "==")) return(2);
				break;
			case 3: if (D&3) return(3);
				if (strcmp((char *)&inbuf[i], "="))  return(2);
		}
		*len = j;
	} else {
		for (i=0,j=0; i < *len; i++)
		    switch (i%3) {
			case 0:
			    outbuf[j++] = radixN[inbuf[i]>>2];
			    c = (inbuf[i]&3)<<4;
			    break;
			case 1:
			    outbuf[j++] = radixN[c|inbuf[i]>>4];
			    c = (inbuf[i]&15)<<2;
			    break;
			case 2:
			    outbuf[j++] = radixN[c|inbuf[i]>>6];
			    outbuf[j++] = radixN[inbuf[i]&63];
			    c = 0;
		    }
		if (i%3) outbuf[j++] = radixN[c];
		switch (i%3) {
			case 1: outbuf[j++] = pad;
			case 2: outbuf[j++] = pad;
		}
		outbuf[*len = j] = '\0';
	}
	return(0);
}

static char *
radix_error(int e)
{
	switch (e) {
	    case 0:  return("Success");
	    case 1:  return("Bad character in encoding");
	    case 2:  return("Encoding not properly padded");
	    case 3:  return("Decoded # of bits not a multiple of 8");
	    default: return("Unknown error");
	}
}
