#include "defines.h"
#include "dm.h"
# include	<stdio.h>
#ifdef X_POSIX_C_SOURCE
#define _POSIX_C_SOURCE X_POSIX_C_SOURCE
#include <signal.h>
#undef _POSIX_C_SOURCE
#else
#if defined(X_NOT_POSIX) || defined(_POSIX_SOURCE)
#include <signal.h>
#else
#define _POSIX_SOURCE
#include <signal.h>
#undef _POSIX_SOURCE
#endif
#endif
#ifndef sigmask
#define sigmask(m)  (1 << ((m - 1)))
#endif

# include	<sys/stat.h>
# include	<errno.h>
# include	<X11/Xfuncproto.h>
#if NeedVarargsPrototypes
# include <stdarg.h>
# define Va_start(a,b) va_start(a,b)
#else
# include <varargs.h>
# define Va_start(a,b) va_start(a)
#endif

#ifndef NOXDMTITLE
static char *Title;
static int TitleLen;
#endif

int ManageSession (struct display *d);
int LoadServerResources (struct display *d);
int LoadSessionResources (struct display *d);

int main(int argc, char**argv) {
  static DisplayType	acceptableTypes[] =
    { { Local, Permanent, FromFile },
	{ Foreign, Permanent, FromFile },
    };

#ifndef NOXDMTITLE
  Title = argv[0];
  TitleLen = (argv[argc - 1] + strlen(argv[argc - 1])) - Title;
#endif
  InitResources (argc, argv);
  LoadDMResources ();
  debugLevel = 42;
  /* instead of ScanServers: */
  ParseDisplay(":0 local /bin/uname\n", acceptableTypes, 2);

  ForEachDisplay(LoadServerResources);
  ForEachDisplay(LoadSessionResources);
  ForEachDisplay(ManageSession);
}

static FD_TYPE	CloseMask;
static int	max;

RegisterCloseOnFork (fd)
int	fd;
{
    FD_SET (fd, &CloseMask);
    if (fd > max)
	max = fd;
}

ClearCloseOnFork (fd)
int	fd;
{
    FD_CLR (fd, &CloseMask);
    if (fd == max) {
	while (--fd >= 0)
	    if (FD_ISSET (fd, &CloseMask))
		break;
	max = fd;
    }
}

CloseOnFork ()
{
    int	fd;

    for (fd = 0; fd <= max; fd++)
	if (FD_ISSET (fd, &CloseMask))
	    close (fd);
    FD_ZERO (&CloseMask);
    max = 0;
}
int	ChildReady;
int		Rescan;

#if NeedVarargsPrototypes
SetTitle (char *name, ...)
#else
/*VARARGS*/
SetTitle (name, va_alist)
char *name;
va_dcl
#endif
{
#ifndef NOXDMTITLE
    char	*p = Title;
    int	left = TitleLen;
    char	*s;
    va_list	args;

    Va_start(args,name);
    *p++ = '-';
    --left;
    s = name;
    while (s)
    {
	while (*s && left > 0)
	{
	    *p++ = *s++;
	    left--;
	}
	s = va_arg (args, char *);
    }
    while (left > 0)
    {
	*p++ = ' ';
	--left;
    }
    va_end(args);
#endif	
}

void
StopDisplay (d)
    struct display	*d;
{
abort();
}

/*  int nofork_session = 0; */

void
StartDisplay (d)
struct display	*d;
{
  abort();
}

TerminateProcess (pid, signal)
{
    kill (pid, signal);
#ifdef SIGCONT
    kill (pid, SIGCONT);
#endif
}

static int HaveUnmanagedDisplays, ShuttingDown;
WaitForChild ()
{
  abort();
}
