/*
 * clients/kinit/t_kinit.c
 * Copyright 1996 by Cygnus Solutions.
 */

#include <krb5.h>

#include <stdio.h>
#include <string.h>

/* simple AS-req speed test - reads alternating lines of principal
   name and password from stdin. First line is "target" principal.
   exits with 1 for library errors, 2 for io errors. */

void chop(str)
  char *str;
{
  char *p = strchr(str, '\n');
  if (p) *p = 0;
}

int main(argc, argv)
  int argc;
  char **argv;
{
  krb5_context kcontext;
  /* set up a memory cache */
#define bufsiz 1024
  char srvbuf[bufsiz];
  char clntbuf[bufsiz];
  char pwbuf[bufsiz];
  krb5_principal princ;
  krb5_creds creds;
  krb5_error_code retval;
  int count = 0;

  krb5_init_context(&kcontext);
  krb5_init_ets(kcontext);

  if(!fgets(srvbuf, bufsiz-1, stdin)) {
    perror("reading server principal");
    exit(2);
  }
  srvbuf[bufsiz-1] = 0;
  chop(srvbuf);
  printf("server: <%s>\n", srvbuf);

  while(fgets(clntbuf, bufsiz-1, stdin)) {
    clntbuf[bufsiz-1] = 0;
    chop(clntbuf);
    retval = krb5_parse_name(kcontext, clntbuf, &princ);
    if (retval) {
      com_err(argv[0], retval, "parsing client principal");
      exit(1);
    }

    if(!fgets(pwbuf, bufsiz-1, stdin)) {
      perror("reading a password");
      exit(2);
    }
    pwbuf[bufsiz-1] = 0;
    chop(pwbuf);

    memset((char*)&creds, 0, sizeof(creds));

    retval = krb5_get_init_creds_password(kcontext, &creds, princ, pwbuf,
					  NULL, NULL, 0, srvbuf, NULL);

    krb5_free_cred_contents(kcontext, &creds);

    if (retval) {
      com_err(argv[0], retval, "getting ticket with principal <%s> entry %d",
	      clntbuf, count+1);
      exit(1);
    }
    count++;
  }
  printf("%d successful tickets\n", count);
  exit(0);
}
