/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/* $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/kadmin/server/misc.h,v 1.6 1996/07/22 20:28:56 marc Exp $
 * 
 * $Log: misc.h,v $
 * Revision 1.6  1996/07/22 20:28:56  marc
 * this commit includes all the changes on the OV_9510_INTEGRATION and
 * OV_MERGE branches.  This includes, but is not limited to, the new openvision
 * admin system, and major changes to gssapi to add functionality, and bring
 * the implementation in line with rfc1964.  before committing, the
 * code was built and tested for netbsd and solaris.
 *
 * Revision 1.5.4.1  1996/07/18 03:03:40  marc
 * merged in changes from OV_9510_BP to OV_9510_FINAL1
 *
 * Revision 1.5.2.1  1996/06/20  21:57:20  marc
 * File added to the repository on a branch
 *
 * Revision 1.5  1996/05/30  21:13:24  bjaspan
 * kadm5_get_principal_v1 takes a kadm5_principal_ent_t_v1
 * add kadm5_get_policy_v1
 *
 * Revision 1.4  1996/05/20 21:39:05  bjaspan
 * rename to kadm5
 * add kadm5_get_principal_v1
 *
 * Revision 1.3  1994/09/13 18:24:41  jik
 * Back out randkey changes.
 *
 * Revision 1.2  1994/09/12  20:26:12  jik
 * randkey_principal_wrapper now takes a new_kvno option.
 *
 * Revision 1.1  1994/08/11  17:00:44  jik
 * Initial revision
 *
 */

kadm5_ret_t chpass_principal_wrapper(void *server_handle,
				     krb5_principal principal,
				     char *password);

kadm5_ret_t randkey_principal_wrapper(void *server_handle,
				      krb5_principal principal,
				      krb5_keyblock **key,
				      int *n_keys);

kadm5_ret_t kadm5_get_principal_v1(void *server_handle,
				   krb5_principal principal, 
				   kadm5_principal_ent_t_v1 *ent);

kadm5_ret_t kadm5_get_policy_v1(void *server_handle, kadm5_policy_t name,
				kadm5_policy_ent_t *ent);
