.\" krb524/k524init.M
.\"
.\" Copyright 1990 by the Massachusetts Institute of Technology.
.\"
.\" Export of this software from the United States of America may
.\"   require a specific license from the United States Government.
.\"   It is the responsibility of any person or organization contemplating
.\"   export to obtain such a license before exporting.
.\" 
.\" WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
.\" distribute this software and its documentation for any purpose and
.\" without fee is hereby granted, provided that the above copyright
.\" notice appear in all copies and that both that copyright notice and
.\" this permission notice appear in supporting documentation, and that
.\" the name of M.I.T. not be used in advertising or publicity pertaining
.\" to distribution of the software without specific, written prior
.\" permission.  M.I.T. makes no representations about the suitability of
.\" this software for any purpose.  It is provided "as is" without express
.\" or implied warranty.
.\" "
.ds h ""KerbNet -- Kerberos V5" "Cygnus Solutions""
.TH KINIT 1 \*h
.SH NAME
krb524init \- use Kerberos V5 tickets to obtain Kerberos V4 tickets
.SH SYNOPSIS
.TP
\fBkrb524init\fP [\fB\-p\fP \fIprincipal\fP] [\fB\-n\fP] [\fB\-\-version\fP]
.SH DESCRIPTION
.I krb524init
uses the
.IR krb524d (8)
daemon to obtain a Kerberos V4 ticket from an existing Kerberos V5
ticket.  
.PP
.I krb524init
uses the list of KDC entries in the
.IR krb5.conf (5)
file to find the addresses of the KDCs, in the same manner as
.IR kinit (1).
.PP
.I krb524init
uses the "krb524/udp" port if one is listed in /etc/services.  If no
"krb524/udp" port is listed, it uses port 4444 as the default.
.PP
.I krb524init
uses the same exponential backoff as kinit.
.SH OPTIONS
.TP
\fB\-p\fP \fIprincipal\fP
specifies the principal for the Kerberos V4 ticket.  This can be any
valid principal, including a TGT or service.  Note that
.I principal
must be specified in Kerberos V5 format, as in:
.sp
.nf
.in +.3i
krb524init -p host/charon.mit.edu@ATHENA.MIT.EDU
.in -.3i
.fi
.sp
Specifying the principal in Kerberos V4 format:
.sp
.nf
.in +.3i
krb524init -p rcmd.charon@ATHENA.MIT.EDU
.in -.3i
.fi
.sp
would produce an error.
.TP
.B \-n
Add the newly obtained Kerberos V4 tickets to the V4 ticket cache.  By
default,
.I krb524init
deletes any existing V4 tickets.
.TP
.B \-\-version
Prints out the KerbNet release version of the binary and then exits.
.SH ENVIRONMENT
.B krb524d
uses the following environment variable:
.TP "\w'.SM KRB5CCNAME\ \ 'u"
.SM KRB5CCNAME
Location of the Kerberos V5 credentials (ticket) cache.
.TP
.SM KRBTKFILE
Location of the Kerberos V4 credentials (ticket) cache.
.SH FILES
.TP "\w'/tmp/krb5cc_[uid]\ \ 'u"
/tmp/krb5cc_[uid]
default Kerberos V5 credentials cache ([uid] is the decimal UID of the user).
.TP
/tmp/tkt_[uid]
default Kerberos V4 credentials cache ([uid] is the decimal UID of the user).
.TP
/etc/krb5.conf
file containing local host's Kerberos V5 configuration information
.SH SEE ALSO
kinit(1), klist(1), kdestroy(1), kerberos(1), krb5.conf(5), krb524d(8)
