.\" krb524/krb524d.M
.\"
.\" Copyright 1990 by the Massachusetts Institute of Technology.
.\"
.\" Export of this software from the United States of America may
.\"   require a specific license from the United States Government.
.\"   It is the responsibility of any person or organization contemplating
.\"   export to obtain such a license before exporting.
.\" 
.\" WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
.\" distribute this software and its documentation for any purpose and
.\" without fee is hereby granted, provided that the above copyright
.\" notice appear in all copies and that both that copyright notice and
.\" this permission notice appear in supporting documentation, and that
.\" the name of M.I.T. not be used in advertising or publicity pertaining
.\" to distribution of the software without specific, written prior
.\" permission.  M.I.T. makes no representations about the suitability of
.\" this software for any purpose.  It is provided "as is" without express
.\" or implied warranty.
.\" "
.ds h ""KerbNet -- Kerberos V5" "Cygnus Solutions""
.TH KINIT 1 \*h
.SH NAME
krb524d \- daemon for issuing Kerberos V4 tickets from Kerberos V5 tickets
.SH SYNOPSIS
.TP
\fBkrb524d\fP [\fB\-m\fP | \fB\-k\fP] [\fB\-\-version\fP]
.SH DESCRIPTION
The
.I krb524d
daemon runs on the KDC.  When the
.IR krb524init (1)
client presents a Kerberos V5 ticket to it, it generates a Kerberos V4
ticket.
.PP
.I krb524d
runs on the "krb524/udp" port, if one is specified in the host's
.IR services (5)
file (/etc/services).  Otherwise,
.I krb524d
uses port 4444 as the default.
.SH OPTIONS
.TP
.B -m
use the KDC database directly to verify the V5 ticket.  This is the
normal mode.  This option is mutually exclusive with the
.B -k
option.
.TP
.B -k
use the keytab file specified in the environment variable KRB5_KTNAME
instead of the KDC database to verify the ticket.  This option is
mutually exclusive with the
.B -m
option.
.TP
.B \-\-version
Print out the release version of the binary and exit.
.SH ENVIRONMENT
.B krb524d
uses the following environment variable:
.TP "\w'.SM KRB5CCNAME\ \ 'u"
.SM KRB5CCNAME
Location of the Kerberos V5 credentials (ticket) cache.
.TP
.SM KRBTKFILE
Location of the Kerberos V4 credentials (ticket) cache.
.SH FILES
.TP "\w'/tmp/krb5cc_[uid]\ \ 'u"
/tmp/krb5cc_[uid]
default Kerberos V5 credentials cache ([uid] is the decimal UID of the user).
.TP
/tmp/tkt_[uid]
default Kerberos V4 credentials cache ([uid] is the decimal UID of the user).
.TP
/etc/krb5.conf
file containing local host's Kerberos V5 configuration information
.SH SEE ALSO
kinit(1), klist(1), kdestroy(1), kerberos(1), krb5.conf(5), krb524d(8)
.SH BUGS
Due to bugs that prevent values from 128*5 to 255*5 from being handled
correctly, if the lifetime of a v4 ticket would be greater than 128*5
minutes the "CMU algorithm" is used.  This causes values from 128 to 192
to be interpreted on a geometric scale from 10 2/3 hours to 30 days.
Values in this range will be displayed differently by non-CMU V4
clients, but will be interpreted correctly by the AFS "aklog" program.
