/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "gssapiP_krb5.h"

/*
 * $Id: delete_sec_context.c,v 1.11 1996/07/22 20:33:43 marc Exp $
 */

OM_uint32
krb5_gss_delete_sec_context(minor_status, context_handle, output_token)
     OM_uint32 *minor_status;
     gss_ctx_id_t *context_handle;
     gss_buffer_t output_token;
{
   krb5_context context;
   krb5_gss_ctx_id_rec *ctx;

   if (GSS_ERROR(kg_get_context(minor_status, &context)))
      return(GSS_S_FAILURE);

   if (output_token) {
      output_token->length = 0;
      output_token->value = NULL;
   }

   /*SUPPRESS 29*/
   if (*context_handle == GSS_C_NO_CONTEXT) {
      *minor_status = 0;
      return(GSS_S_COMPLETE);
   }

   /*SUPPRESS 29*/
   /* validate the context handle */
   if (! kg_validate_ctx_id(*context_handle)) {
      *minor_status = (OM_uint32) G_VALIDATE_FAILED;
      return(GSS_S_NO_CONTEXT);
   }

   /* construct a delete context token if necessary */

   if (output_token) {
      OM_uint32 major;
      gss_buffer_desc empty;
      empty.length = 0; empty.value = NULL;

      if (major = kg_seal(context, minor_status, *context_handle, 0,
			  GSS_C_QOP_DEFAULT,
			  &empty, NULL, output_token, KG_TOK_DEL_CTX))
	 return(major);
   }

   /* invalidate the context handle */

   (void)kg_delete_ctx_id(*context_handle);

   /* free all the context state */

   ctx = (gss_ctx_id_t) *context_handle;

   if (ctx->seqstate)
      g_order_free(&(ctx->seqstate));

   if (ctx->enc.processed)
      krb5_finish_key(context, &ctx->enc.eblock);
   krb5_free_keyblock(context, ctx->enc.key);

   if (ctx->seq.processed)
      krb5_finish_key(context, &ctx->seq.eblock);
   krb5_free_keyblock(context, ctx->seq.key);

   krb5_free_principal(context, ctx->here);
   krb5_free_principal(context, ctx->there);
   krb5_free_keyblock(context, ctx->subkey);

   if (ctx->auth_context)
       krb5_auth_con_free(context, ctx->auth_context);
   
   /* Zero out context */
   memset(ctx, 0, sizeof(*ctx));
   xfree(ctx);

   /* zero the handle itself */

   *context_handle = GSS_C_NO_CONTEXT;

   *minor_status = 0;
   return(GSS_S_COMPLETE);
}
