/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/srv/adb_free.c,v 1.1 1996/07/24 22:23:09 tlyu Exp $
 * 
 * $Log: adb_free.c,v $
 * Revision 1.1  1996/07/24 22:23:09  tlyu
 * 	* Makefile.in, configure.in: break out server lib into a
 * 		subdirectory
 *
 * Revision 1.8  1996/07/22 20:35:16  marc
 * this commit includes all the changes on the OV_9510_INTEGRATION and
 * OV_MERGE branches.  This includes, but is not limited to, the new openvision
 * admin system, and major changes to gssapi to add functionality, and bring
 * the implementation in line with rfc1964.  before committing, the
 * code was built and tested for netbsd and solaris.
 *
 * Revision 1.7.4.1  1996/07/18 03:08:07  marc
 * merged in changes from OV_9510_BP to OV_9510_FINAL1
 *
 * Revision 1.7.2.1  1996/06/20  02:16:25  marc
 * File added to the repository on a branch
 *
 * Revision 1.7  1996/05/12  06:21:57  marc
 * don't use <absolute paths> for "internal header files"
 *
 * Revision 1.6  1993/12/13  21:15:56  shanzer
 * fixed memory leak
 * .,
 *
 * Revision 1.5  1993/12/06  22:20:37  marc
 * fixup free functions to use xdr to free the underlying struct
 *
 * Revision 1.4  1993/11/15  00:29:46  shanzer
 * check to make sure pointers are somewhat vaid before freeing.
 *
 * Revision 1.3  1993/11/09  04:02:24  shanzer
 * added some includefiles
 * changed bzero to memset
 *
 * Revision 1.2  1993/11/04  01:54:24  shanzer
 * added rcs header ..
 *
 */

#if !defined(lint) && !defined(__CODECENTER__)
static char *rcsid = "$Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/srv/adb_free.c,v 1.1 1996/07/24 22:23:09 tlyu Exp $";
#endif

#include	"adb.h"
#include	<memory.h>
#include	<stdlib.h>
#ifdef HAVE_MALLOC_H
#include	<malloc.h>
#endif /* HAVE_MALLOC_H */

void
osa_free_princ_ent(osa_princ_ent_t val)
{
    XDR xdrs;

    xdrmem_create(&xdrs, NULL, 0, XDR_FREE);

    xdr_osa_princ_ent_rec(&xdrs, val);
    free(val);
}

void
osa_free_policy_ent(osa_policy_ent_t val)
{
    XDR xdrs;

    xdrmem_create(&xdrs, NULL, 0, XDR_FREE);

    xdr_osa_policy_ent_rec(&xdrs, val);
    free(val);
}

