/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/srv/server_misc.c,v 1.1 1996/07/24 22:23:29 tlyu Exp $
 */

#if !defined(lint) && !defined(__CODECENTER__)
static char *rcsid = "$Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/srv/server_misc.c,v 1.1 1996/07/24 22:23:29 tlyu Exp $";
#endif

#include    "k5-int.h"
#include    <krb5/kdb.h>
#include    <ctype.h>
#include    "adb.h"

/* for strcasecmp */
#include    <string.h>

#include    "server_internal.h"

kadm5_ret_t
adb_policy_init(kadm5_server_handle_t handle)
{
    osa_adb_ret_t   ret;
    if(handle->policy_db == (osa_adb_policy_t) NULL)
	if((ret = osa_adb_open_policy(&handle->policy_db,
				      &handle->params)) != OSA_ADB_OK)
	     return ret;
    return KADM5_OK;
}

kadm5_ret_t
adb_policy_close(kadm5_server_handle_t handle)
{
    osa_adb_ret_t   ret;
    if(handle->policy_db != (osa_adb_policy_t) NULL)
	if((ret = osa_adb_close_policy(handle->policy_db)) != OSA_ADB_OK)
	    return ret;
    handle->policy_db = NULL;
    return KADM5_OK;
}

/* some of this is stolen from gatekeeper ... */
kadm5_ret_t
passwd_check(kadm5_server_handle_t handle,
	     char *password, int use_policy, kadm5_policy_ent_t pol,
	     krb5_principal principal)
{
    int	    nupper = 0,
	    nlower = 0,
	    ndigit = 0, 
	    npunct = 0,
	    nspec = 0;
    char    c, *s;
    
    if(use_policy) {
	if(strlen(password) < pol->pw_min_length)
	    return KADM5_PASS_Q_TOOSHORT;
	s = password;
	while ((c = *s++)) {
	    if (islower(c)) {
		nlower = 1;
		continue;
	    }
	    else if (isupper(c)) {
		nupper = 1;
		continue;
	    } else if (isdigit(c)) {
		ndigit = 1;
		continue;
	    } else if (ispunct(c)) {
		npunct = 1;
		continue;
	    } else {
		nspec = 1;
		continue;
	    }
	}
	if ((nupper + nlower + ndigit + npunct + nspec) < pol->pw_min_classes) 
	    return KADM5_PASS_Q_CLASS;
	if((find_word(password) == KADM5_OK))
	    return KADM5_PASS_Q_DICT;
	else { 
	    char *cp;
	    int cpn;
	    int	c, n = krb5_princ_size(handle->context, principal);

	    cp = krb5_princ_realm(handle->context, principal)->data;
	    cpn = krb5_princ_realm(handle->context, principal)->length;

	    if (strncasecmp(cp, password, cpn) == 0)
		return KADM5_PASS_Q_DICT;
	    for (c = 0; c < n ; c++) {
		cp = krb5_princ_component(handle->context, principal, c)->data;
		cpn = krb5_princ_component(handle->context,
					   principal, c)->length;

		if (strncasecmp(cp, password, cpn) == 0)
		    return KADM5_PASS_Q_DICT;
	    }
	    return KADM5_OK;
	}
    } else {
	if (strlen(password) < 1)
	    return KADM5_PASS_Q_TOOSHORT;
    }
    return KADM5_OK;    
}
