#include <stdlib.h>
#include <krb5.h>
#include <tcl.h>
#include "context.h"

/* This string must be writeable!  The Tcl variable parsing may
   temporarily write into the "$krb5_path(tcllib)" sequence so it can
   get the two names as separate strings, to pass to GetVar2.  Bleah!

   It doesn't break on all platforms or compilers, but on those where
   it does, it should do so consistently.  */
static char init_string[] = "if [file exists $krb5_path(tcllib)/krb5_init.tcl] { source $krb5_path(tcllib)/krb5_init.tcl }\n";

int
Krb5tcl_Init (Tcl_Interp *interp)
{
    char buf[BUFSIZ];
    krb5tcl_context *tctx;
    ClientData cdata;

    tctx = (krb5tcl_context *) malloc (sizeof (krb5tcl_context));
    if (tctx == 0)
	abort ();
    cdata = (ClientData) tctx;

    tctx->magic = GOOD_MAGIC;
    tctx->interp = interp;
    tctx->refcount = 0;
    krb5_init_context (&tctx->ctx);
    krb5_init_ets (tctx->ctx);

    /* initialize sub-components */
    Tcl_kadm5_init (tctx);
    krb5tcl_init_profile (tctx);
    krb5tcl_init_misc (tctx);

    /* set simple variable */
#define SV(name,val) Tcl_SetVar(interp,name,val,TCL_GLOBAL_ONLY)
    /* set array variable */
#define SV2(name,idx,val) Tcl_SetVar2(interp,name,idx,val,TCL_GLOBAL_ONLY)
    /* set krb5_path array element */
#define SP(idx,val) SV2("krb5_path", idx, val)

    if (krb5_version)
	SV ("krb5_version", krb5_version);

    SP ("prefix", PREFIX);

    strcpy (buf, PREFIX);
    strcat (buf, "/lib/tcl");
    SP ("tcllib", buf);

    if (krb5_kt_default_name (tctx->ctx, buf, sizeof (buf)) == 0) {
	SP ("keytab", buf);
    }

    /* this is wrong for non-unix systems */
    SP ("profile", "/etc/krb5.conf");

    /* any tcl code to run at init time? */
    
    Tcl_Eval (interp, init_string);

    return TCL_OK;
}

void
krb5tcl_deref_ctx (ClientData cdata)
{
    krb5tcl_context *ctx = VERIFY_CTX (cdata);
    ctx->refcount--;
    if (ctx->refcount == 0) {
	ctx->magic = BAD_MAGIC;
	/* destroy any other state */
	free (ctx);
    }
}

void
krb5tcl_add_proc (const char *name, Tcl_CmdProc *proc, krb5tcl_context *ctx)
{
    VERIFY_CTX (ctx);
    Tcl_CreateCommand (ctx->interp, (char *) name, proc,
		       (ClientData) ctx, krb5tcl_deref_ctx);
    ctx->refcount++;
}
