/*
**	ssh_types.h	-- trying to have a universal types system
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_TYPES_H
#define __SSH_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*
**	Include the appropriate headers for sockets
*/
#ifdef WIN32

/*
**	include a socket header file for our initial build
**
**	please note that the reason this is not always included is
**	because applications may use another socket header.  it would
**	probably be a bad thing to include both.
**
**	for this reason, the application-specific headers would need
**	to define the SOCKET type before including the ssh headers
*/
#ifdef SSH_USE_WINSOCK2
#include <winsock2.h>
#endif /* SSH_USE_WINSOCK2 */

typedef SOCKET socket_type;		/* WinSock socket type */

#define USE_MY_BCOPY			/* use my_bcopy, my_bzero */

#else

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

typedef int socket_type;		/* normal socket type */

#endif /* WIN32 */

/*
**	Include Eric Young's SSLeay include files :)
*/
#include <idea.h>
#include <des.h>
#include <md5.h>
#include <rsa.h>
#include <bn.h>

/*
**	Now define our types "Posix"-ish types
*/

#ifdef WIN32
typedef unsigned char   uint8_t;        /* one byte, 8 bits */
typedef unsigned short  uint16_t;       /* two bytes, 16 bits */
typedef unsigned long   uint32_t;       /* four bytes, 32 bits */
#endif /* WIN32 */

#ifdef LINUX
typedef __u8 uint8_t;
typedef __u16 uint16_t;
typedef __u32 uint32_t;
#endif /* LINUX */

#ifdef HPUX
#endif /* HPUX */

#ifdef SUNOS
#include <pthread.h>
/*typedef short uint16_t;*/
#endif /* SUNOS */

/*
**	Finalize networksy things
*/
#ifndef INADDR_NONE
#define INADDR_NONE		(-1)
#endif

/*
**	define common return values
*/
#define S_BAD			1	/* error occured, make -1 */
#define S_GOOD			0	/* no error occured */

/*
**	Use other necessary types
*/
#include "ssh_mp_int.h"

/*
**	#defines for cipher initialization vector lengths
*/
#define IDEA_IV_LEN		8	/* IDEA initialization vector len */

/*
**	Structure to hold data for IDEA encryption
*/
struct idea_values_struct
{
	int en_num;		/* offset into 64bits fr encode */
	int de_num;		/* offset into 64bits fr decode */
	unsigned char encode_iv[IDEA_IV_LEN];	/* encoding init vector */
	unsigned char decode_iv[IDEA_IV_LEN];	/* decoding init vector */
	IDEA_KEY_SCHEDULE key;			/* encryption key */
};

/*
**	Structure to hold data for 3DES encryption
*/
struct des3_values_struct
{
	des_cblock iv_encrypt_1;	/* initialization vertor (enc) */
	des_cblock iv_encrypt_2;	/* 2nd enc initialization vector */
	des_cblock iv_encrypt_3;	/* 3d enc initialization vector */
	des_cblock iv_decrypt_1;	/* init vertor (decrypt) */
	des_cblock iv_decrypt_2;	/* 2nd decrypt init vector */
	des_cblock iv_decrypt_3;	/* 3d decrypt init vector */
	des_key_schedule key_1;		/* First DES key */
	des_key_schedule key_2;		/* Second DES key */
	des_key_schedule key_3;		/* Third DES key */
};

/*
**	Structure to hold data for DES encryption
*/
struct des_values_struct
{
	des_cblock iv_encrypt;		/* encryption init vector */
	des_cblock iv_decrypt;		/* decryption init vector */
	des_key_schedule key;		/* DES key */
};

/*
**	Define a union to house all our encipherment "stuff"
*/
union ssh_cipher_union
{
	struct idea_values_struct idea_values;	/* IDEA cipher information */
	struct des3_values_struct des3_values;	/* triple-DES information */
	struct des_values_struct des_values;	/* DES information */
};

/*
**	Define a type for functions to display debug information
*/
typedef int (*SSHDebugPrinter)(char * category, char * body);

/*
**	Define a structure to hold information on debugging
**	(print function, ..)
*/
struct ssh_debug_struct
{
	SSHDebugPrinter print_debug;		/* print debugging info */
	int debug_flag;				/* do we do debugging */
};

/*
**	Define a structure to hold all our connection information
*/
struct ssh_struct
{
	socket_type sockfd;			/* socket to remote host */

	uint8_t cipher_type;			/* chosen cipher method */
	union ssh_cipher_union cipher_data;	/* encipherment information */

	struct ssh_debug_struct debug_info;	/* information on debugging */
};

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_TYPES_H */

