/*
**	ssh_prepare.h	-- handles preparing the ssh connection
**		(after authentication but before interactive session)
**
**	Copyright 1997, 1998 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_PREPREPARE_H
#define __SSH_PREPREPARE_H

#include "ssh.h"
#include "ssh_types.h"

/*
**	partial return types for compression request
*/
#define SSH_COMPRESSION_STARTED		S_GOOD
#define SSH_COMPRESSION_NOT_STARTED	-1

#ifdef __cplusplus
extern "C" {
#endif

/*
**	request compression
*/
int ssh_request_compression(socket_type sockfd, struct ssh_struct * ssh_info,
	uint32_t level);

/*
**	request a pty
*/
int ssh_request_pty(socket_type sockfd, struct ssh_struct * ssh_info,
	const char * terminal_type, uint32_t height, uint32_t width,
	uint32_t x_pixels, uint32_t y_pixels, const uint8_t * tty_modes,
	int tty_mode_len);

/*
**	request a shell (switch to interactive process)
*/
int ssh_request_exec_shell(socket_type sockfd, struct ssh_struct * ssh_info);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_PREPREPARE_H */

