/*
 * writev
 *
 * Replacement for writev system call.
 *
 * I think this works the way it should :-?
 *
 * John W. Eaton
 * jwe@che.utexas.edu
 * Department of Chemical Engineering
 * The University of Texas at Austin
 */

#include <sys/types.h>
#include <sys/uio.h>

int
writev (fd, iov, ioveclen)
     register int fd;
     register struct iovec *iov;
     register int ioveclen;
{
  register int i;
  register int status;

  for (i = 0; i < ioveclen; i++)
    {
      if ((status = write (fd, iov->iov_base, iov->iov_len)) == -1)
	{
	  perror ("writev");
	  return status;
	}
      iov++;
    }
  return 0;
}
