/* IsOn's config.h */

/* Change what you like.  Everything is surrounded in #ifndef blocks,
 * so you can just add them to the command line if you like, such
 * as -DBEEP=0.  Note that you should not comment out the whole #define
 * line.  The code uses #if's and not #ifdef's so just change a 1 to a
 * 0, etc., instead of #undef'ing the symbol.
 *
 * After browsing this whole file, and making the changes needed for your
 * system, it should compile cleanly.  If not, re-edit this file, and
 * make sure you have your compiler and flags set up correctly in the
 * Makefile.
 */

/* Define this 1 if you want to use RPC's rusers() call (highly
 * recommended).  Otherwise 0.
 */
#ifndef RPC
#define RPC 1	/* 1 or 0 */
#endif

/* For best results, define FINGER to the full path leading to your
 * finger executable.  If you don't, we'll have to hope that the path
 * is in the user's PATH.
 */
#ifndef FINGER
#define FINGER "finger"
#endif

/* If you define DAEMON to be 1, then by default, ison is a daemon,
 * and the user must use -j to prevent ison from going into the back-
 * ground by default.  If you define DAEMON to 0, then the user must
 * supply -j to have ison go into the background by itself, and runs
 * as a normal program.
 */
#ifndef DAEMON
#define DAEMON 1				/* Daemon by default? (1 or 0) */
#endif

/* Do you want ison processes to nice themselves?
 * I recommend it, since ison is usually a less important process.
 */
#ifndef NICE
#define NICE 1		/* 1 or 0 */
#endif

/* Do you mind if the program uses ^G's by default to get your attention?
 * The user can use -b to not do the default of what you choose here. */
#ifndef BEEP
#define BEEP 1		/* 1 or 0 */
#endif

/* Do you have strchr()?  More than likely you do, unless you're running
 * an older BSD system that still only has index() (the BSD equivalent)
 * and not strchr too
 */
#ifndef HAVE_STRCHR
#define HAVE_STRCHR 1
#endif

/* You should only define this to 0 if you don't have the strstr()
 * call.  We can do without it, but you won't be able to detect
 * the idle time when using Finger.
 */
#ifndef HAVE_STRSTR
#define HAVE_STRSTR 1	/* 1 or 0 */
#endif

/* Similarly, if you don't have both strftime() AND localtime()
 * stick a 0 here.  We can work around this too.
 */
#ifndef HAVE_STRFTIME
#define HAVE_STRFTIME 1
#endif

/* Do you have <stdlib.h>?  Most recent systems do. */
#ifndef HAVE_STDLIBH
#define HAVE_STDLIBH 1
#endif

/* Similarly, do you have <stdarg.h>?  If you define HAVE_STDARGH to 0,
 * we'll try <varargs.h> instead.  Older versions of SunOS will need
 * <varargs.h>
 */
#ifndef HAVE_STDARGH
#define HAVE_STDARGH 1
#endif

/* You can enable some extra debugging messages if you set this to
 * 1, or save a few bytes and leave it 0.
 */
#ifndef DEBUG
#define DEBUG 0		/* 0 or 1 */
#endif

/* These are the two checks ison tries to see if you've logged off so ison
 * can kill itself.  I usually use both of them, but if one or both don't
 * work correctly use undef here.
 */
#ifndef CHECK_PARENT
#define CHECK_PARENT	1	/* (1 or 0) check to see if our parent is alive */
#endif

#ifndef CHECK_STDERR
#define CHECK_STDERR 1	/* (1 or 0) check to see if stderr is a tty */
#endif

#ifndef DEFAULT_LOCAL_SLEEP
#define DEFAULT_LOCAL_SLEEP 10   /* seconds to sleep between Utmp()'s */
#endif

#ifndef DEFAULT_REMOTE_SLEEP
#define DEFAULT_REMOTE_SLEEP 45  /* secs to sleep between Finger/RUsers */
#endif

/* You can put an actual number for this one, but I recommend leaving
 * it a -1L.  This way it will poll forever until you logoff, it finds
 * everyone, or the user supplies the max iterations.
 */
#ifndef MAXITER
#define MAXITER (-1L)			/* Default is -1L */
#endif

/* You can define a default command, but I don't recommend it.  This
 * command will be executed each time a user is found, unless the
 * user who ran the program supplied their own command instead.
 */
#ifndef COMMAND
#define COMMAND NULL			/* Default is NULL */
#endif

/* If you're debugging the program (then you're probably me), you
 * may want to use a debugging malloc library to help out.
 */
#ifndef DBMALLOC
#define DBMALLOC 0	/* (0 or 1) Linking w/ a debugging malloc library? */
#endif

/* eof config.h */
