/* ison.h */

#define VERSION_STR "Version 5.0 (December 7, 1993)"

/* IsOn is Copyright 1990-1994 by NCEMRSoft. */

#define SZ(expr) ((size_t) (expr))

/* Various ways to tweak PrintF(): */
#define DEBUG_MSG       001
#define NO_HEADER_MSG   002
#define NO_BEEP_MSG     004
#define FLUSH_MSG       010

/* Arbitrary "hostname" for this machine.  But it usually works if you use
 * it as a hostname anyway.
 */
#define ISLOCALHOST "localhost"	

#define NOT_IDLE (0)   /* User is active, and has no idletime. */
#define IDLETIME_UNKNOWN (-1)  /* We can't determine if idle or not. */
#define IS_IDLE (-2)   /* User is idle, but don't know exact #minutes. */

/* This is used to tell the program there is no maximum number of
 * iterations.
 */
#define NO_LIMIT (-1L)

/* You can have comment lines in the data file.  Lines starting with
 * this character are skipped.
 */
#define COMMENT_CHAR '#'

/* Return codes for exit(): */
#define EXIT_SUCCESSFUL				0
#define EXIT_MAX_ITERATIONS			1
#define EXIT_NOT_LOGGED_IN			2
#define EXIT_USAGE					3
#define EXIT_PARENT					4
#define EXIT_FATAL_ERROR			(-1)

#ifndef UTMP_FILE					  /* Most define this in utmp.h;  SunOS
									   * 4.1.1 doesn't. */
#   define UTMP_FILE "/etc/utmp"
#endif

#ifndef INDEX
#   if HAVE_STRCHR
#       define INDEX strchr			/* ANSI, System V */
#       define RINDEX strrchr
#   else
#       define INDEX index			/* BSD */
#       define RINDEX rindex
#   endif
#endif

#define DONEWITHHOST(hp) hp->usersDone = hp->nUsers
#define CALLOC1(siz) calloc((size_t)1, siz)

typedef struct User *UserPtr;
typedef struct User {
	UserPtr next;
	int idlemsg;			/* Only say this user is idle one time. */
	time_t tyme;			/* This user's login date, if we know it. */
	int idletime;			/* Idle time of user, in minutes (maybe). */
	int wasOn;				/* If the user was on before the current iter. */
	int wasIdle;			/* If user was idle for current iter. */
	int isOn;				/* If this user is on for the current iter. */
	int logons;				/* Mostly for debugging. */
	int pollUntilActive;	/* Wait until user is not idle? */
	int detectLogoffs;		/* Monitor logoffs too? */
	char *cmd;				/* What to do if this person is on. */
	char username[12];		/* This user's login name. */
	char dev[12];			/* This user's tty. */
	char idlestr[8];		/* only used by Finger. */
} User;

typedef struct Host *HostPtr;

/* This may cause some compilation problems :-( */
#ifdef ansi
typedef void (*pollproc_t)(IsonParams *g, HostPtr hp);
#else
typedef int (*pollproc_t)();
#endif

typedef struct Host {
	HostPtr next;
	char *hostname;			/* FQDN name of the this host, if remote. */
	pollproc_t pollproc;	/* Which polling routine in use. */
	UserPtr firstUser;		/* List of users on this machine to look for. */
	UserPtr lastUser;
	size_t nUsers;			/* Number of users in list. */
	size_t usersDone;		/* Number we've detected already. */
	int idleCol;			/* For Finger();  where to look for idle time. */
	int ttyCol;				/* Same, but for the TTY. */
} Host;

/* This program started out by not using any global variables.  I kept
 * the tradition alive by using this trick.  We keep one of the following
 * structures on the stack, and then pass a pointer to it around to the
 * various sub-routines.  That way this program is re-entrant if you
 * know how to compile it that way.  Of course the tradeoff is that there
 * are going to be plenty of extra pointer dereferences.
 */
typedef struct IsonParams {
	FILE *outfile;			/* Stream to print messages on. */
	char *progname;			/* Short name of this program. */
	long maxIters;			/* An upperbound, if any, on iterations. */
	long iter;				/* The current iteration number. */
	int sleep;				/* How long to delay between iterations. */
	int daemon;				/* Are we a background process? */
	int debug;				/* Printing diagnostic output? */
	int canBeep;			/* Printing ^G's with important messages? */
	int memInUse;			/* Dynamic memory in use; used to detect leaks. */
	int pid;				/* PID of this process. */
	int parentPid;			/* The parent PID of ison. */
	int stdinatty;			/* Were we run from a shell script? */
	int pollmsg;			/* Print startup message? */
	int autodie;			/* exit() when you logoff? */
	int detectLogoffs;		/* Staying on, reporting log ons/offs? */
	FILE *utmpfp;			/* Used by Utmp() for localhost's utmp file. */
	int nHosts;				/* How many hosts we're polling. */
	int nRemoteHosts;		/* How many of them are remote, if any. */
	int hostsDone;			/* How many are totally finished. */
	HostPtr firstHost;		/* The host list. */
	HostPtr lastHost;
} IsonParams;

extern int optind;			/* getopt() stuff */
extern char *optarg;

extern int errno;

#if defined(__STDC__) || defined(__cplusplus) || defined(__EXTENSIONS__)
#define Pr(s) s
#define ansi 1
#include <unistd.h>	/* just for prototypes... can be omitted. */
#ifndef __EXTENSIONS__
extern FILE *   popen(const char *, const char *);
#endif
#else
#define Pr(s) ()
#define ansi 0
extern FILE *popen();
#endif

/* Function prototypes... */
int Strncasecmp Pr((char *a, char *b, size_t n));
void DoneWithUser Pr((IsonParams *g, HostPtr hp, UserPtr up));
void RunCommand Pr((HostPtr hp, UserPtr up));
void MakeSureIAmLoggedIn Pr((IsonParams *g));
char *UserAddress Pr((char *buf, HostPtr hp, UserPtr up));
char *TimeStr Pr((char *buf, size_t siz, time_t t));
void Delay Pr((IsonParams *g));
void IterationDebugMsg Pr((IsonParams *g, char *whichproc, HostPtr hp));
void UserIsIdle Pr((IsonParams *g, HostPtr hp, UserPtr up));
void Utmp Pr((IsonParams *g, HostPtr hp));
void Finger Pr((IsonParams *g, HostPtr hp));
void RUsers Pr((IsonParams *g, HostPtr hp));
int AddUser Pr((IsonParams *g, char *username, int F, int noIdle, int mon, char *cmd));
void Poll Pr((IsonParams *g));
void ReadDataFile Pr((IsonParams *g, char *fname));
void Usage Pr((IsonParams *g));

/* eof ison.h */
