/*
 *  rdisc.h,v 1.2.2.1 1995/01/10 13:35:37 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */

#define	RDISC_DOING_OFF		0
#define	RDISC_DOING_SERVER	1
#define	RDISC_DOING_CLIENT	2

/* Server stuff */
#define RDISC_MAX_INITIAL_ADVERT_INTERVAL 	16	/* seconds */
#define RDISC_MAX_INITIAL_ADVERTISEMENTS	3	/* transmissions */
#define RDISC_MAX_RESPONSE_DELAY		2	/* seconds */
#define RDISC_MAX_ADINTERVAL_DEFAULT 		600

#define RDISC_CONFIG_MAXADVINT  1
#define RDISC_CONFIG_MINADVINT  2
#define RDISC_CONFIG_LIFETIME   3
#define RDISC_CONFIG_MAX        4

#define RDISC_CONFIG_IFA_IGNORE     1
#define RDISC_CONFIG_IFA_BROADCAST  2
#define RDISC_CONFIG_IFA_PREFERENCE 3
#define RDISC_IFA_CONFIG_MAX        4

/* Client stuff */
#define	RDISC_MAX_SOLICITATION_DELAY	1	/* seconds */
#define	RDISC_SOLICITATION_INTERVAL	3	/* interval */
#define	RDISC_MAX_SOLICITATIONS		3

#define	RDISC_CONFIG_CLIENT_DISABLE	1
#define	RDISC_CONFIG_CLIENT_BROADCAST	2
#define	RDISC_CONFIG_CLIENT_QUIET	3
#define	RDISC_CONFIG_CLIENT_MAX		4


#define	RDISC_LIFETIME_MIN	3
#define	RDISC_LIFETIME_MAX	9000

#define RDISC_LIMIT_MAXADVINT   4, 1800
#define RDISC_LIMIT_MINADVINT   3, 1800
#define RDISC_LIMIT_LIFETIME    RDISC_LIFETIME_MIN, RDISC_LIFETIME_MAX
#define RDISC_LIMIT_PREFERENCE  (u_int) 0x80000000, 0x7fffffff

#define RDISC_PREFERENCE_INELIGIBLE     0x80000000
#define	RDISC_PREFERENCE_DEFAULT	0

extern int doing_rdisc;
extern const bits rdisc_trace_types[];
extern trace *rdisc_trace_options;
extern adv_entry *rdisc_server_address_policy;
extern adv_entry *rdisc_interface_policy;
extern pref_t rdisc_client_preference;

PROTOTYPE(rdisc_init,
	  extern void,
	  (void));

PROTOTYPE(rdisc_var_init,
	  extern void,
	  (void));
	  
/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
