package gnu.xml.validation.datatype;

/**
 * Abstract base class for XML Schema datatypes.
 * @see http://www.w3.org/TR/xmlschema-2/
 *
 * @author <a href='mailto:dog@gnu.org'>Chris Burdess</a>
 */
public abstract class Type
{

  public static final Type ANY_TYPE = new AnyType();

  public static final SimpleType ANY_SIMPLE_TYPE = new AnySimpleType();

  public static final SimpleType STRING = new StringType();

  public static final SimpleType BOOLEAN = new BooleanType();

  // TODO
  
  /**
   * The name of this type.
   */
  public final QName name;

  public Type(QName name)
  {
    this.name = name;
  }
  
}

