#!/usr/bin/env python

from gnuradio import gr
from gnuradio import usrp
from gnuradio.eng_option import eng_option
from optparse import OptionParser

def main ():
    parser = OptionParser (option_class=eng_option)
    parser.add_option ("-d", "--decim", type="eng_float", default=16,
                       help="set fgpa decimation rate to DECIM")
    parser.add_option ("-c", "--cordic-freq", type="eng_float", default=0,
                       help="set Rx cordic frequency to FREQ", metavar="FREQ")
    parser.add_option ("-o", "--output-file", default="usrp_rx.dat",
                       help="write data to FILE", metavar="FILE")
    (options, args) = parser.parse_args ()

    fg = gr.flow_graph ()
    u = usrp.source_s (0, options.decim)
    u.set_rx_freq (0, options.cordic_freq)
    dst = gr.file_sink (gr.sizeof_short, options.output_file)
    fg.connect (u, dst)
    
    fg.start ()
    print 'USB sample rate = %g' % (u.adc_freq () / u.decim_rate (),)
    raw_input ('Press Enter to quit: ')
    fg.stop ()


if __name__ == '__main__':
    main ()

