/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
 

/*******************************************************************/
/*                                                                 */
/*  HEADER for cfd - Not generically includable!                   */
/*                                                                 */
/*******************************************************************/

extern FILE *yyin;

#define queuesize 20
#define connection 1
#define CFD_INPUT "cfd.conf"

/**********************************************************************/

char *COMMANDS[] =
   {
   "EXEC",
   "AUTH",
   "GET",
   "OPENDIR",
   "SYNCH",
   "CLASSES",
   "MD5",
   NULL
   };

enum COMMS
   {
   cfd_exec,
   cfd_auth,
   cfd_get,
   cfd_opendir,
   cfd_synch,
   cfd_classes,
   cfd_md5,
   cfd_bad
   };

struct cfd_connection
   {
   int id_verified;
   int synchronized;
   int sd_recv;
   int sd_reply;
   char *hostname;
   };

struct cfd_thread_arg
   {
   int sd_reply;
   char *replybuff;
   char *replyfile;
   };

/*******************************************************************/
/* GLOBAL VARIABLES                                                */
/*******************************************************************/

int CLOCK_DRIFT = 100;

int *SHM_DAEMON_COUNT; /* Shared memory pointer */

struct option CFDOPTIONS[] =
   {
   { "help",no_argument,0,'h' },
   { "debug",optional_argument,0,'d' }, 
   { "verbose",no_argument,0,'v' },
   { "no-fork",no_argument,0,'F' },
   { "parse-only",no_argument,0,'p'},
   { NULL,0,0,0 }
   };

/*******************************************************************/
/* PARSER                                                          */
/*******************************************************************/

char CURRENTPATH[bufsize];
char CFRUNCOMMAND[bufsize];
char CHECKSUMDB[bufsize];

int CFD_MAXPROCESSES = 0;
int NO_FORK = false;

#ifdef RE_DUP_MAX
# undef RE_DUP_MAX
#endif
