
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <CDM_Document.hxx>
#include <CDM_Application.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <CDM_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BinLDrivers.hxx>
#include <BinLDrivers_DocumentRetrievalDriver.hxx>
#include <BinLDrivers_DocumentSection.hxx>
#include <BinLDrivers_DocumentStorageDriver.hxx>
#include <BinLDrivers_Marker.hxx>
#include <BinLDrivers_VectorOfDocumentSection.hxx>

// template related includes

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <PCDM_ReaderFilter.hxx>

// Module definiiton
void register_BinLDrivers_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BinLDrivers", R"#()#");

// user-defined inclusion per module in the body

// enums
    py::enum_<BinLDrivers_Marker>(m, "BinLDrivers_Marker",R"#(None)#")
        .value("BinLDrivers_ENDATTRLIST",BinLDrivers_Marker::BinLDrivers_ENDATTRLIST)
        .value("BinLDrivers_ENDLABEL",BinLDrivers_Marker::BinLDrivers_ENDLABEL).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BinLDrivers , shared_ptr<BinLDrivers>  >(m,"BinLDrivers",R"#(None)#");
    py::class_<BinLDrivers_DocumentSection , shared_ptr<BinLDrivers_DocumentSection>  >(m,"BinLDrivers_DocumentSection",R"#(More or less independent part of the saved/restored document that is distinct from OCAF data themselves but may be referred by them.)#");
    py::class_<BinLDrivers_DocumentRetrievalDriver ,opencascade::handle<BinLDrivers_DocumentRetrievalDriver>  , PCDM_RetrievalDriver >(m,"BinLDrivers_DocumentRetrievalDriver",R"#()#");
    py::class_<BinLDrivers_DocumentStorageDriver ,opencascade::handle<BinLDrivers_DocumentStorageDriver>  , PCDM_StorageDriver >(m,"BinLDrivers_DocumentStorageDriver",R"#(persistent implementation of storage a document in a binary filepersistent implementation of storage a document in a binary filepersistent implementation of storage a document in a binary file)#");
    preregister_template_NCollection_Vector<BinLDrivers_DocumentSection>(m,"BinLDrivers_VectorOfDocumentSection");

};

// user-defined post-inclusion per module

// user-defined post
