
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtk_Interface.hxx>
#include <IVtk_IShape.hxx>
#include <IVtk_IShapeData.hxx>
#include <IVtk_IShapeMesher.hxx>
#include <IVtk_IView.hxx>
#include <IVtk_Types.hxx>

// template related includes

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IVtk_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IVtk", R"#()#");

// user-defined inclusion per module in the body

// enums
    py::enum_<IVtk_SelectionMode>(m, "IVtk_SelectionMode",R"#(Enumeration that describes all supported selection modes for 3D shapes. SM_None means that the shape should become non-selectable. SM_Shape makes the shape selectable as a whole. Other modes activate selection of sub-shapes of corresponding types.)#")
        .value("SM_None",IVtk_SelectionMode::SM_None)
        .value("SM_Shape",IVtk_SelectionMode::SM_Shape)
        .value("SM_Vertex",IVtk_SelectionMode::SM_Vertex)
        .value("SM_Edge",IVtk_SelectionMode::SM_Edge)
        .value("SM_Wire",IVtk_SelectionMode::SM_Wire)
        .value("SM_Face",IVtk_SelectionMode::SM_Face)
        .value("SM_Shell",IVtk_SelectionMode::SM_Shell)
        .value("SM_Solid",IVtk_SelectionMode::SM_Solid)
        .value("SM_CompSolid",IVtk_SelectionMode::SM_CompSolid)
        .value("SM_Compound",IVtk_SelectionMode::SM_Compound).export_values();
    py::enum_<IVtk_MeshType>(m, "IVtk_MeshType",R"#(Enumeration that describes all supported types of mesh parts for 3D shapes.)#")
        .value("MT_Undefined",IVtk_MeshType::MT_Undefined)
        .value("MT_IsoLine",IVtk_MeshType::MT_IsoLine)
        .value("MT_FreeVertex",IVtk_MeshType::MT_FreeVertex)
        .value("MT_SharedVertex",IVtk_MeshType::MT_SharedVertex)
        .value("MT_FreeEdge",IVtk_MeshType::MT_FreeEdge)
        .value("MT_BoundaryEdge",IVtk_MeshType::MT_BoundaryEdge)
        .value("MT_SharedEdge",IVtk_MeshType::MT_SharedEdge)
        .value("MT_WireFrameFace",IVtk_MeshType::MT_WireFrameFace)
        .value("MT_ShadedFace",IVtk_MeshType::MT_ShadedFace)
        .value("MT_SeamEdge",IVtk_MeshType::MT_SeamEdge).export_values();
    py::enum_<IVtk_DisplayMode>(m, "IVtk_DisplayMode",R"#(Enumeration that describes all supported display modes for 3D shapes.)#")
        .value("DM_Wireframe",IVtk_DisplayMode::DM_Wireframe)
        .value("DM_Shading",IVtk_DisplayMode::DM_Shading).export_values();

//Python trampoline classes
    class Py_IVtk_IShape : public IVtk_IShape{
    public:
        using IVtk_IShape::IVtk_IShape;


        // public pure virtual
        IVtk_ShapeIdList GetSubIds(const IVtk_IdType theId) const  override { PYBIND11_OVERLOAD_PURE(IVtk_ShapeIdList,IVtk_IShape,GetSubIds,theId) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IVtk_IShapeData : public IVtk_IShapeData{
    public:
        using IVtk_IShapeData::IVtk_IShapeData;


        // public pure virtual
        IVtk_PointId InsertPoint(const gp_Pnt & thePnt,const NCollection_Vec3<float> & theNorm) override { PYBIND11_OVERLOAD_PURE(IVtk_PointId,IVtk_IShapeData,InsertPoint,thePnt,theNorm) };
        void InsertVertex(const IVtk_IdType theShapeID,const IVtk_PointId thePointId,const IVtk_MeshType theMeshType) override { PYBIND11_OVERLOAD_PURE(void,IVtk_IShapeData,InsertVertex,theShapeID,thePointId,theMeshType) };
        void InsertLine(const IVtk_IdType theShapeID,const IVtk_PointId thePointId1,const IVtk_PointId thePointId2,const IVtk_MeshType theMeshType) override { PYBIND11_OVERLOAD_PURE(void,IVtk_IShapeData,InsertLine,theShapeID,thePointId1,thePointId2,theMeshType) };
        void InsertLine(const IVtk_IdType theShapeID, const NCollection_List<IVtk_PointId> * thePointIds,const IVtk_MeshType theMeshType) override { PYBIND11_OVERLOAD_PURE(void,IVtk_IShapeData,InsertLine,theShapeID,thePointIds,theMeshType) };
        void InsertTriangle(const IVtk_IdType theShapeID,const IVtk_PointId thePointId1,const IVtk_PointId thePointId2,const IVtk_PointId thePointId3,const IVtk_MeshType theMeshType) override { PYBIND11_OVERLOAD_PURE(void,IVtk_IShapeData,InsertTriangle,theShapeID,thePointId1,thePointId2,thePointId3,theMeshType) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IVtk_IShapeMesher : public IVtk_IShapeMesher{
    public:
        using IVtk_IShapeMesher::IVtk_IShapeMesher;


        // public pure virtual


        // protected pure virtual
        void internalBuild() override { PYBIND11_OVERLOAD_PURE(void,IVtk_IShapeMesher,internalBuild,) };


        // private pure virtual

    };
    class Py_IVtk_IView : public IVtk_IView{
    public:
        using IVtk_IView::IVtk_IView;


        // public pure virtual
        bool IsPerspective() const  override { PYBIND11_OVERLOAD_PURE(bool,IVtk_IView,IsPerspective,) };
        double GetDistance() const  override { PYBIND11_OVERLOAD_PURE(double,IVtk_IView,GetDistance,) };
        void GetEyePosition(double & theX,double & theY,double & theZ) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetEyePosition,theX,theY,theZ) };
        void GetPosition(double & theX,double & theY,double & theZ) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetPosition,theX,theY,theZ) };
        void GetViewUp(double & theDx,double & theDy,double & theDz) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetViewUp,theDx,theDy,theDz) };
        void GetDirectionOfProjection(double & theDx,double & theDy,double & theDz) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetDirectionOfProjection,theDx,theDy,theDz) };
        void GetScale(double & theX,double & theY,double & theZ) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetScale,theX,theY,theZ) };
        double GetParallelScale() const  override { PYBIND11_OVERLOAD_PURE(double,IVtk_IView,GetParallelScale,) };
        double GetViewAngle() const  override { PYBIND11_OVERLOAD_PURE(double,IVtk_IView,GetViewAngle,) };
        void GetClippingRange(double & theZNear,double & theZFar) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetClippingRange,theZNear,theZFar) };
        double GetAspectRatio() const  override { PYBIND11_OVERLOAD_PURE(double,IVtk_IView,GetAspectRatio,) };
        void GetViewCenter(double & theX,double & theY) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetViewCenter,theX,theY) };
        void GetWindowSize(int & theX,int & theY) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetWindowSize,theX,theY) };
        bool DisplayToWorld(const gp_XY & theDisplayPnt,gp_XYZ & theWorldPnt) const  override { PYBIND11_OVERLOAD_PURE(bool,IVtk_IView,DisplayToWorld,theDisplayPnt,theWorldPnt) };
        void GetCamera(NCollection_Mat4<Standard_Real> & theProj,NCollection_Mat4<Standard_Real> & theOrient,Standard_Boolean & theIsOrtho) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetCamera,theProj,theOrient,theIsOrtho) };
        void GetViewport(Standard_Real & theX,Standard_Real & theY,Standard_Real & theWidth,Standard_Real & theHeight) const  override { PYBIND11_OVERLOAD_PURE(void,IVtk_IView,GetViewport,theX,theY,theWidth,theHeight) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    preregister_template_NCollection_Map<IVtk_IdType>(m,"IVtk_IdTypeMap");
    py::class_<IVtk_Interface ,opencascade::handle<IVtk_Interface>  , Standard_Transient >(m,"IVtk_Interface",R"#(Base interface for visualisation component.Base interface for visualisation component.Base interface for visualisation component.)#");
    preregister_template_NCollection_List<gp_XY>(m,"IVtk_Pnt2dList");
    preregister_template_NCollection_List<IVtk_SelectionMode>(m,"IVtk_SelectionModeList");
    preregister_template_NCollection_List<IVtk_IdType>(m,"IVtk_ShapeIdList");
    preregister_template_NCollection_List<IVtk_IShape::Handle>(m,"IVtk_ShapePtrList");
    py::class_<IVtk_IShape ,opencascade::handle<IVtk_IShape> ,Py_IVtk_IShape , IVtk_Interface >(m,"IVtk_IShape",R"#(Interface for working with a shape and its sub-shapes ids.Interface for working with a shape and its sub-shapes ids.Interface for working with a shape and its sub-shapes ids.)#");
    py::class_<IVtk_IShapeData ,opencascade::handle<IVtk_IShapeData> ,Py_IVtk_IShapeData , IVtk_Interface >(m,"IVtk_IShapeData",R"#(Interface for working with triangulated data.Interface for working with triangulated data.)#");
    py::class_<IVtk_IShapeMesher ,opencascade::handle<IVtk_IShapeMesher> ,Py_IVtk_IShapeMesher , IVtk_Interface >(m,"IVtk_IShapeMesher",R"#(Interface for triangulator of 3D shapes.Interface for triangulator of 3D shapes.Interface for triangulator of 3D shapes.)#");
    py::class_<IVtk_IView ,opencascade::handle<IVtk_IView> ,Py_IVtk_IView , IVtk_Interface >(m,"IVtk_IView",R"#(Interface for obtaining view transformation parameters.Interface for obtaining view transformation parameters.Interface for obtaining view transformation parameters.)#");
    preregister_template_NCollection_DataMap<IVtk_IdType, IVtk_ShapeIdList>(m,"IVtk_SubShapeMap");

};

// user-defined post-inclusion per module

// user-defined post
