/*
-- ----------------------------------------------------------------------------
--
--     Object Name : version.h
--     Revision    : 1
--
--     Copyright INMOS Limited, 1987, 1988.
--     All Rights Reserved.
--
--     DESCRIPTION
--         Afserver host and version specific global constant definitions.
--
--     NOTES
--         This module should be changed if porting to a new host or transputer
--         board.
--
--     HISTORY
--         12-Apr-1988    Antony King    Added this comment.
--         20-Apr-1988    Antony King    Last change.
--
-- ----------------------------------------------------------------------------
*/

/* System include files used by the afserver */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

/* Afserver version definitions */

#define HOST_MASK    0xffff0000l
#define VERSION_MASK 0x0000ffffl

#define DAY_MASK     0xff000000l
#define MONTH_MASK   0x00ff0000l
#define YEAR_MASK    0x0000ffffl

#define IBM_HOST        0x00000000l
#define NEC_HOST        0x01000000l
#define VAX_ROM_HOST    0x02000000l
#define SUN3_B011_HOST  0x03000000l
#define SUN3_NICHE_HOST 0x03010000l

#define VERS_NUMB  0x00000105l | IBM_HOST  /* V1.5 and IBM running DOS */
#define VERS_DATE  0x13051358l             /* 19th May 1988 */

#define VERSION_STRING   "Afserver (IBM) V1.5.2 (19th May 1988) - ported to Linux\n"
#define COPYRIGHT_STRING "Copyright INMOS Limited, 1985, 1986, 1987, 1988, ChN 1993\n"

/* Open modes for text and binary files */

#define OPEN_READ_BINARY "rb"
#define OPEN_WRITE_TEXT  "wt"

/* Default value for returning via exit function */

#define DEF_RESULT 0

/* Value exited with when Cnrtl-C used to exit server or if error flag set */

#define EXIT_ABORT 42

/* Enable Compiler Parameter Checking */

#define LINT_ARGS 1

/* Modes for opening a file in */

#define OPEN_TYPES { { { "rb",  "rt"  }, { "rb",  "rt" } }, \
                     { { "r+b", "r+t" }, { "wb",  "wt" } }, \
                     { { "r+b", "r+t" }, { "w+b", "w+t"} }  };

/*
-- ----------------------------------------------------------------------------
-- The following compilation flags may be used:
--
-- REV_A_FIX - if defined, casues the server, when communicating with the links
--             to change the number of bytes sent or received. If a single byte
--             is to be sent (or received) indicating a byte value then 4 bytes
--             are sent (or received). If the byte to be sent (or received) is
--             a slice of length 1 then the 2 bytes are sent (or received).
--
-- IBMserver - if defined, inserts code to test which IBM PC the server is
--             running on, and sets up the link adaptor addresses appropriately
--
-- NECserver - if defined, inserts code to set up the link adaptor addresses
--             for the NEC PC.
--
-- quickIO   - if defined, does not generate code for the 'C' versions of the
--             link driving procs - the assembly module quickio.asm must then
--             be linked in with the C.
-- ----------------------------------------------------------------------------
*/

#define IBMserver

/* IBM link adaptor addresses and offsets */

#define LINK_BASE              0x150
#define LINK_READ_OFFSET       0
#define LINK_WRITE_OFFSET      1
#define LINK_IN_STATUS_OFFSET  2
#define LINK_OUT_STATUS_OFFSET 3
#define LINK_RESET_OFFSET      16
#define LINK_ERROR_OFFSET      16
#define LINK_ANALYSE_OFFSET    17
