/*
-- ----------------------------------------------------------------------------
--
--  Object name : hostio.c
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--    TDS Server  IBM implementation specific routines
--
--  NOTES
-- System dependencies:
--   rename() is a routine which takes two filenames, and renames the first
--     to the second.
--
--   The routines goto_xy, clear_window, scroll_down and scroll_up are only
--     declared if we are using the special screen_p channel for fast screen
--     driving. 
--
--  HISTORY
--     ibm-pc   03-Apr-88  CREATION.
-- ----------------------------------------------------------------------------
*/
#include "inmos.h"
#include "srvconst.h"

#include <linux/types.h>
#include <linux/termios.h>
#include <stdio.h>

#define ORG_MODE 0
#define GET_MODE 1
#define POLL_MODE 2

struct termios OrgMode, CurMode;

int _key_available = FALSE;
int _key = 0;

extern int FIRST_SCREEN_LINE;
extern int LAST_SCREEN_LINE;
extern int FIRST_SCREEN_COL;
extern int LAST_SCREEN_COL;

/*
-- ---------------------------------------------------------------------------
-- int KeyTest
-- Return TRUE if a key is available at the keyboard, FALSE otherwise.
--
-- Input Parameters:
--   None.
--
-- Output Parameters:
--   (BOOL) Return T/F for keyboard
-- ---------------------------------------------------------------------------
*/
int KeyTest ()
{
  unsigned char Byte;

  CurMode.c_iflag &= ~ICRNL;
  CurMode.c_lflag &= ~(ICANON | ECHO);
  CurMode.c_cc[VTIME] = 0;
  CurMode.c_cc[VMIN] = 0;
  ioctl( 0, TCSETS, &CurMode );

  read(0, &Byte, 1);

  if (Byte == 0)
  {
    _key_available = FALSE;
    _key = 0;
    return( FALSE );
  }
  else
  {
    _key_available = TRUE;
    _key = Byte;
    return( TRUE );
  }

}


int GetKeyNwait()
{
  unsigned char Byte;

  CurMode.c_cc[VMIN] = 0;
  ioctl( 0, TCSETS, &CurMode );

  read(0, &Byte, 1);

  return ( Byte );
}

/*
-- ---------------------------------------------------------------------------
-- int GetKey - Return a key from the keyboard.
--
-- Input Parameters:
--   None.
--
-- Output Parameters:
--   (int) Return Key read from Keyboard.
-- ---------------------------------------------------------------------------
*/
int GetKey ()
{
  unsigned char Byte;

 if ( _key_available == TRUE )
  {
    _key_available = FALSE;
    return( _key );
  }
  else
  {
    CurMode.c_cc[VMIN] = 1;
    ioctl( 0, TCSETS, &CurMode );

    read(0, &Byte , 1);

    return( (int) Byte );
  }
}
/*
-- ---------------------------------------------------------------------------
-- int DoRename  - Rename a file!!!
--
-- Input Parameters:
--   (BYTE *) OldName - Old file Name.
--   (BYTE *) NewName - New file Name.
--
-- Output Parameters:
--   (int) Return result of rename.
-- ---------------------------------------------------------------------------
*/
int DoRename (OldName, NewName)
BYTE *OldName;
BYTE *NewName;
{
  return(rename(OldName, NewName)); 
}

/*
-- ---------------------------------------------------------------------------
-- void GotoXY - move the cursor
--
-- Input Parameters:
--   (int) x - X coord.
--   (int) y - Y coord.
--
-- Output Parameters:
--   None.
--
-- ---------------------------------------------------------------------------
*/
void GotoXY (X, Y)
int X, Y;
{
  printf("\033[%d;%dH",Y+1, X+1); fflush(stdout);
}

/*
-- ---------------------------------------------------------------------------
-- void ScrollDown - Call the BIOS directly to scroll a window of the screen.
--
-- Input Parameters:
--   (int) from_x
--   (int) from_y
--   (int) to_x
--   (int) to_y
--
-- Output Parameters:
--   None.
--
-- ---------------------------------------------------------------------------
*/
void ScrollDown ( from_x, from_y, to_x, to_y )
int from_x, from_y, to_x, to_y;
{
  /* use VT-100 esc-sequences to scroll */
  printf("\033[%d;%dr\033[1L\033[%d;%dr", 
	 from_y + 1, to_y + 1, FIRST_SCREEN_LINE + 1, LAST_SCREEN_LINE + 1);
  fflush(stdout);
  
}
/*
-- ---------------------------------------------------------------------------
-- void ScrollUp
--
-- Input Parameters:
--   (int) from_x
--   (int) from_y
--   (int) to_x
--   (int) to_y
--
-- Output Parameters:
--   None.
--
-- ---------------------------------------------------------------------------
*/
void ScrollUp ( from_x, from_y, to_x, to_y )
int from_x, from_y, to_x, to_y;
{
  printf("\033[%d;%dr\033[1M\033[%d;%dr", 
	from_y + 1, to_y + 1, FIRST_SCREEN_LINE + 1, LAST_SCREEN_LINE + 1);
  fflush(stdout);
}
