/*
-- ----------------------------------------------------------------------------
--
--  Object name : TDS Server  Global Constant Definitions
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--     This is the Inmos C predefine file.
--
--  NOTES
--
--  HISTORY
--    ibm-pc  16-Feb-88 RJO - Added new terminate codes (17-29).
--    ibm-pc  23-Feb-88 RJO - Added Param,Pick,Delete FileId messages.
--    ibm-pc  24-Feb-88 RJO - Added COMSPEC_SIZE, updated Kernel commands.
-- ----------------------------------------------------------------------------
*/

#define BIT_0  1
/*
-- ----------------------------------------------------------------------------
-- Conditional Compilation Flags
--
-- The following flags may be used:
--
-- IBMserver - if defined, inserts code to test which IBM PC the server is
--             running on, and sets up the link adaptor addresses appropriately
--
-- BREAKOUT  - if defined, adds code to terminate the server when the
--             breakout character is typed at the keyboard.
--
-- ----------------------------------------------------------------------------
*/
#define IBMserver TRUE
#define BREAKOUT  TRUE
/* #define REV_A_FIX TRUE */ /* Enable slicing correction for Rev. A silicon */
/*
-- ----------------------------------------------------------------------------
-- ASCII values.
-- ----------------------------------------------------------------------------
*/

#define SOH                    1
#define CONTROL_D              4
#define BELL                   7
#define BS                     8
#define HT                     9
#define LF                     10
#define VT                     11
#define FF                     12
#define CR                     13
#define CONTROL_Y              25
#define ESCAPE                 27
#define RS                     30
#define SPACE                  32
/*
-- ----------------------------------------------------------------------------
-- Filer error numbers.
-- ----------------------------------------------------------------------------
*/

#define F_EOF                  1
#define F_OK                   0
#define F_UNKNOWN_FREE_SPACE  -1
#define F_HOST_ERROR          -99
#define F_TOO_MANY_SUSPENDS   -306
#define F_ILLEGAL_CHRC        -308
#define F_CANNOT_CHANGE_CHRC  -309
#define F_CANNOT_COPY         -311
#define F_NOT_ALL_DATA_WRITTEN -312
#define F_ILLEGAL_EXTENSION   -313
#define F_ILLEGAL_ATTRIBUTE   -314
#define F_CANNOT_SEEK         -315
#define F_IO_ERROR            -350
#define F_NO_SUCH_DEVICE      -351
#define F_NOT_DIRECTORY       -352
#define F_IS_DIRECTORY        -353
#define F_INVALID_ARGUMENT    -354
#define F_FILE_TOO_LARGE      -355
#define F_BOOT_TIMEOUT        -356
#define F_CANNOT_CLOSE_FILE   -357
#define F_CANNOT_OPEN_FILE    -358
#define F_CANNOT_DELETE       -359
#define F_CANNOT_READ         -360
#define F_CANNOT_RENAME       -361
#define F_CANNOT_FLUSH        -362
#define F_CANNOT_READ_CHRC    -363
#define F_NO_BOARD            -369

#define F_MEMORY_FULL         -408
#define F_DEVICE_OUT_OF_RANGE -1002
#define F_NO_SUCH_FILE        -1103
#define F_INVALID_OPERATION   -1105
#define F_VOLUME_FULL         -1122
#define F_UNMATCHED_RESUME    -1134
#define F_FILE_HANDLER_FULL   -1141
/*
-- ----------------------------------------------------------------------------
-- Terminate codes.
-- ----------------------------------------------------------------------------
*/

#define T_OK                      0
#define T_USR_BRK                 3
#define T_INVALID_TOPFILE_READ    4
#define T_USR_STOP                7
#define T_TRANSPUTER_ERR          8
#define T_BAD_BOOT                9
#define T_SCREEN_CLOSED          10
#define T_FILER_CLOSED           11
#define T_ILLEGAL_LINK_CHANNEL   12
#define T_ILLEGAL_SCREEN_P_TOKEN 14
#define T_BAD_FILER_COMMAND      15
#define T_BAD_COMMAND_LINE       16
#define T_BOOT_TIMEOUT           17
#define T_CANNOT_CLOSE_BOOT_FILE 18
#define T_CANNOT_READ_BOOT_FILE  19
#define T_NO_SUCH_BOOT_FILE      20
#define T_LINK_TIMEOUT           21
#define T_NO_BOARD               22
#define T_NO_COMSPEC_ENV_VAR     23
#define T_BOARD_IN_USE           24
#define T_FAILED_TO_CREATE_LOCK_FILE 25
#define T_FAILED_TO_DELETE_LOCK_FILE 26
/*
-- ----------------------------------------------------------------------------
-- Channel Numbers.
-- ----------------------------------------------------------------------------
*/

#define TO_KERNEL_CHAN        0
#define FROM_KERNEL_CHAN      1
#define TO_TERM_P_CHAN        2
#define FROM_TERM_P_CHAN      3
#define FROM_COMM_CHAN        28
#define TO_COMM_CHAN          29
#define TO_FILER_0_CHAN       32
#define TO_FILER_1_CHAN       33
#define TO_FILER_2_CHAN       34
#define TO_FILER_3_CHAN       35
#define TO_FILER_4_CHAN       36
#define TO_FILER_5_CHAN       37
#define TO_FILER_6_CHAN       38
#define TO_FILER_7_CHAN       39

#define FROM_FILER_0_CHAN     48
#define FROM_FILER_1_CHAN     49
#define FROM_FILER_2_CHAN     50
#define FROM_FILER_3_CHAN     51
#define FROM_FILER_4_CHAN     52
#define FROM_FILER_5_CHAN     53
#define FROM_FILER_6_CHAN     54
#define FROM_FILER_7_CHAN     55
/*
-- ----------------------------------------------------------------------------
-- Kernel Commands.
-- ----------------------------------------------------------------------------
*/

#define K_GET_RESULT          1
#define K_GET_IPTR            2
#define K_GET_VAL             3
#define K_GET_LAST_ERROR      4
#define K_CLEAR_RESULT        5
#define K_CLEAR_LAST_ERROR    6
#define K_TERMINATE_SERVER    7
#define K_STORE_ITEM          8
#define K_RETRIEVE_ITEM       9
#define K_GET_CHAR            10
#define K_RETRIEVE_MEM        11
#define K_SUSPEND_TDS         12
#define K_GET_ABORT_STATE     15

#define KERNEL_DATA_ITEMS     32
/*
-- ----------------------------------------------------------------------------
-- Kernel flags
-- ----------------------------------------------------------------------------
*/

#define K_OK                   0
#define K_SUSPEND_FAILED       1      /* Must be any non-zero value */
#define K_ABORT_SET            -1
#define K_ABORT_UNSET          0
/*
-- ----------------------------------------------------------------------------
-- Filer Constants.
-- ----------------------------------------------------------------------------
*/

#define RECORD_LENGTH         512
#define NUMBER_OF_FILERS      8
#define FILE_NAME_LENGTH      63
#define COMMAND_LINE_LENGTH   128
#define DEFAULT_BOOT_NAME     "/tds2sys/boot.b4"
#define DEFAULT_TOP_LEVEL     "toplevel.top"
#define TOOLKIT_FILE_NAME     "toplevel.tkt"
#define DELETE_FILE_NAME      "toplevel.del"
#define PICK_FILE_NAME        "toplevel.pck"
#define TOOLKIT_FILE_EXTN     ".tkt"
#define DELETE_FILE_EXTN      ".del"
#define PICK_FILE_EXTN        ".pck"
#define COMSPEC_SIZE          64
#define TOP_LEVEL_FILE_CONTENTS "\200\201"
#define TOP_LEVEL_FILE_LENGTH  2
#define GENERIC_TOP_LEVEL_NAME_EXTN ".top"
/*
-- ----------------------------------------------------------------------------
-- Values for PC BIOS call.
-- ----------------------------------------------------------------------------
*/

#define C_INIT    0
#define C_WRITE   1
#define C_READ    2
#define C_TEST    3

#define C_BOARD   0     /* We only drive board 0 */

#define C_READY   0x100 /* The data ready bit */

#define C_OVERRUN_ERROR 0x200
#define C_PARITY_ERROR  0x400
#define C_FRAMING_ERROR 0x800
#define C_BREAK_DETECT  0x1000
/*
-- ----------------------------------------------------------------------------
-- Special values sent on channels to/from transputer.
-- ----------------------------------------------------------------------------
*/

#define TSL_RE_INIT -1
#define TSL_SET_ATTR1 (-4) << 8

#define FSL_BREAK_DETECTED -1
#define FSL_ERR_OVERRUN    (-3) << 8
#define FSL_ERR_FRAME      (-4) << 8
#define FSL_ERR_PARITY     (-5) << 8
