/*
-- ----------------------------------------------------------------------------
--
--  Object name : termp.h
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--    TDS Server  Term.p protocol values.
--
--  NOTES
--
--  HISTORY
--     ibm-pc  16-Apr-88  RJO - CREATION.
--     ibm-pc  16-Apr-88  RJO - Added new TDS3 'ft' tags.
--     ibm-pc  23-Feb-88  RJO - Added TDS3 Keyboard Map.
--     ibm-pc  19-Apr-88  RJO - Added FT_COOKED,FT_RAW tags.Changed CTRL ->
--     to send back FT_WORD_RIGHT.The CTRL <- now sends FT_WORD_LEFT.
-- ----------------------------------------------------------------------------
*/

/*
-- ----------------------------------------------------------------------------
-- Screen Mappings.
-- ----------------------------------------------------------------------------
*/

int     FIRST_SCREEN_COL = 0;
int	LAST_SCREEN_COL;
int     FIRST_SCREEN_LINE = 0;
int	LAST_SCREEN_LINE;
#define FIRST_TEXT_COL    FIRST_SCREEN_COL
#define LAST_TEXT_COL     LAST_SCREEN_COL
#define MESSAGE_LINE      FIRST_SCREEN_LINE
#define FIRST_TEXT_LINE   FIRST_SCREEN_LINE+1
#define LAST_TEXT_LINE    LAST_SCREEN_LINE
#define MIN_VISIBLE_CHAR  32
#define MAX_VISIBLE_CHAR  127
/*
-- ----------------------------------------------------------------------------
-- Message Tags For to.term.p protocol.
-- ----------------------------------------------------------------------------
*/

#define TT_RESET        0
#define TT_UP           1
#define TT_DOWN         2
#define TT_LEFT         3
#define TT_RIGHT        4
#define TT_GOTO         5
#define TT_INS_CHAR     6
#define TT_DEL_CHAR     7
#define TT_OUT_STRING   8
#define TT_CLEAR_EOL    9
#define TT_CLEAR_EOS    10
#define TT_INS_LINE     11
#define TT_DEL_LINE     12
#define TT_BEEP         13
#define TT_WAIT         14
#define TT_TERMINATE    15
#define TT_HELP         16
#define TT_INITIALISE   17
#define TT_OUT_BYTE     18
#define TT_OUT_INT      19
#define TT_KEY_RAW      20
#define TT_KEY_COOKED   21
/*
-- ----------------------------------------------------------------------------
-- Terminal process to editor init protocol.
-- ----------------------------------------------------------------------------
*/

#define FT_LINES_PREFIX     -1
#define FT_COLUMNS_PREFIX   -2
#define FT_NOLINEOPS_PREFIX -3
#define FT_END_INIT         -4
#define FT_TABLE_ERROR      -5
#define FT_NONCOM_TABLE     -6
#define FT_NOCHAROPS_PREFIX -7
#define FT_TERMINATED       -8
#define FT_COOKED           -12
#define FT_RAW              -13
#define NO_OPS               0
#define NO_CHAR_OPS          1
/*
-- ----------------------------------------------------------------------------
-- Keys from term.p.
-- ----------------------------------------------------------------------------
*/

#define RETURN         '\r'
#define DELETE         127
#define TAB            '\t'
#define FT_TAG         200
#define FT_RETURN      FT_TAG+0
#define FT_UP          FT_TAG+1
#define FT_DOWN        FT_TAG+2
#define FT_LEFT        FT_TAG+3
#define FT_RIGHT       FT_TAG+4
#define FT_DEL_CHL     FT_TAG+5
#define FT_DEL_CHR     FT_TAG+6
#define FT_DEL_LINE    FT_TAG+7
#define FT_UNDEL_LINE  FT_TAG+8
#define FT_SOL         FT_TAG+9
#define FT_EOL         FT_TAG+10
#define FT_MOVE        FT_TAG+11
#define FT_COPY        FT_TAG+12
#define FT_LINE_UP     FT_TAG+13
#define FT_LINE_DOWN   FT_TAG+14
#define FT_PAGE_UP     FT_TAG+15
#define FT_PAGE_DOWN   FT_TAG+16
#define FT_CREATE_FOLD FT_TAG+17
#define FT_REMOVE_FOLD FT_TAG+18
#define FT_OPEN_FOLD   FT_TAG+19
#define FT_CLOSE_FOLD  FT_TAG+20
#define FT_ENTER_FOLD  FT_TAG+21
#define FT_EXIT_FOLD   FT_TAG+22
#define FT_REFRESH     FT_TAG+23
#define FT_FILE_FOLD   FT_TAG+24
#define FT_UNFILE      FT_TAG+25
#define FT_FINISH      FT_TAG+26
#define FT_EDIT_PARAMS FT_TAG+27
#define FT_FOLD_INFO   FT_TAG+28
#define FT_HELP        FT_TAG+29
#define FT_LOCATE      FT_TAG+30
#define FT_GET_CODE    FT_TAG+31
#define FT_PUT_CODE    FT_TAG+32
#define FT_CLEAR_CODE  FT_TAG+33
#define FT_RUN         FT_TAG+34
#define FT_TOOL0       FT_TAG+35
#define FT_TOOL1       FT_TAG+36
#define FT_TOOL2       FT_TAG+37
#define FT_TOOL3       FT_TAG+38
#define FT_TOOL4       FT_TAG+39
#define FT_TOOL5       FT_TAG+40
#define FT_TOOL6       FT_TAG+41
#define FT_TOOL7       FT_TAG+42
#define FT_TOOL8       FT_TAG+43
#define FT_TOOL9       FT_TAG+44
#define FT_WORD_LEFT   FT_TAG+45       /* TDS3 addition */
#define FT_WORD_RIGHT  FT_TAG+46
#define FT_DEL_WORDL   FT_TAG+47
#define FT_DEL_WORDR   FT_TAG+48
#define FT_DELTO_EOL   FT_TAG+49
#define FT_TOP_OF_FOLD FT_TAG+50
#define FT_BOTTOM_OF_FOLD  FT_TAG+51  /* Always one that wont line up !! */
#define FT_SELECT_PARAM FT_TAG+52
#define FT_CODE_INFO   FT_TAG+53
#define FT_PICK        FT_TAG+54
#define FT_COPY_PICK   FT_TAG+55
#define FT_PUT         FT_TAG+56
#define FT_NEXT_UTIL   FT_TAG+57
#define FT_CLEAR_UTIL  FT_TAG+58
#define FT_AUTOLOAD    FT_TAG+59
#define FT_NEXT_EXE    FT_TAG+60
#define FT_CLEAR_EXE   FT_TAG+61
#define FT_CLEAR_ALL   FT_TAG+62
#define FT_BROWSE      FT_TAG+63
#define FT_SUSPEND_TDS FT_TAG+64
#define FT_DEFINE_MACRO FT_TAG+65
#define FT_CALL_MACRO  FT_TAG+66
#define FT_BAD         FT_TAG+70
/*
-- ----------------------------------------------------------------------------
-- Messages.
-- ----------------------------------------------------------------------------
*/

#define DEL_CHR        "     TAB,Delete right,"
#define UPPER          "Use the ALT key to get the upper functions,"
#define TOOLS          "ALT with numeric keys calls the tools.,"
#define TITLE          "IMS D700D Transputer development system Linux,"
#define MAX_STRING_SIZE  256
#define STOP_KEY         CONTROL_Y
/*
-- ----------------------------------------------------------------------------
-- IBM Keyboard definitions.
-- ----------------------------------------------------------------------------
*/

#define TDS3_KEYPAD_START 59
#define TDS3_KEYPAD_END   132
#define NO_OF_KEYS        (TDS3_KEYPAD_END - TDS3_KEYPAD_START + 1)
#define CTRL_A            1
#define CTRL_Y            25
