#ifndef _LINUX_B004_H
#define _LINUX_B004_H

/*
 * usr/include/linux/b004.h
 *
 * based on
 *
 * usr/include/linux/lp.h c.1991-1992 James Wiegand
 * many modifications copyright (C) 1992 Michael K. Johnson
 *
 * Christoph Niemann (niemann@swt.ruhr-uni-bochum.de)
 *
 * Version 0.4 for Linux 0.99pl14 and above.
 */

#include <linux/timer.h>


#define B004_MAJOR	24		/* Major device number */
#define B004_NAME	"link"		/* Name of the device to register */
#define B004_NO		3		/* Number of supported boards */

/*
 * Per POSIX guidelines, this module reserves the B004 and b004 prefixes
 * These are the b004_table.flags flags...
 */
#define B004_EXIST 		0x0001	/* Is a B004-Board with at least one 
					   Transputer present ? */
#define B004_BUSY  		0x0002	/* Is the B004-board in use ? */
#define B004_READ_ABORT		0x0004  /* abort reading after timeout ? */
#define B004_WRITE_ABORT	0x0008  /* abort writing after timeout ? */

/*
 * IOCTL numbers
 */
#define B004TIME		0x0001
#define B004RESET		0x0002
#define B004WRITEABLE		0x0004
#define B004READABLE		0x0008
#define B004ANALYSE		0x0010
#define B004ERROR		0x0020
#define B004READTIMEOUT		0x0040
#define B004WRITETIMEOUT	0x0080
#define B004READABORT		0x0100
#define B004WRITEABORT		0x0200

/*
 * This is the amount of time that the driver waits for the link to
 * catch up when the C012's buffer appears to be filled.  If you
 * want to tune this, decrease or increase this number.
 * This is in hundredths of a second, the default 1 being .01 second.
 */
#define B004_INIT_TIME 1

/*
 * timeout for printk'ing a timeout, in jiffies (100ths of a second).
 * This is also used for re-checking error conditions if B004_READ_ABORT or 
 * B004_WRITE_ABORT is not set. This is the default behavior for reading.
 * writing has the timeout enabled per default.
 */
#define B004_INIT_WRITE_TIMEOUT	1000
#define B004_INIT_READ_TIMEOUT	100

#define B004_IDR_OFFSET		0		/* Input Data Register */
#define B004_ODR_OFFSET		1		/* Output Data Register */
#define B004_ISR_OFFSET		2		/* Input Status Register */
#define B004_OSR_OFFSET		3		/* Output Status Register */
#define B004_RESET_OFFSET	16		/* Reset/Error Register */
#define B004_ERROR_OFFSET	B004_RESET_OFFSET
#define B004_ANALYSE_OFFSET	17		/* Analyse Register */
#define B008_DMA_OFFSET		18		/* B008: DMA request register */
#define B008_INT_OFFSET		19		/* B008: Interrupt control reg */

struct b004_struct {
	int flags;			/* various flags */
	int idr;			/* address of the input data register */
	int odr;			/* address if the output data register */
	int isr;			/* address of the input status register */
	int osr;			/* address of the output status register */
	unsigned int time;		/* jiffies to wait after the first failure */
	unsigned int read_timeout;	/* timeout for reading from the link */
	unsigned int write_timeout;	/* timeout for writing to the link */
	int boardtype;			/* what kind of board is installed */
};

/*
 * Id's for the supported boards
 */
#define B004 1
#define B008 2

/*
 * Defines for easier access to the b004_table.
 */
#define B004_TIME(minor)		b004_table[minor].time
#define B004_F(minor)			b004_table[minor].flags
#define B004_READ_TIMEOUT(minor)	b004_table[minor].read_timeout
#define B004_WRITE_TIMEOUT(minor)	b004_table[minor].write_timeout
#define B004_BASE(minor)		B004_IDR(minor)
#define B004_IDR(minor)			b004_table[minor].idr
#define B004_ODR(minor)			b004_table[minor].odr
#define B004_ISR(minor)			b004_table[minor].isr
#define B004_OSR(minor)			b004_table[minor].osr
#define B004_WAIT(minor)		b004_table[minor].wait
#define B004_BOARDTYPE(minor)		b004_table[minor].boardtype

/*
 * Additonal defines for B008-boards
 */
#define B008_DMA(minor)			b004_table[minor].int
#define B008_INT(minor)			b004_table[minor].dma

/*
 * Number of tries to access isr or osr before reading or writing fails
 */
#define B004_MAXTRY 			300

/*
 * Maximum number of bytes to transfer without calling the scheduler
 */
#define B004_MAX_BYTES			32

/*
 * bit defines for C012 status ports at base + 2/3
 * accessed with B004_IS, B004_OS, which gets the byte...
 */
#define B004_READBYTE	1
#define B004_WRITEBYTE	1

/*
 * bit defines for C012 reset/error port at base + 16
 */
#define B004_ASSERT_RESET	0x01	/* resetting the transputer */
#define B004_DEASSERT_RESET	0x00
#define B004_TEST_ERROR		0x01	/* for testing the transputer's error flag */

/*
 * bit defines for C012 analyse port at base + 17
 */
#define B004_ASSERT_ANALYSE	0x01	/* switch transputer to analyse-mode */
#define B004_DEASSERT_ANALYSE	0x00

/*
 * function prototypes
 */
extern long b004_init(long);

#endif
