/* $Header: /home/vph/develop/lore/RCS/widgets.h,v 1.9 1996/02/23 14:24:59 vph Exp $*/
  
/*
 * File:        widgets.cc
 * Description: Widgets for Linux OMEN Reader
 * Author:      Ville Hallivuori, vpg@clinet.fi
 *
 * Copyrights (c) 1995-1996 by Ville Hallivuori
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "lore.h"
typedef void(*MFP)();                         //Menues param type (function)
void NYI(void);                               //Shows "Not Yet Implemented"

/*
 * ListBox -widget
 */
struct item_st
{
  char *label;
  item_st *next;
};

class ListBox                      //ListBox -widget
{
private:
  int X1,Y1,X2,Y2;                 //Coordinates
  int OnSrcItem;                   //Firs item on screen
  int CurItem;                     //Index of curent item
  void DrawItem(int Index);        //Draws one item
  void ScrollDown(void);           //Scrolls listbox down
  void ScrollUp(void);             //Scrolls listbox up
  item_st *first_item;
  item_st *insert_item (void);
  item_st *get_item (int no);
public:
  int LastItem;                    //Index of last item
  ListBox(int Xc1, int Yc1, int Xc2, int Yc2, int CI); //Initial parameters
  ~ListBox(void);
  /*This is ugly hack, but I will fix it later.  */
  int ret_brd_nro (int i);
  void AddItem(char *AItem);       //Adds item to listbox
  void ModifyItem(char *AItem, int ItemNro);  //Modify listbox-item
  void Draw(void);                 //Draws list and background
  int Handle(void);                //User-interface
};

/*
 * Message-readin interface
 */
class MsgScreen                  //Userinterface to look messages
{
private:
  char PointerName[200];         //Name of POINTERSxy.zzz  
  void DrawMsgLine(int AddLine); //Draws one line of message
  int update;                    //UpdateLevel
  void StatusLine(void);         //Draws statusline
public:
  int msgpos;                    //Position of message
  MsgScreen(int Index);          //Initial values (reads messagepointers)
  ~MsgScreen(void);              //Saves messagepointers
  char MsgText[1005] [85];       //Text of selected message
  int MxLine;                    //Last line of message
  void Handle(void);             //Userinterface
  void DrawMessage(int DLines);
  void DrawHeader(void);
  void NextMessage(int operation);
  int exit;
};

/*
 * Window -widget
 */
class Window                     //Window -widget
{
private:
  char *Caption;                 //Pointer to window's caption
public:
  int X1;                        //Coordinates
  int Y1;
  int X2;
  int Y2;
  Window(int WX1,int WY1,int WX2,int WY2,char *WCaption); //Initial values
  void Draw(void);               //Draws window
};

/*
 * Vertical select -vidget
 */
class VSelect               //Vertical select -vidget
{
private:
  int X1,X2,Y;              //Coordinates
  int LastItem;             //Index of last item
public:
  int Active;               //Index of active item
  char Items[10][30];       //Max 10 items, max 29 chars each
  VSelect(int Xc1,int Xc2,int Yc,int MaxItem); //Initial values
  void Draw(int State);     //Draws widget (parameter: 1=active, 0=inact.)
  int VSelect::Handle(void);//UserInterface
};


/*
 * CheckBox -vidget
 */
class CheckBox              //CheckBox -vidget
{
private:
  int X,Y;                  //Coordinates
  char *Caption;            //Pointer to CheckBox's caption
public:
  CheckBox (const CheckBox &);
  CheckBox(int Xc,int Yc,char *Capt, int DefStat=1); //Initial values
  void Draw(int AState);    //Draws vidget (parameter: 1=actv. 0=inactiv.)
  int Handle(void);         //UserInterface
  int Status;               //0= not checked, 1=checked
};

/*
 * TextBox -widget (input-field)
 */
class TextBox                 //TextBox -widget (input-field)
{
private:
  char *Text;                 //Text to edit
  int SPos;                   //Length of text whic don't fit to field
  int Status;                 //Is field active/inactive
public:
  int X1,X2,Y;                //Coordinates
  TextBox(int Xc1,int Xc2,int Yc,char *PText); //Initial values
  void Draw(void);            //Draws textbox     
  int ReadInput(int MaxPos);  //User-interface
};

/*
 * MenuBar -widget
 */
class AppMenus              //MenuBar -vidget
{
private:
  int x1,y1,x2,y2;
  struct MnuBase            //Info about menuitem
  {
    char Name[30];
    int ParentNro;
    int Type;
    int PosX;
    int PosY;
    MFP MFunction;
  };
  MnuBase MBase[100];       //Struct's of menuitems
  int OMenu;                //Old selected menu
  int Update;               //Updateleve: bigger value = bigger update
  int MMenuLoop(void);      //UserInterface for root-menus
  int MxMenu;               //Index of last menu-item
  int CMenu;                //Selected menu-item
  int SeekMenu(int MType, int MenuOH); //Searsh next menu, whic has same parent
  void HBMenuBar(int MnuNro, int Type); //Partial redraw of MenuBar (1st line)
  int GetMLen(int ParentNro);    //Get menu's with
  int GetRParent(int MnuNro);    //Get's original parent of menu
  void DrawMenu(void);      //Draws menu depending Update-level
  int NextSMnu(void);       //Finds next submenu
  int PrevSMnu(void);       //Finds previous submenu
  int NextMMnu(void);       //Finds next mainmenu
  int PrevMMnu(void);       //Finds previous mainmenu
  int MenuLoop(void);       //MainLoop of menuvidget
  void DrawSep(int SepWidth, int SepNro); //Draws separator (type 2)
  void DrawSMenu(void);     //Draws submenu
  void HSMenu(int Menu, int Type); //Partial draw of submnu (sel+unsel item)
public:
  AppMenus(void);           //Initial values
  int AddMenu(char MName[30], int PNro, int Type=1, MFP MF=&NYI); //Adds menu
  int Handle(void);         //Userinterface
  void BMenuBar(void);      //Draws menubar (1st line)
};
