#!/bin/sh

# $Header: /private/postgres/test/RCS/alltests.sh,v 1.3 1992/08/06 23:22:01 mer Exp $

# This is a shell script that runs all of the Postgres demo tests.
# It is the last thing done before releasing and should execute
# flawlessly from beginning to end.

CWD=`pwd`

# PMTESTS run under the postmaster while BETESTS are the backend in
# standalone mode.

PMTESTS="demo video"
BETESTS="bench"

PM=$POSTGRESHOME/bin/postmaster

for i in $BETESTS
do
	echo running $i...
	cd $POSTGRESHOME/$i
	rm -f $CWD/$i.out
	./whole$i.sh > $CWD/$i.out 2>&1
done

$PM &
PMPID=$!

sleep 2

for i in $PMTESTS
do
	echo running $i...
	cd $POSTGRESHOME/$i
	rm -f $CWD/$i.out
	./whole$i.sh > $CWD/$i.out 2>&1
done

kill -15 $PMPID


echo alltests done.
