# ----------------
#	support.mk	- postgres support program makefile
#
# Note:	if $STRIPOBJS is 't' then targets are stripped after compilation.
#	This defaults to 'f' by Make.
#
## $Header: /private/postgres/newconf/RCS/support.mk,v 1.37 1992/08/12 03:38:10 mao Exp $
# ----------------

#include "config.mk"
#include "defaults.mk"
#include "FILES/support.mkf"

.SUFFIXES: .c .o .lex .y
DFLAGS= -DPG_STANDALONE

support: pg_uid bkifiles libpq monitor vacuum pg_version pg_id shmemdoc pagedoc

# ----------------
#    libpq.a
# ----------------
libpq: $(OD)/libpq.a

$(OD)/libpq.a: $(LIBPQ)
	@echo ar rvu libpq.a ...
	@ar rvu $(OD)/libpq.a $(LIBPQ)
	ranlib $(OD)/libpq.a

# -----------------
#    pg_uid
# -----------------
pg_uid: $(OD)/support/pg_uid 

$(OD)/support/pg_uid: $(PG_UID)
	@ echo linking pg_uid
	@ cc -o $(OD)/support/pg_uid $(PG_UID)

# ----------------
#    bkifiles
# ----------------
bkifiles: $(OD)/support/dbdb.bki $(OD)/support/local.bki
	@echo Removing any old bki files
	@rm -f $(TREE)/files/global1.bki
	@rm -f $(TREE)/files/local1_template1.bki

$(OD)/support/dbdb.bki: $(DBDB_SRC)
	@ echo "creating dbdb.bki" ; \
	cd $(SD)/lib/H/catalog ; \
	TREE=$(TREE);export TREE; \
	OD=`basename $(OD)`;export OD; \
	SD=`basename $(SD)`;export SD; \
	$(GENBKI) $(BKIFLAGS) $(DBDB_SRC) > $(OD)/support/dbdb.bki

$(OD)/support/local.bki: $(LOCAL_SRC)
	@ echo "creating local.bki" ; \
	cd $(SD)/lib/H/catalog ; \
	TREE=$(TREE);export TREE; \
	OD=`basename $(OD)`;export OD;\
	SD=`basename $(SD)`;export SD; \
	$(GENBKI) $(BKIFLAGS) $(LOCAL_SRC) > $(OD)/support/local.bki

# ----------------
#    rmbkifiles
# ----------------
rmbkifiles:
	@ echo "removing bki files" ; \
	rm -f $(OD)/support/dbdb.bki $(OD)/support/local.bki

# ----------------
#    pg_version
# ----------------
pg_version: $(OD)/support/pg_version

$(OD)/support/pg_version: $(PG_VERSION)
	@ echo "linking pg_version"
	@ $(CC) $(CFLAGS) -o $(OD)/support/pg_version $(PG_VERSION)
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/pg_version ; \
		 else true ; fi'


# ----------------
#    pg_id
# ----------------
pg_id: $(OD)/support/pg_id

$(OD)/support/pg_id: $(PG_ID)
	@ echo "linking pg_id"
	@ $(CC) $(CFLAGS) -o $(OD)/support/pg_id $(PG_ID)

# ----------------
#    monitor
# ----------------
monitor: $(OD)/support/monitor 

$(OD)/support/monitor: $(OD)/lib/C/simplelists.o $(OD)/libpq.a $(MONITOR)
	@ echo "linking monitor"
	@ $(CC) $(CFLAGS) -o $(OD)/support/monitor \
		$(MONITOR) $(OD)/lib/C/simplelists.o $(OD)/libpq.a $(LIBS)
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/monitor ; \
		 else true ; fi'

# ----------------
#    monitor
# ----------------
puremonitor: $(OD)/support/puremonitor 

$(OD)/support/puremonitor: $(OD)/lib/C/simplelists.o $(OD)/libpq.a $(MONITOR)
	@ echo "linking a pure monitor"
	@ purify $(CC) $(CFLAGS) -o $(OD)/support/monitor \
		$(MONITOR) $(OD)/lib/C/simplelists.o $(OD)/libpq.a $(LIBS)
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/monitor ; \
		 else true ; fi'

# ----------------
#    vacuum
# ----------------
vacuum: $(SD)/scripts/vacuum

$(SD)/scripts/vacuum: $(SD)/scripts/vacuum.sh
	@ echo "sed'ing vacuum"
	@ sed -e s%_POSTGRESBIN_%$(POSTGRESBIN)% $(SD)/scripts/vacuum.sh > \
					       $(SD)/scripts/vacuum
	@ chmod 555 $(SD)/scripts/vacuum

# ----------------
#    shmemdoc
# ----------------
shmemdoc: $(OD)/support/shmemdoc

$(OD)/support/shmemdoc: $(SD)/support/shmemdoc.c
	@ echo 'compiling shmemdoc'
	@ $(CC) $(CFLAGS) -o $(OD)/support/shmemdoc $(SD)/support/shmemdoc.c -lipc

# ----------------
#    pagedoc
# ----------------
pagedoc: $(OD)/support/pagedoc

$(OD)/support/pagedoc: $(SD)/support/pagedoc.c
	@ echo 'compiling pagedoc'
	@ $(CC) $(CFLAGS) -o $(OD)/support/pagedoc $(SD)/support/pagedoc.c

# ----------------
#    xexemon
# ----------------
XLIBS = $(OD)/libXs.a -lXaw -lXmu -lXt -lX11 -lm

xexemon: $(OD)/support/xexemon 

$(OD)/libXs.a: $(OD)/support/Tree.o
	ar ruv $(OD)/libXs.a $(OD)/support/Tree.o
	ranlib $(OD)/libXs.a 

$(OD)/support/xexemon: $(OD)/support/xexemon.o $(OD)/libXs.a
	$(CC) $(CFLAGS) -o $@ $@.o  $(XLIBS)
