/*
 * creatinh.h --
 *	POSTGRES create/destroy relation with inheritance utility definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tcop/RCS/creatinh.h,v 1.4 1992/06/16 22:26:58 joey Exp $
 */

#ifndef CreatinhHIncluded
#define CreatinhHIncluded 1	/* include once only */

/*
 * DefineRelation --
 *	Creates a new relation.
 */
extern
void
DefineRelation ARGS((
	char		*relationName,
	LispValue	parameters,
	LispValue	schema
));

/*
 * RemoveRelation --
 *	Deletes a new relation.
 *
 * Exceptions:
 *	BadArg if name is invalid.
 *
 * Note:
 *	If the relation has indices defined on it, then the index relations
 * themselves will be destroyed, too.
 */
extern
void
RemoveRelation ARGS((
	Name	name
));

extern List lispCopyList ARGS((List list));

#endif CreatinhHIncluded
