/*
 * enbl.h --
 *	POSTGRES module enable and disable support code.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/enbl.h,v 1.3 1990/08/17 08:54:36 cimarron Exp $
 */

#ifndef	EnblIncluded		/* Include this file only once */
#define EnblIncluded	1

#include "tmp/c.h"

#define ENBL_H	"$Header: /private/postgres/src/lib/H/tmp/RCS/enbl.h,v 1.3 1990/08/17 08:54:36 cimarron Exp $"

/*
 * BypassEnable --
 *	False iff enable/disable processing is required given on and "*countP."
 *
 * Note:
 *	As a side-effect, *countP is modified.  It should be 0 initially.
 *
 * Exceptions:
 *	BadState if called with pointer to value 0 and false.
 *	BadArg if "countP" is invalid pointer.
 *	BadArg if on is invalid.
 */
extern
bool
BypassEnable ARGS((
	Count	*enableCountInOutP,
	bool	on
));

#endif	/* !defined(EnblIncluded) */
