/* ----------------------------------------------------------------
 *	assoc_int.c
 *
 *	$Header: /private/postgres/src/utils/fmgr/RCS/assoc_int.h,v 1.3 1989/10/05 15:13:45 cimarron Exp $
 * ----------------------------------------------------------------
 */
/**********************************************************************\
**								      **
** internal data types... not for use by the mortal man.. subject to  **
** changes..  information hiding and all that, don't you know.	      **
**								      **
\**********************************************************************/

typedef int* H_memory_cell;/* pointers to user's memory area. */

typedef H_memory_cell entry;  

typedef entry hash_table[];

typedef struct assoc_mem_rec
	{ hash_table *array; 
 	  int value_size;   /* User defined size of data values; */
	  int size;	  /* Number of slots in table.. power of 2 */
	  int size_div_2; /* always = size / 2 */
	  int mask;	  /* always = size-1, for calculating (num mod size)*/
	  int entries;    /* number of entries in assoc mem */
	}
     * assoc_memory;


/* Get unique stored string associated with a memory cell */

#define str_from_cell(cell,table) \
	((char*) (((char*) (cell))  + (table)->value_size))

/* Get memory cell associated with a string returned from string_from_cell*/

#define cell_from_str(string,table) \
	((int*)  (((char*) (string)) - (table)->value_size))

#define mem_from_cell(cell) ((int*)    ((char*)(cell) - sizeof(entry)))
#define cell_from_mem(mem)  ((mem_cell)((char*)(mem)  + sizeof(entry)))

#define INIT_TABLE_SIZE 8 /* Must be a power of two */
/*************************************************************************
*************************************************************************/

