/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1992, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	selection.H
 *
 *	Functions(s):
 *
 *	Description:
 *		selection handling
 *
 *	RCSid = "$Id: selection.H,v 4.11.1.1 1993/06/01 22:56:45 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_selection_H
#define OI_selection_H

	class OI_d_tech;
	class OI_cb;

 /* selected atoms */
#define			OI_atom_PRIMARY	XA_PRIMARY
#define			OI_atom_SECONDARY XA_SECONDARY
#define			OI_atom_STRING	XA_STRING

#ifdef TYPEDEF_MEMFN
	typedef	OI_bool	(OI_sel_cvt_fn)(OI_d_tech*,void*,const XEvent *);
	typedef	OI_bool	OI_callback::OI_sel_cvt_memfn(OI_d_tech*,void*,const XEvent *);
#endif /* TYPEDEF_MEMFN */
	typedef	OI_bool	(*OI_sel_cvt_fnp)(OI_d_tech*,void*,const XEvent *);
	typedef	OI_bool	(OI_callback::*OI_sel_cvt_memfnp)(OI_d_tech*,void*,const XEvent *);

	class OI_selection_owner : public OI_callback {
			Atom			sel;
			OI_d_tech		*objp;
			Time			tim;				/* time selection was aquired */
		public:
						OI_selection_owner(Atom, OI_d_tech *, Time);
		virtual				~OI_selection_owner();
			Atom			selection()		{ return (sel); }
			OI_d_tech		*object()		{ return (objp); }
			void			selection_clear(const XEvent *);
			void			set_object(OI_d_tech *);
			void			set_time(Time t)	{ tim = t; }
			Time			time()			{ return (tim); }
	};

#define OI_SELECTION_DELETE_TARGETS		0x01
#define OI_SELECTION_EVENTS_INSTALLED		0x02

	class OI_selection : public OI_callback {
			OI_d_tech		*objp;				/* the object that wants to convert the selection data */
			OI_pointer_array	*list;				/* the list of selection data we can convert */
			OI_number		_targets_index;			/* index into the _MOTIF_DRAG_TARGETS property */
			Atom			*_targets;			/* used in TARGETS conversion */
			Atom			_selection;			/* selection last converted */
			Atom			_property;			/* the property on which the selection is placed */
			Atom			_target;			/* the target the selection was converted into */
			Atom			_time;				/* the timestamp of the conversion */
			short unsigned		flags;
		public:
						OI_selection(OI_d_tech *);
		virtual				~OI_selection();
			void			allow_events_installed()	{ flags |= OI_SELECTION_EVENTS_INSTALLED; }
			void			disallow_events_installed()	{ flags &= ~OI_SELECTION_EVENTS_INSTALLED; }
			OI_bool			is_events_installed()		{ return ((flags&OI_SELECTION_EVENTS_INSTALLED)?OI_yes:OI_no); }
			void			allow_delete_targets()		{ flags |= OI_SELECTION_DELETE_TARGETS; }
			void			disallow_delete_targets()	{ flags &= ~OI_SELECTION_DELETE_TARGETS; }
			OI_bool			is_delete_targets()		{ return ((flags&OI_SELECTION_DELETE_TARGETS)?OI_yes:OI_no); }
			void			install_events();
			void			notify_receiver(XPropertyEvent*,void*);
			void			selection_request(const XEvent *,void*);
			int			send_select_data(const XEvent *);
			void			set_selection_data(Atom, Atom, void *, unsigned int, unsigned int);
			void			set_selection_targets(Atom *, OI_bool, OI_number);
			void			set_convert(OI_sel_cvt_fnp fp, void *argp=NULL) ;
			void			set_convert(OI_callback *objp, OI_sel_cvt_memfnp mfp, void *argp=NULL) ;
			OI_number		targets_index()			{ return (_targets_index); }
	};

	class OI_selection_data {
			Atom			_target;
			Atom			_type;
			void			*_data;
			unsigned int		_size;
			unsigned int		_cnt;
		public:
						OI_selection_data(Atom, Atom, void *, unsigned int, unsigned int);
						~OI_selection_data();
			void			*data()				{ return (_data); }
			unsigned int		count()				{ return (_cnt); }
			unsigned int		size()				{ return (_size); }
			void			set_count(unsigned int l)	{ _cnt = l; }
			void			set_data(void *d)		{ _data = d; }
			void			set_type(Atom a)		{ _type = a; }
			Atom			target()			{ return (_target); }
			Atom			type()				{ return (_type); }
	};

#endif /* OI_selection_H */
