	/******************************************************************
	 *                                                                *
	 *              Screen Machine II  Tuner Library                  *
	 *                                                                *
	 *                        Version 2.0                             *
	 *                          21.07.94                              *
	 *                                                                *
	 *                       SMTVControl.h                            *
	 *                                                                *
	 *               All methods for controling the TV-Tuner          *
	 *                                                                *
	 *     (c) Copyright by interpersonal-computing GmbH Germany      *
	 *                      Stefan Seel                               *
	 *                                                                *
	 ******************************************************************/

#include "smafctable.h"


/**************** miscellaneous definitions ******************** */

#define SMTV_TV_QUALITY_BIT  0x01
#define SMTV_VT_QUALITY_BIT  0x02
#define SMTV_LINE_MODE_BIT   0x80

#define SMTV_AFC_BITS        0x07

#define SMTV_GR_MODUL	 0
#define SMTV_UK_MODUL	 1
#define SMTV_OK_MODUL	 2


#define SMTV_OK					 1
#define SMTV_ERROR				 0
#define SMTV_I2CERROR			-1
#define SMTV_FREQUENCYERROR		-2
#define SMTV_SYSTEMERROR		-3
#define SMTV_NORMERROR			-4
#define SMTV_PROGRAMERROR		-5
#define SMTV_WEIGHTERROR		-6
#define SMTV_MONOSTEREOERROR	-7

#define SMTV_TWOCHANNEL		0x06
#define SMTV_NOIDENT		0x07

#define SMTV_MONO			0x02
#define SMTV_STEREO			0x03         
#define SMTV_A_CHANNEL		0x04
#define SMTV_B_CHANNEL		0x05

#define SMTV_NORM_M			0x00
#define SMTV_NORM_BG		0x01
#define SMTV_NORM_L			0x02
#define SMTV_NORM_Li		0x03
#define SMTV_NORM_I			0x04

#define SMTV_TOPTEXT_FOUND		  1
#define SMTV_TOPTEXT_SEARCHING	  0
#define SMTV_TOPTEXT_NOT_FOUND	- 1
#define SMTV_TOPTEXT_ERROR		-10

#define _DOCARE                16
#define _NOTHOLD               8
#define _ANZSUBPAGE            50


#define _CCTR0  0
#define _CCTR1  1
#define _CCTR2  2
#define _CCTR3  3
#define _CCTR4  4
#define _CCTR5  5
#define _CCTR6  6
#define _CCTR7  7
#define _CCTR8  8
#define _CCTR9  9
#define _CCTR10  10
#define _CCTR11  11

typedef struct _SMTVControl
{
	int _abs_frequenz;
	int _abs_norm;
	int _abs_country;
	int _deltafrequenz;
	int _gewichtung;
	int _senderbreite;
	int _tt_array[100][4];
	char _tt_array_text[100][6];
	SMAFCTable	*_afcTable;
} SMTVControl;

/* TV Function Area */

short smIsTunerConnected(short nSM);
int  smAfcSearch(short nSM, SMTVControl* control,int frequenz,int system ,int norm);

int   smFrequency(short nSM, SMTVControl* control);
short smInitTuner(short nSM, SMTVControl* control);
short smNextProgFor(short nSM, SMTVControl* control, int aProg, short aBool);
short smNorm(short nSM, SMTVControl* control);
int   smProgFrequency(short nSM, SMTVControl* control, int prognr);
short smProgNorm(short nSM, SMTVControl* control, int prognr);
short smProgSystem(short nSM, SMTVControl* control, int prognr);
short smProgVisible(short nSM, SMTVControl* control, int prognr);
char* smProgName(short nSM, SMTVControl* control, int prognr);
short smReadProgs(short nSM, SMTVControl* control, char* dateiname);
int   smSearch(short nSM, SMTVControl* control, int frequenz, int system , int norm);
void  smSetAFCTable(short nSM, SMTVControl* control, SMAFCTable *aTable);
void  smSetAFCTableWithPreset(short nSM, SMTVControl* control, SMAFCTable *aTable, int aNorm, int aSystem);
short smSetChannel(short nSM, SMTVControl* control, int frequenz, int system , int norm);
short smSetMonoStereo(short nSM, SMTVControl* control, int monster);
short smSetProg(short nSM, SMTVControl* control, int prognr);
short smSetSearch(short nSM, SMTVControl* control, int deltafrequenz, int breite, int gewichtung);
short smSetVisible(short nSM, SMTVControl* control, short aBool, int prognr);
short smStatusAudio(short nSM, SMTVControl* control);
short smStatusTV(short nSM, SMTVControl* control);
short smStatusVT(short nSM, SMTVControl* control);
short smStoreProg(short nSM, SMTVControl* control, int prognr, int frequenz, int system, int norm);
short smStoreProgWithName(short nSM, SMTVControl* control, int prognr, int frequenz, int system, int norm,char* aName);
short smTunerType(short nSM, SMTVControl* control);
short smWriteProgs(short nSM, SMTVControl* control,char* dateiname);

/* Private Function Area */

short _sm_ChkNorm(short nSM, SMTVControl* control, int norm);
void  _smMyDelay(int ms);
void  _smAcqon (short nSM, SMTVControl* control);
void  _smAcqoff(short nSM, SMTVControl* control);

