#!/bin/sh

set -e
export GZIP=-9vn

test -f linux-faq.info  || gunzip linux-faq.info
test -f linux-faq.ps    || gunzip linux-faq.ps
rm -f linux-faq.source.tar{,.sig,.gz}

tar -vvcf linux-faq.source.tar \
	bfnnconv.pl m-{ascii,info,lout,html,post}.pl \
	linux-faq.bfnn html.refs changes.text linux-faq.readmesrc \
	buildsend.sh mktar.sh expirydate expirydate2 expirydatecc
pgp-auto +batchmode +force -sab linux-faq.source.tar
cat linux-faq.readmesrc linux-faq.source.tar.asc >linux-faq.README
gzip -f linux-faq.{info,ps} linux-faq.source.tar
tar -zvvcf linux-faq.tar.gz \
	linux-faq.{README,ascii} linux-faq.{info,ps}.gz \
	linux-faq.source.tar.gz
ls -FCl linux-faq.tar.gz
tar -f linux-faq.html.tar.gz -C linux-faq.html -zvvc `ls -1 linux-faq.html`
ls -FCl linux-faq.html.tar.gz
