.TH PLOTMTV L "March 17, 1993"
.SH NAME
plotmtv - fast multi-purpose plotting program for X11-windows 

.SH SYNOPSIS
.TP 8
.B
plotmtv
.na
[-P\fIprinter\fP]
.br
[-3d]
[-colorps]
[-debug]
[-landscape]
[-nodate]
[-noxplot]
[-o \fIpostscript-file\fP]
[-plotall]
[-print]
[-printcmd \fPprint_command\fP]
[-scale \fIscale\fP]
[-verbose]
.br
[-pbg \fIbackground_color\fP]
[-pfg \fIforeground_color\fP]
.br
[-<X11 options>]
.br
\fIdata-file1 data-file2 ...\fP
.ad

.SH DESCRIPTION
.LP
\fBPLOTMTV\fP is a fast and convenient X11 program for
visualization of scientific data. 
The program reads in data in the MTVDAT format 
and plots each dataset in the \fIdata-file\fP in turn. 
Each plot comes with a simple but functional
Graphical User Interface, which allows users
to zoom in or pan to areas of interest on the plot, or to toggle between 2D
and 3D plots. The plots may then be sent directly to a grayscale or color
PostScript
printer for hard-copy output.
.LP
\fBPLOTMTV\fP's capabilities include 2D line and scatter plots (x-vs-y),
contour plots, 3D surface, line and
scatter plots as well as vector plots.
The Graphical User Interface allows
interactive zoom and pan, toggling between 2D and 3D plots, rotating 3D
plots, and some (limited) customization of the resultant plots.
Through the GUI, one can also print the plot using the "Print" button,
or save the Postscript plot to a file using the "Print to File" button.
.LP
The X11 plot in \fBPLOTMTV\fP can also be controlled from the keyboard.
Pressing the "Q" key is a fast way of popping down the plot window.
For the 3D plot,
the viewing vector can be changed using the "H", "J", "K", "L" and "O" keys
on the the keyboard; the plot on the screen can be rotated
sideways using the "H" or "L" keys, rotated up or down using
the "J" and "K" keys, and drawn with the original viewing vector using "O".
The "A", "S", "D" and "F" keys will produce 90\(de rotations.
"Z" will plot the image projected on the x-y plane (z=constant),
"Y" will plot the image projected on the x-z plane (y=constant),
and "X" will plot the image projected on the y-z plane (x=constant).
.SH DATA FORMAT
.LP
\fBPLOTMTV\fP uses the MTVDAT data format, which is too long to describe in
this document.  
The data format is described fully in 
\fIThe MTV Plot Data Format\fP document.
.SH OPTIONS
.TP 5
.B \-P\fIprinter\fP
Specifies the printer to which to send the PostScript plot.
The default uses the printer name from the environment variable $PRINTER.
.IP
Note: \fBPLOTMTV\fP will send a PostScript file to the specified printer
\fIonly\fP if the size of the file is less than 1000Kbytes. This maximum
file size is due to the limitations of the UNIX \fBlpr\fP(1) command.
.TP 5
.B \-3d
Plots in 3D instead of the default 2D.
.TP 5
.B \-colorps
Instructs the PostScript renderer to include colors in the PostScript
description of the plot.  
By default, \fBPLOTMTV\fP produces gray-scale PostScript plots.
The color PostScript file produced with this option
may be printed out on a color
PostScript printer.  Be aware however that the same file will not print out
correctly on a black-and-white PostScript printer.
The color PostScript mode may also be set by setting 
the $MTV_PSCOLOR environment variable, i.e. "setenv MTV_PSCOLOR ON".
.TP 5
.B \-debug
Makes \fBPLOTMTV\fP extremely loquacious.
.TP 5
.B \-landscape
Prints the postscript plot in landscape mode (rotated).
.TP 5
.B \-nodate
Prints the postscript plot without a time/date stamp.
.TP 5
.B \-noxplot
Stops the program from starting up the X11 graphics routines.
The normal mode of operation is start up \fBPLOTMTV\fP from an
X-terminal or X-display and
interact with the graphics using the Graphical User Interface.
However, the "noxplot" option is also provided to allow the plots to be
directly drawn in PostScript, thus bypassing the X11 plotting routines.
This is particularly useful for batch-mode operation, where multiple plots
can be sent to a printer without user intervention.
.TP 5
.B \-plotall
Plots all the datasets found in a single plot. Useful for combining data
from different files.
.TP 5
.B \-print
Sends the POSTSCRIPT plot to the printer automatically.
Usually this is used together with the "-noxplot" option to produce
PostScript plots in batch, i.e. "plotmtv -noxplot -print datafile".
.TP 5
.B \-printcmd \fIprint_command\fP
Specifies the \fIprint_command\fP to be executed in sending a PostScript
plot to the printer. The default is the UNIX "lpr -h" command.
.TP 5
.B \-scale \fIscale\fP
Sets a plot scale factor.  This is used only for POSTSCRIPT plotting.
.TP 5
.B \-v
Makes \fBPLOTMTV\fP more talkative.
.TP 5
.B \-pfg \fIforeground_color\fP
.TP 5
.B \-pbg \fIbackground_color\fP
Sets the foreground and background colors in the \fBPLOTMTV\fP X11 Plot
Window.
.TP 5
.B \-display \fIhost:display.screen\fP
Opens a window on the given host and display
.TP 5
.B \-iconic
.TP 5
.B \-geom \fIgeometry\fP
.TP 5
.B \-rv
.TP 5
.B \-bw \fIborder-width\fP
.TP 5
.B \-bd \fIborder-color\fP
.TP 5
.B \-fg \fIforeground-color\fP
.TP 5
.B \-bg \fIbackground-color\fP
.TP 5
.B \-fn \fIfont-name\fP
Sets input options for the X-window system.
.TP 5
.B \fIdata-file1 data-file2...\fP
Specifies the MTVDAT data-file(s).

.SH ENVIRONMENT VARIABLES
.ta 2i
PRINTER	printer name for hardcopy (e.g. "hpps")
.br
MTV_PRINTER_CMD	name of the UNIX print command (e.g. "lpr -h")
.br
MTV_PSCOLOR	for color PostScript (e.g. "ON")

.SH HISTORY
.LP
\fBPLOTMTV\fP is based on the \fBDRAWPLOT\fP, \fBCONTOUR\fP and \fBPDRAW\fP 
programs from 
U.C. Berkeley (yes, I'm responsible for those too!). \fBPLOTMTV\fP essentially
combines all the capabilities of the three packages into one single package.

.SH BUGS/LIMITATIONS
.LP
The GUI is very limited.  The 3D viewing stuff is quite limited too;
hidden-surface removal is implemented as a simple painter's algorithm, so
large 3D polygons don't get plotted (with hidden-surfaces) correctly.
Also there are no perspective plots yet...

.SH AUTHOR
Kenny K.H. Toh (ktoh@td2cad.intel.com)

.SH FILES
\fIdataplot.ps\fP 	default PostScript file
.ta

.SH SEE ALSO
\fIThe MTV Plot Data Format\fP
