;;; To be used with NeXT Scorefile Package Version 3
(require :scorefile)
(use-package 'scorefile)
(score examp3 nil '(0 10.1))		; last note will be at time 10

(header "
envelope marcato   = [(0,0)(.1,1,2)(.2,.1)|(.3,0.0)];
envelope smooth   = [(0,0)(.1,1)|(.3,0.0)];
" )

(dotimes (i 3)				; Make a round of 3 parts
  (part nil	                        ; Generate names automatically
	("DBWave1vi" (headroom .2))       ; Here's the part info
	(list i (+ i 10))		; Time specification
	:noteDur
	
	;; all durs are .25 but note that actual note time is longer due to
	;; amp envelope release time (ampRel)
	(dur .25)               
	(dt '(cycle '(.5 .25 .75 .5)) :quiet) 
	(timetag (accumulate-durs dt))
	(freq  '(cycle (pitches d5 e f g a bf d6 e)))
	;; amp makes a cresc. then dim.
	(amp '(env '((0 26)(5 16)(6 16)(10 26))) :db)
	;; For longer notes, use a different envelope for more marcato
	(ampEnv '(if (> (pval dt) .3) "marcato" "smooth"))
	;; Attack gets shorter then longer again
	(ampAtt '(env '((0 .5)(5 .05)(10 .5))))
	;; Release gets longer then shorter again
	(ampRel '(env '((0 .1)(5 1.0)(10 .1))))
	;; Waveform cycles
	(waveform '(cycle '("SA" "SA" "SU")) :string :always)
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.0 (random 1.0)))
	(bearing (- (* i 45) 45))
	(rvibAmp .006)
	))

(write-score examp3)
(play)
