;;; To be used with NeXT Scorefile Package Version 3

(require :scorefile)
(use-package 'scorefile)
(score horn-chimes ((tempo 112) (samplingRate 44100)) 1 nil)

(header "
envelope ampFn1   = [(0,0)(.12,1,1.2)(.18,.7)(5,.8)|(5.05,0,1)];
envelope indFn1   = [(0,0)(.12,1,1.2)(.18,.7)(5,.8)|(5.05,0,1)];
envelope indFn2   = [(0,0)(.16,1,1.2)(.18,.7)(5,.8)|(5.05,0,1)];
envelope frqFn1   = [(0,.98)(.07,1.01)(.1,.995)(.14,1.002)(.18,1)(.2,1,.9)(5,1)|(5.05,.99,1)];
" )

(part horn1 ("Fm2pvi" (synthPatchCount 1)) 0 :noteOn
      (dur '(seq '(8.25 8.25 8.25 8.25 7.25 7.25 7.25 7.25 17 :end)))
      (time (accumulate-durs) :quiet)
      (timeTag '(max (+ (pval time) -.02 (random .04)) 0))
      (freq '(seq '(fs2 cs3 b2 e2 fs2 cs3 b2 e2 fs1)))
      (amp '(- (seq '(21 20 19 18  17 15.5 14 12.5 9.5)) 2.5) :db)
      (ampEnv "ampFn1")
      (m1Ratio 2)
      (ampfac '(/ (- 24 (pval amp)) 30) :quiet)
      (m1Ind1 '(+ (lookup (pval freq) '((0 1.6)(500 .75))) (pval ampfac)))
      (m1IndEnv "indFn1")
      (m2Ratio '(lookup2 (pval freq) '((0 5)(125 3)(250 1))))
      (m2Ind1 '(+ (lookup (pval freq) '((0 1.4)(500 .7))) (pval ampfac)))
      (m2IndEnv "indFn2")
      (rvibAmp .003)
      (svibAmp .008)
      (svibFreq '(+ 3.8 (random .4)))
      (wavelen 256)
      (bearing -35))

(part horn2 ("Fm2pvi" (synthPatchCount 1)) 0 :noteOn
      (dur '(seq '(8.25 8.25 8.25 8.25 7.25 7.25 7.25 7.25 17 :end)))
      (time (accumulate-durs) :quiet)
      (timeTag '(max (+ (pval time) -.02 (random .04)) 0))
      (freq '(seq '(fs3 cs4 b3 e3 fs3 cs4 b3 e3 fs2)))
      (amp '(+ (seq '(21 20 19 18  17 15.7 14.3 13 10)) 2) :db)
      (ampEnv "ampFn1")
      (m1Ratio 2)
      (ampfac '(/ (- 24.0 (pval amp)) 30.0) :quiet)
      (m1Ind1 '(+ (lookup (pval freq) '((0 1.6)(500 .75))) (pval ampfac)))
      (m1IndEnv "indFn1")
      (m2Ratio '(lookup2 (pval freq) '((0 5)(125 3)(250 1))))
      (m2Ind1 '(+ (lookup (pval freq) '((0 1.4)(500 .7))) (pval ampFac)))
      (m2IndEnv "indFn2")
      (rvibAmp .003)
      (svibAmp .008)
      (svibFreq '(+ 4.0 (random .4)))
      (wavelen 256)
      (bearing 35))

(header "
envelope ampFn3   = [(0,0)(.002,1)(13,0)|(13.02,0.0)];
envelope indFn3   = [(0,0)(.002,1)(10,0)|(10.02,0)];
waveTable chimeWave = [{1,1}{3,.06}];
" )

(part chime1 ("Fm1i" (synthPatchCount 1)) 0 :noteOn
      (dur '(seq '(8.25 8.25 8.25 8.25 7.25 7.25 7.25 7.25 17 :end)))
      (time (accumulate-durs) :quiet)
      (timeTag '(max (+ (pval time) -.02 (random .04)) 0))
      (freq '(seq '(fs4 cs5 b4 e4 fs4 cs5 b4 e4 fs4)))
      (amp '(- (seq '(17 16 15 14  13 11.7 10.3 9 6)) 2)  :db)
      (ampEnv "ampFn3")
      (m1Ratio '(+ 1.4995 (random .0005)))
      (m1Ind1 '(lookup (eval (pval freq))
		      '((92 6)(185 4.6)(370 3.2)(740 1.7)(1480 .3))))
      (m1IndEnv "indFn3")
      (waveform "chimeWave" :string)
      (wavelen 256)
      (bearing 45))

(part chime2 ("Fm1i" (synthPatchCount 1)) 0 :noteOn
      (dur '(seq '(8.25 8.25 8.25 8.25 7.25 7.25 7.25 7.25 17 :end)))
      (time (accumulate-durs) :quiet)
      (timeTag '(max (+ (pval time) -.02 (random .04)) 0))
      (freq '(* (seq '(fs4 cs5 b4 e4 fs4 cs5 b4 e4 fs4)) 2))
      (amp '(+ (seq '(15 14 13 12  11 9.7 8.3 7 5)) .5) :db)
      (ampEnv "ampFn3")
      (m1Ratio '(+ 1.500 (random .0005)))
      (m1Ind1 '(lookup (eval (pval freq))
		      '((92 6)(185 4.6)(370 3.2)(740 1.7)(1480 .3))))
      (m1IndEnv "indFn3")
      (waveform "chimeWave" :string)
      (wavelen 256)
      (bearing -45))

(write-score horn-chimes "horn-chimes.score")
(play)
