/* TCP Network Objects -- Methods
   by Ian Smith 
   of The Software Engineering Research Center's Multimedia Lab */

@interface network_tcp:Object
{
  int sock;
  int fd;
}

- (int) initialize;
- (int) setup:(int)port;
- (int) receive;
- (int) call:(char *)target onport:(int)port;
- (int) send_text:(char *)string;
- (int) send_data:(void *)data ofsize: (int) size;
- (int) send_file:(char *)fname;
- (int) recv_text:(char *)string;
- (int) recv_data:(void *)data ofsize: (int *)size;
- (int) recv_file:(char *)fname;
- (int) call_waiting;
- (int) data_waiting;
- (int) close_tcp;

@end
