/* Generated by Interface Builder */

#include <stdio.h>

#import "TwoDView.h"
#import <math.h>
#import <appkit/appkit.h>
#import <appkit/Matrix.h> /* XXX */
#import <appkit/Form.h> /* XXX */
#import <appkit/nextstd.h>
#include <dpsclient/wraps.h>

#define DEBUG 1

#ifdef DEBUG
#define DEBUGPRINTF(x) fprintf(stderr,x);
#define IFDEBUG(x) x
#else
#define DEBUGPRINTF(x) ;
#define IFDEBUG(x)
#endif

/* operation codes. these integers correspond to the selectedRow of the
   radioButton Matrix. */

#define OP_PRIM_MST 0
#define OP_KRUSKAL_MST 1
#define OP_JARVIS_HULL 2
#define OP_GRAHAM_HULL 3
#define OP_VORONOI_DIAGRAM 4
#define OP_DELAUNAY_TRIANGULATION 5

@implementation TwoDView

+ newFrame:(NXRect *)frameRect
{
  self = [super newFrame:frameRect];
  maxNumPoints=0;
  [self setScaling];
  numPoints=10;
  [self random:0];
  operation=OP_PRIM_MST; /* default operation */
  autoUpdate=1; /* on by default */
  return self;
}

- (BOOL)acceptsFirstResponder { return YES; }

- mouseDown:(NXEvent *)theEvent
{
  NXPoint where = theEvent->location;
  NXRect r;
  float x,y;
  [self convertPoint:&where fromView:nil];
  x=(where.x-dx)/xsize;
  y=(where.y-dy)/ysize;
  if (numPoints==maxNumPoints) {
    maxNumPoints+=100;
    NX_REALLOC(data,float,maxNumPoints);
    };
  data[numPoints*2]=x;
  data[numPoints*2+1]=y;
  numPoints++;
  /* attempt to update the 'number of points' form with the correct
     value. Unfortunately, this doesn't work until AFTER the user has
     entered a number into the form and hit RETURN, since that's when
     the TwoDView can find the Form's id.  */
  if (numPointsForm) {
    [numPointsForm setIntValue:numPoints at:0];
    [numPointsForm selectTextAt:0];
    [numPointsForm drawCellAt:0];
    };
  [self lockFocus];
  PSsetgray(NX_WHITE);
  NXSetRect(&r,where.x,where.y,2.0,2.0);
  NXRectFill(&r);
  [self unlockFocus];
  if (autoUpdate) [self go:(void *)0];
  return self;
}

- free
{
  NX_FREE(data);
  [super free];
  return self;
}

- setOperation:(Matrix *)sender
{
    operation=[sender selectedRow];
    return self;
}

- setNumPoints:(Form *)sender
{
  int n=[sender intValueAt:0];
  numPoints = n;
  if (n>maxNumPoints) maxNumPoints=numPoints+100;
  [self random:(void *)1]; /* ??? */
  [sender selectTextAt:0];
  numPointsForm=sender;
  return self;
}

- setAutoUpdate:(Button *)sender
{
  autoUpdate = [sender state];
  return self;
}

/* set the scale factors used in drawing. */
- setScaling
{
  NXRect r;
  [self getBounds:&r];
  xsize=0.9*r.size.width;
  ysize=0.9*r.size.height;
  dx=0.05*r.size.width;
  dy=0.05*r.size.height;
  return self;
}

/* create a list of 2D points to demonstrate the algms on. */

extern long random(void);

- random:sender
{
    int i;
    if(data) NX_FREE(data);
    NX_MALLOC(data,float,maxNumPoints*2);
    for(i=0;i<numPoints*2;i++) data[i]=1.0*(random()&65535)/65536.0;
    if (sender) {
      [self lockFocus];
      [[self erase] display];
      };
    return self;
}

/* This method is invoked when the user bangs on the Go button. */

- go:sender
{
    [NXwait push];
    [self lockFocus];
    [self  erase];
    [self  display];
    switch(operation) {
      case OP_PRIM_MST: [self doPrimMST]; break;
      case OP_KRUSKAL_MST: [self doKruskalMST]; break;
      case OP_JARVIS_HULL: [self doJarvisHull]; break;
      case OP_GRAHAM_HULL: [self doGrahamHull]; break;
      case OP_VORONOI_DIAGRAM: [self doVoronoiDiagram]; break;
      case OP_DELAUNAY_TRIANGULATION: [self doDelaunayTriangulation]; break;
      }
    [self unlockFocus];
    [NXwait pop];
    return self;
}

/* globals for Kruskal */
float *length;

int ycompar(p1,p2)
  int *p1,*p2;
  {
    float l1=length[*p1],l2=length[*p2];
    if (l1<l2) return -1;
    if (l1>l2) return 1;
    return 0;
  }

float cost(p1,p2) /* squared Euclidean distance between 2 2D points */
  float *p1,*p2;
  {
    register float x1,x2,y1,y2;
    x1= p1[0]; y1=p1[1];
    x2= p2[0]; y2=p2[1];
    return((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
  }

/*
  XXX
       THIS IMPLEMENTATION IS NOT OPTIMAL
  XXX
*/

- doKruskalMST
{
  int *group,groupindex=1;
  int *edge,*edgptr,*index,idx;
  int i;
  float *lptr;
  char *used;

  NX_MALLOC(edge,int,numPoints*(numPoints-1));
  edgptr=edge;
  NX_MALLOC(length,float,numPoints*(numPoints-1)/2);
  lptr=length;
  /* fill in edge endpoint and length arrays */
  for(i=0;i<numPoints-1;i++) {
    int j;
    for(j=i+1;j<numPoints;j++) {
      *edgptr++ = i;
      *edgptr++ = j;
      *lptr++ = cost(&data[i*2],&data[j*2]);
      };
    };
  NX_MALLOC(index,int,numPoints*(numPoints-1)/2);
  for(i=0;i<numPoints*(numPoints-1)/2;i++) index[i]=i;
  /* sort edges */
  qsort(index,numPoints*(numPoints-1)/2,sizeof(int),ycompar);

  NX_MALLOC(group,int,numPoints);
  bzero(group,numPoints*sizeof(int));
  
  /* Algorithm:
     FOR i = 1 to n-1 
       Add (to the tree) the shortest edge that does not form a circuit in
       the tree.
     ROF
  */
  PSsetgray(NX_WHITE);
  idx=0;
  for(i=0;i<numPoints-1;i++) {
    char flag=FALSE;
    while (!flag) { /* look for an edge */
      int j;
      int v1=edge[index[idx]*2],g1=group[v1];
      int v2=edge[index[idx++]*2+1],g2=group[v2];
      [self setInstanceMode:TRUE];
      [self drawEdge:v1:v2];
      if ((!g1&&!g2)||(g1!=g2)) {
        flag=TRUE;
        /* add the edge to the tree. */
        [self setInstanceMode:FALSE];
        [self drawEdge:v1:v2];
        /* update group info. */
        if (g1&&!g2) group[v2]=g1;
        else if(g2&&!g1) group[v1]=g2;
        else if (!g1 && !g2) group[v1]=group[v2]=groupindex++;
        else  /* relabel all g2's to g1 */
          for(j=0;j<numPoints;j++) if (group[j]==g2) group[j]=g1;
        };
      };
    };
  NX_FREE(group);
  NX_FREE(index);
  NX_FREE(length);
  NX_FREE(edge);
  return self;
}


float signedarea(x1,y1,x2,y2,x3,y3)
  float x1,x2,x3,y1,y2,y3;
  {
    float x;
    x=x1*y2+x3*y1+x2*y3-x3*y2-x1*y3-x2*y1;
    return(x);
  }

- doJarvisHull
{
/* Jarvis' march for planar convex hull - From Preparata and Shamos */
  float ymax= -3.0e30,ymin=3.0e30,y,best_x,best_y,candidate_x,candidate_y;
  float current_x,current_y,a;
  int i;
  int *pointers;
  int nh;
  int current_index,best_index;
  int min_index,max_index;
  char *used;
  /* 0. set up storage for indices */
  PSsetgray(NX_WHITE);
  [self setInstanceMode:TRUE];
  NX_MALLOC(used,char,numPoints);
  NX_MALLOC(pointers,int,numPoints);
  /* 1. find min & max in y-coordinate */
  for(i=0;i<numPoints;i++) {
    y= data[i*2+1];
    if (y<ymin) { ymin=y; min_index=i; };
    if (y>ymax) { ymax=y; max_index=i; };
    };
  nh = 1;
  pointers[0]=min_index; /* first hull vertex */ 
  current_index=min_index;
  for(i=0;i<numPoints;i++) used[i]=FALSE;
  /* 2. Jarvis' march - min to max */ 
  while (current_index!=max_index) {
    used[current_index]=TRUE;
    current_x= data[2*current_index];
    current_y= data[2*current_index+1];
    best_x= current_x;
    best_y= current_y;
    for(i=0;i<numPoints;i++) if (!used[i]) {
      candidate_x= data[2*i];
      candidate_y= data[2*i+1];
      [self drawEdge:current_index:i];
      a=signedarea(current_x,current_y,candidate_x,candidate_y, best_x,best_y);
      if (a>=0.0)
        { best_index=i; best_x=candidate_x; best_y=candidate_y;};
      };
    pointers[nh++] = current_index = best_index;
    };
  /* 3. Jarvis' march - max to min */
  used[min_index]=FALSE;
  while (current_index!=min_index) {
    used[current_index]=TRUE;
    current_x= data[2*current_index];
    current_y= data[2*current_index+1];
    best_x=current_x;
    best_y=current_y;
    for(i=0;i<numPoints;i++)  if (!used[i]) {
      candidate_x= data[2*i];
      candidate_y= data[2*i+1];
      [self drawEdge:current_index:i];
      a=signedarea(current_x,current_y,candidate_x,candidate_y, best_x,best_y);
      if (a>=0.0)
        { best_index=i; best_x=candidate_x; best_y=candidate_y;};
      };
    pointers[nh++] = current_index = best_index;
    };
  nh--;
  NX_FREE(used);
  [self setInstanceMode:FALSE];
  for(i=0;i<nh-1;i++) [self drawEdge:pointers[i]:pointers[i+1]];
  [self drawEdge:pointers[0]:pointers[nh-1]];
  NX_FREE(pointers);
  return self;
}

/* Graham-hull utils */

int quadrant(x,y)
  float x,y;
  {
    if (x<0.0)
      if (y<0.0) return(3);
      else return(2);
    else
      if (y<0.0) return(4);
      else return(1);
  }

float mx,my; /* used in xcompar and doJarvisHull */
float *doodah; /* ??? can't use instance vbls in plain-C units ??? */
id selph; /* ??? */

int xcompar(pp1,pp2) /* used in Graham scan to sort points by polar angle */
  int *pp1,*pp2;
  {
    int p1,p2,q1,q2;
    float x1,x2,y1,y2,a;
    p1= *pp1; p2= *pp2;
    x1= doodah[p1*2]-mx; y1= doodah[p1*2+1]-my;
    x2= doodah[p2*2]-mx; y2= doodah[p2*2+1]-my;
    q1=quadrant(x1,y1); q2=quadrant(x2,y2);
    if (q1<q2)  return(-1);
    if (q2<q1)  return(1);
    a=signedarea(0.0,0.0,x2,y2,x1,y1);
    if (a<0.0) return(-1);
    if (a==0.0) return(0);
    return(1);
  }

void triangle(i1,i2,i3)
  int i1,i2,i3;
  {
    [selph setInstanceMode:TRUE];
    [selph drawEdge:i1:i2];
    [selph drawEdge:i1:i3];
    [selph drawEdge:i2:i3];
  }


float signedarea2(p1,p2,p3)
  int p1,p2,p3;
  {
    float x1,y1,x2,y2,x3,y3,x;
    x1= doodah[p1*2]; y1= doodah[p1*2+1];
    x2= doodah[p2*2]; y2= doodah[p2*2+1];
    x3= doodah[p3*2]; y3= doodah[p3*2+1];
    x=signedarea(x1,y1,x2,y2,x3,y3);
    return(x);
  }

- doGrahamHull
{
  /* Graham's scan for planar convex hull. From Preparata and Shamos */
  int i,mindex,start,prev,current,next,nnext,x,y;
  int t1,t2,t3;
  float a,minx,xx;
  int *pointers;
  int nh;

  PSsetgray(NX_WHITE);
  /* THIS IS GROSS. */
  doodah = data;
  selph=self;

  NX_MALLOC(pointers,int,numPoints);
  nh=numPoints;
  /* find point in hull interior (avg. of 1st 3 points will do)*/
  mx=0.0; my=0.0; minx=999;
  for(i=0;i<3;i++) {
    mx += data[i*2];
    my += data[i*2+1];
    };
  mx /= 3.0;
  my /= 3.0;
  for(i=0;i<numPoints;i++) {
    xx= data[i*2];
    if (xx<minx) { minx=xx; mindex=i;};
    };
  /* sort points by polar angle and distance */
  for(i=0;i<numPoints;i++)  pointers[i]=i;
  qsort(pointers,numPoints,sizeof(int),xcompar);
  for(i=0;i<numPoints;i++) if (pointers[i]==mindex) break;
  start=current=i; /* point i is a hull vertex. */
  /* set up pointers in linked list */
  prev=(current==0)?nh-1:current-1;
  next=(current==nh-1)?0:current+1;
  nnext=(next==nh-1)?0:next+1;
  /* loop over all points */
  while(pointers[next]!=pointers[start]) {
    if (nh==3) break; /* triangle is ALWAYS a convex polygon */
    t1= pointers[current]; t2= pointers[next]; t3= pointers[nnext];
    triangle(t1,t2,t3);
    a=signedarea2(t1,t2,t3);
    if (a<0.0) { /* delete next vertex */
      for(i=next+1;i<nh;i++) pointers[i-1]= pointers[i];
      nh--;
      if (start>=next) start--;
      if (current>=next) current--;
      if (current != start) {
        /* back up one vertex in list */
        current --;
        if (current<0) current += nh;
        prev=(current==0)?nh-1:current-1;
        next=(current==nh-1)?0:current+1;
        nnext=(next==nh-1)?0:next+1;
        }
      else { /* do not back up if current vertex is starting vertex. */
        prev=(current==0)?nh-1:current-1;
        next=(current==nh-1)?0:current+1;
        nnext=(next==nh-1)?0:next+1;
        };
      }
    else { /* move forward in linked list */
      prev=current;
      current=next;
      next=(next==nh-1)?0:next+1;
      nnext=(next==nh-1)?0:next+1;
      };
    };
  [self setInstanceMode:FALSE];
  for(i=0;i<nh-1;i++) [self drawEdge:pointers[i]:pointers[i+1]];
  [self drawEdge:pointers[0]:pointers[nh-1]]; 
  NX_FREE(pointers);
  return self;
}

- doVoronoiDiagram
{
  fprintf(stderr,"Voronoi Diagram\n");
}

- doDelaunayTriangulation
{
  fprintf(stderr,"Delaunay Triangulation\n");
}



- doPrimMST
{
  /* Prim's quadratic MST algorithm - from Horowitz & Sahni */
  int *t,*near;
  int i,j,k,l;
  float mincost,x,xmin;
  NX_MALLOC(t,int,(numPoints-1)*2);
  NX_MALLOC(near,int,numPoints);
  bzero(t,(numPoints-1)*2*sizeof(int));
  bzero(near,numPoints*sizeof(int));
  mincost=10000000000.0;
  PSsetgray(NX_WHITE);
  NXPing();
  [self setInstanceMode:TRUE];
  /* find shortest edge (O(n^2 time)) */
  for(i=0;i<numPoints-1;i++)
   for(j=i+1;j<numPoints;j++) {
     x=cost(&data[i*2],&data[j*2]);
     [self drawEdge:i:j];
     if (x<mincost) { mincost=x; k=i; l=j; };
     [self drawEdge:i:j];
     };
  /* (k,l) is the first edge in the MST */
  [self setInstanceMode:FALSE];
  [self drawEdge:k:l];
  t[0]=k; t[1]=l;
  /* set up initial nearest-neighbor array for k and l */
  for(i=0;i<numPoints;i++)
    if (cost(&data[i*2],&data[l*2])<cost(&data[i*2],&data[k*2]))
      near[i]=l;
    else
      near[i]=k;
  near[k]= near[l]= -1;
  /* add the remaining n-2 edges */
  for(i=1;i<numPoints-1;i++) {
    xmin=100000000000.0;
    for(k=0;k<numPoints;k++) 
      if (near[k]!= -1) {
        x=cost(&data[k*2],&data[near[k]*2]);
        if (x<xmin) { xmin=x; j=k;};
        };
    t[i*2] = j; t[i*2+1]= near[j];
    [self drawEdge:j:near[j]];
    mincost += xmin;
    near[j]= -1;
    for(k=0;k<numPoints;k++)
      if (near[k]!= -1)
        if (cost(&data[k*2],&data[near[k]*2]) > cost(&data[k*2],&data[j*2]))
          near[k]=j;
    };
  NX_FREE(t);
  NX_FREE(near);
  return self;
}

- setInstanceMode:(BOOL)flag
{
  PSnewinstance();
  PSsetinstance(flag);
  instanceMode=flag;
  return self;
}

- erase
{
  NXRect r;
  [self getBounds:&r];
  PSsetgray([self backgroundGray]);
  NXRectFill(&r);
  return self;
}

- drawSelf:(NXRect *)rects:(int)rectCount
{
  int i;
  [self setScaling]; /* handle possible resizing. */
  PSsetgray([self backgroundGray]);
  for(i=0;i<rectCount;i++) NXRectFill(&rects[i]);
  PSsetgray(NX_WHITE); /* XXX */
  for(i=0;i<numPoints;i++) {
    float x=rint(dx+data[i*2]*xsize);
    float y=rint(dy+data[i*2+1]*ysize);
    NXRect r;
    NXSetRect(&r,x,y,2.0,2.0);
    NXRectFill(&r);
    };
  return self;
}

-drawEdge:(int)i:(int)j
{
  if (instanceMode) { PSnewinstance(); PSsetinstance(TRUE);};
  PSmoveto(dx+data[i*2]*xsize,dy+data[i*2+1]*ysize);
  PSlineto(dx+data[j*2]*xsize,dy+data[j*2+1]*ysize);
  PSstroke();
  NXPing();
  return self;
}

@end
