/* EPS file previewer using the DPS library */

#include <ansi.h>
#include <libc.h>
#include <dpsclient/dpsclient.h>

int strisub(char *a,char *b) {	/* Check for substring, case independent */
    while (*a) {
	if (!*b || tolower(*a)!=tolower(*b)) return(0);
	++a;
	++b;
	}
    return(1);
    }

void printjunk(DPSContext ctxt, const char *buf, long unsigned int count)
{
    unsigned char c;
    while (count--) {
	c = *buf++;
	if (c < ' ' && c != '\n') {putchar('^'); c ^= 0x40;}
	putchar(c);
	}
    }

void myerrorproc(
    DPSContext ctxt,
    DPSErrorCode errorCode,
    long unsigned int arg1,
    long unsigned int arg2 )
    {
    if (errorCode == 1000) {
	printf("%%%%[ %.*s: %.*s; OffendingCommand: %.*s ]%%%%\n",
	       *(short *)(arg1+14),*(char **)(arg1+16)+arg1+4,
	       *(short *)(arg1+22),*(char **)(arg1+24)+arg1+4,
	       *(short *)(arg1+30),*(char **)(arg1+32)+arg1+4);
	}
    else {
	printf("DPS Error %d:\n",errorCode);
	printjunk(ctxt,(char *)arg1,arg2);
	putchar('\n');
	}
    }

int main(int argc,char **argv) {
    DPSContext d;
    int fd,l,x,i,windows;
    float llx,lly,urx,ury,scale,inches;
    char *p, *e, *fname;
#define BUFLEN 1024
    char buf[BUFLEN];
    NXEvent event;

    if (argv[1] && argv[1][0] == '-') {i=2; inches=atof(argv[1]+1);}
    else {i=1; inches=0;}

    d = DPSCreateContext(0,0,printjunk,myerrorproc);
    DPSPrintf(d,"/showpage {initgraphics} bind def\n");
    windows = 0;

    if (i>=argc) {fd = 0; fname = "stdin"; goto PIPED;}

    for (; i < argc; i++) {

	fname = argv[i];
	fd = open(fname,0);
	if (fd<0) {printf("%s: %s\n",fname,strerror(errno)); continue;}

    PIPED:
	llx=lly=0; urx=612; ury=792;	/* size of LaserWriter page */

	e = buf+read(fd,buf,BUFLEN);
	if (buf[0] != '%' || buf[1] != '!') {
	    printf("%s is not an EPS file.\n",fname);
	    goto DONE;
	    }

	p = buf;
	while(1) {
	    while (p<e && *p != '%') p++;
	    if (p > e-80) {
		x = e-p;
		memmove(buf,p,x);
		e = buf+x+read(fd,buf+x,BUFLEN-x);
		p = buf;
		if (p >= e) {printf("%s has no %%%%BoundingBox.\n",fname); goto DONE;}
		}
	    if (strisub("%%boundingbox:",p)) break;
	    p++;
	    }

	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	llx = atof(e);
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	lly = atof(e);
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	urx = atof(e);
	while ((*p < '0' || *p > '9') && *p != '-') p++;
	e = p; while (*p > ' ') p++; *p = 0;
	ury = atof(e);
/*	printf("%%BoundingBox %g %g %g %g\n",llx,lly,urx,ury); */
	if (urx<=llx) urx = llx+612;
	if (ury<=lly) ury = lly+792;

DONE:	urx-=llx; ury-=lly;
	scale = inches ? 72*inches/(urx>ury?urx:ury) : 1.0;
	lseek(fd,0L,0);
	windows++;
	DPSPrintf(d,"%d dup %g %g 0 window\n"
		  "windowdeviceround\n"
		  "1 0 currentwindow orderwindow\n",
		  windows*20,rint(urx*scale),rint(ury*scale));
	DPSPrintf(d,"%d currentwindow seteventmask\n",
		  NX_LMOUSEDOWNMASK+NX_RMOUSEDOWNMASK);
	DPSPrintf(d,"0 1 %g %g rectstroke\n",rint(urx*scale)-1,rint(ury*scale)-1);
	DPSPrintf(d,"/_the_saved_vm_ save def\n");
	if (inches) DPSPrintf(d,"%g dup scale\n",scale);
	DPSPrintf(d,"%g %g translate\n",-llx,-lly);
	while ((l=read(fd,buf,BUFLEN))>0) DPSWriteData(d,buf,l);
	DPSPrintf(d,"\ngrestoreall _the_saved_vm_ restore\n");
	close(fd);
	}

    while (windows) {
	DPSFlushContext(d);
	DPSGetEvent(d,&event,-1,NX_FOREVER,0);
	if (event.type == NX_RMOUSEDOWN) {
	    DPSPrintf(d,"%d termwindow\n",event.window);
	    windows--;
	    }
	else if (event.type == NX_LMOUSEDOWN) {
	    DPSPrintf(d,
		      "1 0 %d orderwindow\n"
		      "{%d stilldown not {exit} if\n"
		      "workspaceWindow currentmouse %g sub exch %g sub exch\n"
		      "%d movewindow} loop\n",
		      event.window,event.data.mouse.eventNum,
		      event.location.y,event.location.x,event.window);
	    }
	}
/*  DPSDestroyContext(d); */
    return(0);
    }
