/*	pasteboard.c

	Unix utility to pipe stuff from/to the pasteboard.

	Normally this dumps the (ascii) contents of the pasteboard to
	the output.  For instance "pasteboard > foo" will put the
	pasteboard in the file foo.

	If the stdin is not a terminal, it will instead take stdin and
	put it in the pasteboard.  "pasteboard < foo" will thus take
	a file and put it in the pasteboard.

	Switches:

	pasteboard "type"
		Uses a different data type slot than ASCII.  The type
		is a long string like "NeXT tiff pasteboard type".
	pasteboard -
		List the types available in the pasteboard.

	Written by Bill Spitzak, July 1990
	SPITZAK @ MCIMAIL.COM

------------- notes on the code: --------------

	Unfortunately, those occasionally egocentric people at NeXT have
	inextricably mixed the true interface to the pasteboard into
	the "Application" object in their library.  This is completely
	wrong, as the "Application" is only to create their style
	of windows on the screen.  It would be just as legitimate to
	require the Application object to read and write files.  (The
	same problem is true of the interface to the Workspace, since
	it ought to be legal to make a program that can be launched, yet
	creates no windows and contains no UI code).

	While they were at it, they seem to have suffered an incredible
	paranoia at "name collisions" and have come up with names like
	"NeXT Pasteboard Server, version 46" and "NeXT plain ascii
	pasteboard type".  Comon, you guys, have a little common sense!
	There is absolutely no reason for these two strings to not be
	"pasteboard" and "ASCII".  Hard as it is to believe, a program
	may want to do something other than compare these strings to
	literal constants!

	This uses what code is available from the shared libraries, so
	they can alter the interface somewhat and it will still work.
	The _NXxxx routines are in libNeXT_s.a, and that this
	must be linked in.  These routines are produced by the "mig"
	Mach Interface Generator, and do msg_rpc calls to Mach to talk
	to the Pasteboard server.  The extern char * points at constant
	strings such as the aforementioned "NeXT ASCII Pasteboard type".

*/

#include <stdio.h>
#import <sys/port.h>
#import <sys/message.h>

int AppkitServerPort;
int AppkitServerVersion;
static char new;

extern char *NXAsciiPboard;
extern char *_NXSmartPaste;
extern char *NXPostScriptPboard;
extern char *NXTIFFPboard;
extern char *NXRTFPboard;

/* map differences between how you call mig in new and old libraries: */
static int call(f,a1,a2,a3,a4,a5,a6)
int (*f)();
{
    if (new) return(f(60000,
		      AppkitServerPort,
		      "NeXT selection pasteboard name",
		      a1,a2,a3,a4,a5,a6));
    else return(f(AppkitServerPort,a1,a2,a3,a4,a5,a6));
    }

main(int argc, char **argv)
{
    int r,changecount;
    char *type; int list;
    extern int name_server_port,task_self_;
    extern int _NXGetSession();
    extern int _NXGetTypes();
    extern int _NXBlockingGetData();
    extern int _NXSetTypes();
    extern int _NXSetData();

    list = FALSE; type = NXAsciiPboard;
    for (r = 1; r < argc; r++) {
	if (argv[r][0] == '-') list = TRUE;
	else type = argv[r];
	}

    new = FALSE;
    r = netname_look_up(name_server_port,"",
			"NeXT Pasteboard Server, version 46",
			&AppkitServerPort);
    if (r) {
	new = TRUE;
	r = netname_look_up(name_server_port,"",
			"NeXT Pasteboard Server",
			&AppkitServerPort);
	}
    if (r) {
	fprintf(stderr,"Can't connect to Pasteboard, %s\n",mach_error_string(r));
	exit(1);
	}

#if 0	/* code in warp3, but serves no discernable purpose */
    _NXPBSRendezVous(0x7fffffff,AppkitServerPort,atoi("34.2"),&AppkitServerVersion);
    puts("RendezVous is done.");
#endif

    if (list) {
	char *typebuf,*c; int typelength,numtypes,n;
	r = call(_NXGetTypes,&typebuf,&typelength,&numtypes,&changecount);
	for (c=typebuf, n=numtypes; n>0; n--) {puts(c); while (*c++);}
	r = vm_deallocate(task_self_,typebuf,typelength);
	}

    else if (isatty(0)) {	/* send pasteboard to stdout */
	char *buf; int length;
	r = call(_NXGetSession,&changecount);
	r = call(_NXBlockingGetData,type,changecount,&buf,&length,&changecount);
	write(1,buf,length);
	vm_deallocate(task_self_,buf,length);
	}

    else {			/* send stdin to pasteboard */
	void *buf;
	int bufsize,length;
	buf = (void *)malloc(bufsize = 8192); length = 0;
	for (;;) {
	    length += read(0,buf+length,bufsize-length);
	    if (length < bufsize) break;
	    buf = (void *)realloc(buf,bufsize+=8192);
	    }
	r = call(_NXSetTypes,0,0,type,strlen(type)+1,1,&changecount);
	r = call(_NXSetData,changecount,type,buf,length,&changecount);
	}

    }
